/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.ontology_manager.impl.local;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import psidev.psi.tools.ontology_manager.impl.OntologyTermImpl;
import psidev.psi.tools.ontology_manager.impl.local.Ontology;
import psidev.psi.tools.ontology_manager.impl.local.OntologyImpl;
import psidev.psi.tools.ontology_manager.impl.local.OntologyLoaderException;
import uk.ac.ebi.ook.loader.impl.AbstractLoader;
import uk.ac.ebi.ook.loader.parser.OBOFormatParser;
import uk.ac.ebi.ook.model.interfaces.TermRelationship;
import uk.ac.ebi.ook.model.ojb.TermBean;

public class OboLoader
extends AbstractLoader {
    public static final Log log = LogFactory.getLog(OboLoader.class);
    private static final String ONTOLOGY_REGISTRY_NAME = "ontology.registry.map";
    private File ontologyDirectory;
    private boolean keepDownloadedOntologiesOnDisk = true;

    public OboLoader(File ontologyDirectory) {
        this.ontologyDirectory = ontologyDirectory;
    }

    public boolean isKeepDownloadedOntologiesOnDisk() {
        return this.keepDownloadedOntologiesOnDisk;
    }

    public void setKeepDownloadedOntologiesOnDisk(boolean keepDownloadedOntologiesOnDisk) {
        this.keepDownloadedOntologiesOnDisk = keepDownloadedOntologiesOnDisk;
    }

    protected void configure() {
        logger = Logger.getLogger(OboLoader.class);
        this.parser = new OBOFormatParser();
        this.ONTOLOGY_DEFINITION = "PSI MI";
        this.FULL_NAME = "PSI Molecular Interactions";
        this.SHORT_NAME = "PSI-MI";
    }

    protected void parse(Object params) {
        try {
            Vector<String> v = new Vector<String>();
            v.add((String)params);
            ((OBOFormatParser)this.parser).configure(v);
            this.parser.parseFile();
        }
        catch (Exception e) {
            logger.fatal((Object)("Parse failed: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void printUsage() {
    }

    private OntologyImpl buildOntology() {
        OntologyImpl ontology = new OntologyImpl();
        for (TermBean term : this.ontBean.getTerms()) {
            OntologyTermImpl ontologyTerm = new OntologyTermImpl(term.getIdentifier(), term.getName());
            ontology.addTerm(ontologyTerm);
            if (!term.isObsolete()) continue;
            ontology.addObsoleteTerm(ontologyTerm);
        }
        for (TermBean term : this.ontBean.getTerms()) {
            if (term.getRelationships() == null) continue;
            for (TermRelationship relation : term.getRelationships()) {
                ontology.addLink(relation.getObjectTerm().getIdentifier(), relation.getSubjectTerm().getIdentifier());
            }
        }
        return ontology;
    }

    public Ontology parseOboFile(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " doesn't exist.");
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " could not be read.");
        }
        this.configure();
        this.parse(file.getAbsolutePath());
        this.process();
        return this.buildOntology();
    }

    private File getRegistryFile() throws OntologyLoaderException {
        File[] registry = this.ontologyDirectory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return OboLoader.ONTOLOGY_REGISTRY_NAME.equals(pathname.getName());
            }
        });
        if (registry.length == 1) {
            File validatorRegistry = registry[0];
            return validatorRegistry;
        }
        return new File(this.ontologyDirectory.getAbsolutePath() + File.separator + ONTOLOGY_REGISTRY_NAME);
    }

    public Ontology parseOboFile(URL url) throws OntologyLoaderException {
        if (url == null) {
            throw new IllegalArgumentException("Please give a non null URL.");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("User work directory: " + this.ontologyDirectory.getAbsolutePath()));
            log.info((Object)("keepTemporaryFile: " + this.isKeepDownloadedOntologiesOnDisk()));
        }
        if (this.ontologyDirectory == null) {
            throw new IllegalStateException();
        }
        if (!this.ontologyDirectory.exists()) {
            throw new IllegalStateException();
        }
        if (!this.ontologyDirectory.canWrite()) {
            throw new IllegalStateException();
        }
        File ontologyFile = null;
        HashMap<URL, String> registryMap = null;
        File registryFile = this.getRegistryFile();
        if (null != registryFile) {
            try {
                if (registryFile.length() > 0L) {
                    ObjectInputStream ois = new ObjectInputStream(new FileInputStream(registryFile));
                    registryMap = (HashMap<URL, String>)ois.readObject();
                    if (registryMap != null) {
                        if (registryMap.containsKey(url)) {
                            ontologyFile = new File((String)registryMap.get(url));
                            if (ontologyFile.exists() && ontologyFile.canRead()) {
                                if (log.isInfoEnabled()) {
                                    log.info((Object)("Reuse existing cache: " + ontologyFile.getAbsolutePath()));
                                }
                            } else {
                                if (log.isInfoEnabled()) {
                                    log.info((Object)("Could not find " + ontologyFile.getAbsolutePath()));
                                }
                                registryMap.remove(url);
                                log.info((Object)"Saving registry file...");
                                File f = this.getRegistryFile();
                                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
                                oos.writeObject(registryMap);
                                oos.flush();
                                oos.close();
                            }
                        }
                    } else {
                        log.info((Object)"could not deserialize the Map");
                    }
                } else {
                    log.info((Object)"The file is empty");
                }
            }
            catch (IOException e) {
                log.error((Object)"Error while deserializing the map", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)"Error while deserializing the map", (Throwable)e);
            }
        }
        try {
            if (ontologyFile == null || !ontologyFile.exists() || !ontologyFile.canRead()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Loading URL: " + url));
                }
                URLConnection con = url.openConnection();
                int size = con.getContentLength();
                if (log.isInfoEnabled()) {
                    log.info((Object)("size = " + size));
                }
                InputStream is = url.openStream();
                if (!this.ontologyDirectory.exists() && !this.ontologyDirectory.mkdirs()) {
                    throw new IOException("Cannot create temp directory: " + this.ontologyDirectory.getAbsolutePath());
                }
                String name = null;
                String filename = url.getFile();
                int idx = filename.lastIndexOf(47);
                name = idx != -1 ? filename.substring(idx, filename.length()) : "unknown";
                ontologyFile = new File(this.ontologyDirectory + File.separator + name + System.currentTimeMillis() + ".obo");
                if (!this.isKeepDownloadedOntologiesOnDisk()) {
                    log.info((Object)"Request file to be deleted on exit.");
                    ontologyFile.deleteOnExit();
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("The OBO file will be temporary stored as: " + ontologyFile.getAbsolutePath()));
                }
                FileOutputStream out = new FileOutputStream(ontologyFile);
                int length = 0;
                int current = 0;
                byte[] buf = new byte[0x100000];
                while ((length = is.read(buf)) != -1) {
                    current += length;
                    out.write(buf, 0, length);
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("length = " + length));
                    log.info((Object)("Percent: " + (float)current / (float)size * 100.0f + "%"));
                }
                is.close();
                out.flush();
                out.close();
                if (this.isKeepDownloadedOntologiesOnDisk()) {
                    if (registryMap == null) {
                        registryMap = new HashMap<URL, String>();
                    }
                    registryMap.put(url, ontologyFile.getAbsolutePath());
                    log.info((Object)"Serializing Map");
                    File f = this.getRegistryFile();
                    ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
                    oos.writeObject(registryMap);
                    oos.flush();
                    oos.close();
                }
            }
            if (ontologyFile == null) {
                log.error((Object)"The ontology file is still null...");
            }
            return this.parseOboFile(ontologyFile);
        }
        catch (IOException e) {
            throw new OntologyLoaderException("Error while loading URL (" + url + ")", e);
        }
    }
}

