/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.dw.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.genemania.dw.entity.ExtResource;
import org.genemania.dw.util.GenUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBOTerm
extends ExtResource {
    public static final String RELATION_ISA = "is-a";
    public static final String RELATION_PARTOF = "part_of";
    public static final String RELATION_REGULATES_NEG = "negatively_regulates";
    public static final String RELATION_REGULATES_POS = "positively_regulates";
    public static final String RELATION_REGULATES = "regulates";
    public static final String SOURCE_PSI_MI = "PSIMI";
    public static final String SUBSET_PSI_MI_DRUGGABLE = "Drugable";
    public static final String SUBSET_PSI_MI_SLIM = "PSI-MI slim";
    public static final String XREF_PSI_MI_REGEX = "id-validation-regexp";
    public static final String XREF_PSI_MI_URL = "search-url";
    public static final String SYN_PSI_MI_ALT = "PSI-MI-alternate";
    public static final String SYN_PSI_MI_SHORT = "PSI-MI-short";
    private static ArrayList<String> relationList = new ArrayList();
    private TreeMap<String, ArrayList<String>> expandedPSISynMap = new TreeMap();
    private String comment;
    private boolean obsoleteFlag;
    private String defNS;
    private ArrayList<String> subsetList = new ArrayList();
    private ArrayList<String> namespaceList = new ArrayList();
    private ArrayList<String> xrefList = new ArrayList();
    private TreeMap<String, ArrayList<String>> relationMap = new TreeMap();

    public void setComment(String comment) {
        GenUtil.validateString(comment);
        this.comment = comment;
    }

    public void setDefNS(String defNS) {
        GenUtil.validateString(defNS);
        this.defNS = defNS;
    }

    public void setIsObsolete(boolean obsoleteFlag) {
        this.obsoleteFlag = obsoleteFlag;
    }

    public void addSubset(String subset) {
        if (!OBOTerm.isValidSubset(this.source, subset)) {
            throw new IllegalArgumentException("Unsupported subset: " + this.source + " " + subset);
        }
        if (!this.subsetList.contains(subset)) {
            this.subsetList.add(subset);
        }
    }

    public void addXref(String xref) {
        GenUtil.validateString(xref);
        if (!this.xrefList.contains(xref)) {
            this.xrefList.add(xref);
        }
    }

    public void addNamespace(String namespace) {
        GenUtil.validateString(namespace);
        if (!this.namespaceList.contains(namespace)) {
            this.namespaceList.add(namespace);
        }
    }

    public void addRelationship(String type, String ID) {
        ArrayList<String> tempList;
        GenUtil.validateString(type);
        GenUtil.validateString(ID);
        if (!relationList.contains(type)) {
            System.err.println("Warning: Undocumented relationship type: " + type);
        }
        if ((tempList = this.relationMap.get(type)) == null) {
            tempList = new ArrayList();
        }
        if (!tempList.contains(ID)) {
            tempList.add(ID);
        }
        this.relationMap.put(type, tempList);
    }

    public void addPSIMISyn(String synType, String syn) {
        if (!this.source.equals(SOURCE_PSI_MI)) {
            throw new UnsupportedOperationException("Operation only allowed for  terms from PSIMI");
        }
        GenUtil.validateString(synType);
        if (!SYN_PSI_MI_ALT.equals(synType) && !SYN_PSI_MI_SHORT.equals(synType)) {
            throw new IllegalArgumentException("Unrecognized syn type: " + synType);
        }
        ArrayList<String> tempList = this.expandedPSISynMap.get(synType);
        if (tempList == null) {
            tempList = new ArrayList();
        }
        if (!tempList.contains(syn)) {
            tempList.add(syn);
        }
        this.expandedPSISynMap.put(synType, tempList);
    }

    public String getComment() {
        return this.comment;
    }

    public String getDefNS() {
        return this.defNS;
    }

    public boolean isObsolte() {
        return this.obsoleteFlag;
    }

    public ArrayList<String> getSubsetList() {
        return this.subsetList;
    }

    public ArrayList<String> getXrefList() {
        return this.xrefList;
    }

    public ArrayList<String> getNamespaceList() {
        return this.namespaceList;
    }

    public ArrayList<String> getPSIMISynList(String synType) {
        if (!this.source.equals(SOURCE_PSI_MI)) {
            throw new UnsupportedOperationException("Operation only allowed for  terms from PSIMI");
        }
        return this.expandedPSISynMap.get(synType);
    }

    public ArrayList<String> getRelationshipList(String type) {
        return this.relationMap.get(type);
    }

    public static final boolean isValidSubset(String source, String subset) {
        GenUtil.validateString(source);
        GenUtil.validateString(subset);
        if (!SOURCE_PSI_MI.equals(source)) {
            return true;
        }
        return SOURCE_PSI_MI.equals(source) && (SUBSET_PSI_MI_DRUGGABLE.equals(subset) || SUBSET_PSI_MI_SLIM.equals(subset));
    }

    public boolean isValidXRefFormat(String assocID) {
        if (!SOURCE_PSI_MI.equals(this.source)) {
            throw new UnsupportedOperationException("Operation only allowed for  terms from PSIMI");
        }
        boolean found = false;
        for (int i = 0; i < this.xrefList.size(); ++i) {
            if (!this.xrefList.get(0).contains(XREF_PSI_MI_REGEX)) continue;
            found = true;
            String regex = this.xrefList.get(0).substring(XREF_PSI_MI_REGEX.length() + 1);
            return assocID.matches(regex);
        }
        if (!found) {
            System.err.println("No xref format found in term: " + this.name);
        }
        return false;
    }

    public String getPSIMIShortLabel() {
        if (!SOURCE_PSI_MI.equals(this.source)) {
            throw new UnsupportedOperationException("Operation only allowed for  terms from PSIMI");
        }
        return this.expandedPSISynMap.get(SYN_PSI_MI_SHORT) != null ? this.expandedPSISynMap.get(SYN_PSI_MI_SHORT).get(0) : this.getName();
    }

    @Override
    public String toString() {
        int i;
        ArrayList<String> tempList;
        String str = this.source;
        str = str + "\t";
        str = str + this.ID;
        str = str + "\t";
        str = this.name != null ? str + this.name : str + "N/A";
        str = str + "\t";
        str = this.definition != null ? str + this.definition : str + "N/A";
        str = str + "\t";
        str = this.comment != null ? str + this.comment : str + "N/A";
        str = str + "\t";
        str = str + this.obsoleteFlag;
        str = str + "\t";
        str = this.getSubsetList().size() > 0 ? GenUtil.addList(str, this.getSubsetList()) : str + "N/A";
        str = str + "\t";
        str = this.getNamespaceList().size() > 0 ? GenUtil.addList(str, this.getNamespaceList()) : (this.getDefNS() != null ? str + this.getDefNS() : str + "N/A");
        str = str + "\t";
        str = this.getXrefList().size() > 0 ? GenUtil.addList(str, this.getXrefList()) : str + "N/A";
        str = str + "\t";
        str = this.getSynList().size() > 0 ? GenUtil.addList(str, this.getSynList()) : str + "N/A";
        str = str + "\t";
        Iterator<String> iterator = this.relationMap.keySet().iterator();
        int cnt = 0;
        while (iterator.hasNext()) {
            String type = iterator.next();
            tempList = this.relationMap.get(type);
            if (cnt++ > 0) {
                str = str + ";";
            }
            str = str + type + "(";
            for (i = 0; i < tempList.size(); ++i) {
                if (i > 0) {
                    str = str + ";";
                }
                str = str + tempList.get(i);
            }
            str = str + ")";
        }
        if (cnt == 0) {
            str = str + "N/A";
        }
        str = str + "\t";
        if (!this.getSource().equals(SOURCE_PSI_MI)) {
            return str;
        }
        System.out.println(this.getSource());
        iterator = this.expandedPSISynMap.keySet().iterator();
        cnt = 0;
        while (iterator.hasNext()) {
            String synType = iterator.next();
            tempList = this.expandedPSISynMap.get(synType);
            if (cnt++ > 0) {
                str = str + ";";
            }
            str = str + synType + "(";
            for (i = 0; i < tempList.size(); ++i) {
                if (i > 0) {
                    str = str + ";";
                }
                str = str + tempList.get(i);
            }
            str = str + ")";
        }
        if (cnt == 0) {
            str = str + "N/A";
        }
        str = str + "\t";
        return str;
    }

    static {
        relationList.add(RELATION_ISA);
        relationList.add(RELATION_PARTOF);
        relationList.add(RELATION_REGULATES_NEG);
        relationList.add(RELATION_REGULATES_POS);
        relationList.add(RELATION_REGULATES);
    }
}

