/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ProcessCommunicator
extends Thread {
    protected Process p;
    protected StringBuffer stdoutBuffer;
    protected StringBuffer stderrBuffer;
    protected String cmd;
    protected String[] args;
    protected static final String sep = System.getProperty("line.separator");
    protected boolean isRunning = false;
    protected Thread stdoutThread;
    protected ReaderRunnable stdoutRunnable;
    protected Thread stderrThread;
    protected ReaderRunnable stderrRunnable;
    protected Exception failureException;

    public String getCmd() {
        return this.cmd;
    }

    public ProcessCommunicator(String cmd) throws IOException {
        this.cmd = cmd;
        this.stdoutBuffer = new StringBuffer();
        this.stderrBuffer = new StringBuffer();
    }

    public ProcessCommunicator(String[] args) throws IOException {
        this.args = args;
        this.stdoutBuffer = new StringBuffer();
        this.stderrBuffer = new StringBuffer();
    }

    public void run() {
        try {
            this.p.waitFor();
            this.isRunning = false;
        }
        catch (Exception ex) {
            this.isRunning = false;
            this.failureException = ex;
        }
    }

    protected void setupThread() throws Exception {
        this.p = this.args == null ? Runtime.getRuntime().exec(this.cmd) : Runtime.getRuntime().exec(this.args);
        this.stdoutRunnable = new ReaderRunnable(this.p.getInputStream(), this.stdoutBuffer);
        this.stderrRunnable = new ReaderRunnable(this.p.getErrorStream(), this.stderrBuffer);
        this.stdoutThread = new Thread(this.stdoutRunnable);
        this.stderrThread = new Thread(this.stderrRunnable);
        this.stdoutThread.start();
        this.stderrThread.start();
        this.isRunning = true;
    }

    public void start() {
        try {
            this.setupThread();
            super.start();
        }
        catch (Exception ex) {
            this.isRunning = false;
            this.failureException = ex;
        }
    }

    public Exception getFailureException() {
        return this.failureException;
    }

    public int exitValue() {
        if (this.isRunning()) {
            throw new IllegalArgumentException("Can't call exitValue() while process is running");
        }
        return this.p.exitValue();
    }

    public ProcessCommunicator getCleanCopy() throws IOException {
        if (this.cmd != null) {
            return new ProcessCommunicator(this.cmd);
        }
        return new ProcessCommunicator(this.args);
    }

    public void shutdown() {
        this.isRunning = false;
        this.stderrRunnable.halt();
        this.stdoutRunnable.halt();
        this.p.destroy();
    }

    public boolean isRunning() {
        return this.isRunning || this.stdoutThread != null && this.stdoutThread.isAlive() || this.stderrThread != null && this.stderrThread.isAlive();
    }

    public boolean isReadable() {
        return this.isRunning() || this.stdoutBuffer.length() > 0 || this.stderrBuffer.length() > 0;
    }

    public String readStdoutLine() {
        return this.readStdoutLine(true);
    }

    public String readStderrLine() {
        return this.readStderrLine(true);
    }

    public String readStdoutLine(boolean block) {
        return this.readLine(this.stdoutBuffer, block);
    }

    public String readStderrLine(boolean block) {
        return this.readLine(this.stderrBuffer, block);
    }

    public String readStdoutBuffer() {
        return this.readBuffer(this.stdoutBuffer);
    }

    public String readStderrBuffer() {
        return this.readBuffer(this.stderrBuffer);
    }

    /*
     * Unable to fully structure code
     */
    public static ProcessResult run(String cmd) throws Exception {
        err = new StringBuffer();
        out = new StringBuffer();
        pc = new ProcessCommunicator(cmd);
        pc.start();
        ** GOTO lbl19
        {
            err.append(line);
            err.append(ProcessCommunicator.sep);
            do {
                if ((line = pc.readStderrLine(false)) != null) continue block0;
                while ((line = pc.readStdoutLine(false)) != null) {
                    out.append(line);
                    out.append(ProcessCommunicator.sep);
                }
                Thread.yield();
lbl19:
                // 2 sources

            } while (pc.isReadable());
        }
        if (pc.getFailureException() != null) {
            throw pc.getFailureException();
        }
        return new ProcessResult(pc.exitValue(), out.toString(), err.toString());
    }

    protected String readBuffer(StringBuffer buffer) {
        if (buffer.length() == 0) {
            return null;
        }
        int length = buffer.length();
        String out = buffer.substring(0, length);
        buffer.delete(0, length);
        return out;
    }

    protected String readLine(StringBuffer buffer, boolean block) {
        if (block) {
            String line;
            while ((line = this.readLine(buffer)) == null) {
                if (!this.isRunning()) {
                    return null;
                }
                Thread.yield();
            }
            return line;
        }
        return this.readLine(buffer);
    }

    protected String readLine(StringBuffer buffer) {
        if (buffer.length() == 0) {
            return null;
        }
        int i = buffer.indexOf(sep);
        if (i == -1) {
            if (!this.isRunning()) {
                return this.readBuffer(buffer);
            }
            return null;
        }
        String out = buffer.substring(0, i);
        buffer.delete(0, i + sep.length());
        return out;
    }

    public void finalize() {
        this.p.destroy();
    }

    public void println(String s) throws IOException {
        OutputStream stream = this.p.getOutputStream();
        int i = 0;
        while (i < s.length()) {
            stream.write(s.charAt(i));
            ++i;
        }
        stream.flush();
    }

    protected static class ReaderRunnable
    implements Runnable {
        protected InputStream stream;
        protected StringBuffer buffer;
        protected boolean halt;
        protected Exception failedException;

        public ReaderRunnable(InputStream stream, StringBuffer buffer) {
            this.stream = stream;
            this.buffer = buffer;
        }

        public Exception getFailedException() {
            return this.failedException;
        }

        public void run() {
            try {
                int read;
                while ((read = this.stream.read()) != -1) {
                    if (this.halt) {
                        return;
                    }
                    this.buffer.append((char)read);
                }
            }
            catch (Exception ex) {
                if (this.halt) {
                    return;
                }
                this.failedException = ex;
            }
        }

        public void halt() {
            this.halt = true;
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class ProcessResult {
        protected int exitCode;
        protected String stdout;
        protected String stderr;

        protected ProcessResult(int exitCode, String stdout, String stderr) {
            this.exitCode = exitCode;
            this.stdout = stdout;
            this.stderr = stderr;
        }

        public String getStdout() {
            return this.stdout;
        }

        public String getStderr() {
            return this.stderr;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

