/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.swing;

import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.geneontology.swing.MenuNameResolver;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 8345061479714901147L;
    protected Vector items = new Vector();
    protected MenubarElement root;
    protected MenuListener showListener = new MenuListener(){

        public void menuSelected(MenuEvent e) {
            XMLMenuBar.this.resolver.showNotify();
        }

        public void menuCanceled(MenuEvent e) {
        }

        public void menuDeselected(MenuEvent e) {
        }
    };
    protected MenuNameResolver resolver;

    public XMLMenuBar(MenuNameResolver resolver) {
        this.resolver = resolver;
    }

    protected void reload(MenubarElement root) {
        this.removeAll();
        this.items.removeAllElements();
        int i = 0;
        while (i < root.getItems().size()) {
            Component component = this.getComponent(root.getItems().get(i));
            this.add(component);
            ++i;
        }
        this.validate();
        this.repaint();
    }

    protected Component getComponent(Object o) {
        if (o instanceof MenuElement) {
            JMenu menu = this.getMenu((MenuElement)o);
            return menu;
        }
        if (o instanceof UserItem) {
            UserItem item = (UserItem)o;
            Component comp = this.resolver.resolveName(item.getID(), item.getProperties(), null);
            return comp;
        }
        return null;
    }

    protected JMenu getMenu(MenuElement element) {
        JMenu menu = new JMenu(element.getLabel());
        menu.setFont(this.getFont());
        menu.addMenuListener(this.showListener);
        int i = 0;
        while (i < element.getItems().size()) {
            Object o = element.getItems().get(i);
            if (o instanceof SeparatorElement) {
                menu.addSeparator();
            } else {
                menu.add(this.getComponent(o));
            }
            ++i;
        }
        return menu;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.root != null) {
            this.reload(this.root);
        }
    }

    public void setLayout(String layout) throws SAXException, IOException {
        this.setLayout(new InputSource(new StringReader(layout)));
    }

    public void setLayout(URL url) throws SAXException, IOException {
        this.setLayout(url.openStream());
    }

    public void setLayout(File file) throws SAXException, IOException {
        this.setLayout(file.toURL());
    }

    public void setLayout(InputStream stream) throws SAXException, IOException {
        this.setLayout(new InputSource(stream));
    }

    public void setLayout(InputSource document) throws SAXException, IOException {
        SAXParser saxParser;
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setValidating(false);
        XMLReader xmlReader = null;
        try {
            saxParser = spf.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Couldn't load parser");
        }
        xmlReader = saxParser.getXMLReader();
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        xmlReader.setContentHandler(layoutBuilder);
        this.resolver.startParseNotify();
        xmlReader.parse(document);
        this.resolver.endParseNotify();
        this.root = layoutBuilder.getRoot();
        this.reload(this.root);
    }

    protected static interface Holder {
        public void addItem(Object var1);

        public Vector getItems();
    }

    protected static class MenubarElement
    implements Holder {
        Vector items = new Vector();

        public void addItem(Object item) {
            this.items.add(item);
        }

        public Vector getItems() {
            return this.items;
        }
    }

    protected static class MenuElement
    implements Holder {
        Vector items = new Vector();
        String label;

        public MenuElement(String label) {
            this.label = label;
        }

        public void addItem(Object item) {
            this.items.add(item);
        }

        public Vector getItems() {
            return this.items;
        }

        public String getLabel() {
            return this.label;
        }
    }

    protected static class SeparatorElement {
        protected SeparatorElement() {
        }
    }

    protected static class UserItem {
        protected String id;
        protected Properties props;

        public UserItem(String id, Properties props) {
            this.id = id;
            this.props = props;
        }

        public String getID() {
            return this.id;
        }

        public Properties getProperties() {
            return this.props;
        }
    }

    protected static class LayoutBuilder
    extends DefaultHandler {
        private Vector stack;
        private MenubarElement root;

        protected LayoutBuilder() {
        }

        public MenubarElement getRoot() {
            return this.root;
        }

        public void startDocument() throws SAXException {
            this.stack = new Vector();
        }

        public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
            Object item = null;
            localName = rawName;
            if (localName.equalsIgnoreCase("component")) {
                Properties props = new Properties();
                int i = 0;
                while (i < atts.getLength()) {
                    String name = atts.getQName(i);
                    String value = atts.getValue(i);
                    if (!name.equals("id")) {
                        props.put(name, value);
                    }
                    ++i;
                }
                item = new UserItem(atts.getValue("id"), props);
                this.stack.insertElementAt(item, 0);
            } else if (localName.equalsIgnoreCase("menubar")) {
                item = new MenubarElement();
                this.stack.insertElementAt(item, 0);
            } else if (localName.equalsIgnoreCase("separator")) {
                item = new SeparatorElement();
                this.stack.insertElementAt(item, 0);
            } else if (localName.equalsIgnoreCase("menu")) {
                item = new MenuElement(atts.getValue("label"));
                this.stack.insertElementAt(item, 0);
            }
            if (this.root == null && item != null && item instanceof MenubarElement) {
                this.root = (MenubarElement)item;
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (this.stack.size() >= 2) {
                Object item = this.stack.elementAt(0);
                Holder parent = (Holder)this.stack.elementAt(1);
                parent.addItem(item);
                this.stack.removeElementAt(0);
            }
        }

        public void endDocument() throws SAXException {
        }
    }
}

