/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.expression;

import org.geneontology.expression.ExpressionException;
import org.geneontology.expression.JexlContext;
import org.geneontology.expression.Script;
import org.geneontology.expression.ScriptFactory;

public class ExpressionUtil {
    private ExpressionUtil() {
    }

    public static String resolveBacktickExpression(String str, JexlContext context) throws ExpressionException {
        if (str == null) {
            return null;
        }
        if (context == null) {
            return str;
        }
        StringBuffer out = new StringBuffer();
        StringBuffer expression = new StringBuffer();
        StringBuffer writeToMe = out;
        boolean inBackticks = false;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '\\') {
                if (i < str.length() - 1) {
                    c = str.charAt(++i);
                }
                writeToMe.append(c);
            } else if (c == '`') {
                if (inBackticks) {
                    String val = "`" + expression.toString() + "`";
                    val = ExpressionUtil.exec(expression.toString(), context).toString();
                    expression = new StringBuffer();
                    writeToMe = out;
                    writeToMe.append(val);
                    inBackticks = false;
                } else {
                    inBackticks = true;
                    writeToMe = expression;
                }
            } else {
                writeToMe.append(c);
            }
            ++i;
        }
        return out.toString();
    }

    public static Object exec(String code, JexlContext context) throws ExpressionException {
        Script s = ScriptFactory.createScript(code);
        return s.execute(context);
    }

    public static int execInt(String code, JexlContext context) throws ExpressionException {
        Object o = ExpressionUtil.exec(code, context);
        try {
            if (o instanceof Number) {
                return ((Number)o).intValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new ExpressionException("Could not convert " + o + " to int");
    }

    public static boolean execBoolean(String code, JexlContext context) throws ExpressionException {
        Object o = ExpressionUtil.exec(code, context);
        try {
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new ExpressionException("Could not convert " + o + " to boolean");
    }

    public static double execDouble(String code, JexlContext context) throws ExpressionException {
        Object o = ExpressionUtil.exec(code, context);
        try {
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new ExpressionException("Could not convert " + o + " to double");
    }

    public static String execString(String code, JexlContext context) throws ExpressionException {
        Object o = ExpressionUtil.exec(code, context);
        if (o == null) {
            return null;
        }
        return o.toString();
    }
}

