/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.commandline;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geneontology.commandline.ArgumentSignature;
import org.geneontology.commandline.CommandLineParser;
import org.geneontology.commandline.FailException;
import org.geneontology.commandline.UnfullfilledException;

public class OrderedArgumentSignature
implements ArgumentSignature {
    protected List signatures = new ArrayList();
    int index = 0;
    protected int id = CommandLineParser.getID();
    protected String shortDocumentation;

    public int getID() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o instanceof ArgumentSignature) {
            return ((ArgumentSignature)o).getID() == this.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public OrderedArgumentSignature() {
        this(null);
    }

    public OrderedArgumentSignature(String shortDocumentation) {
        this.shortDocumentation = shortDocumentation;
    }

    public String getShortDocumentation() {
        if (this.shortDocumentation == null) {
            StringBuffer out = new StringBuffer();
            Iterator it = this.signatures.iterator();
            boolean first = true;
            while (it.hasNext()) {
                ArgumentSignature sig = (ArgumentSignature)it.next();
                if (!first) {
                    out.append(" ");
                }
                out.append(sig.getShortDocumentation());
                first = false;
            }
            return out.toString();
        }
        return "<" + this.shortDocumentation + ">";
    }

    protected OrderedArgumentSignature createCopyObject() {
        return new OrderedArgumentSignature();
    }

    public ArgumentSignature copy() {
        OrderedArgumentSignature out = this.createCopyObject();
        Iterator it = this.signatures.iterator();
        while (it.hasNext()) {
            ArgumentSignature sig = (ArgumentSignature)it.next();
            out.signatures.add(sig.copy());
        }
        out.id = this.id;
        out.index = this.index;
        return out;
    }

    public void init(CommandLineParser p, boolean defaultMode) {
        this.index = defaultMode ? 1 : 0;
        Iterator it = this.signatures.iterator();
        while (it.hasNext()) {
            ArgumentSignature sig = (ArgumentSignature)it.next();
            sig.init(p, false);
        }
    }

    public String toString() {
        return super.toString();
    }

    public boolean onlyAcceptAsLastResort() {
        return false;
    }

    public void addSignature(ArgumentSignature as) {
        as.setOnlyAcceptAsLastResort(false);
        this.signatures.add(as);
    }

    public void setOnlyAcceptAsLastResort(boolean lastResort) {
    }

    public void accept(CommandLineParser p) throws FailException {
        while (this.index < this.signatures.size()) {
            ArgumentSignature sig = (ArgumentSignature)this.signatures.get(this.index);
            p.doAccept(sig);
            ++this.index;
        }
    }

    public List getValues() throws UnfullfilledException {
        if (this.index < this.signatures.size()) {
            throw new UnfullfilledException();
        }
        ArrayList out = new ArrayList();
        Iterator it = this.signatures.iterator();
        while (it.hasNext()) {
            ArgumentSignature as = (ArgumentSignature)it.next();
            out.addAll(as.getValues());
        }
        return out;
    }
}

