/*
 * Decompiled with CFR 0.152.
 */
package org.pathwaycommons.trans.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import org.genemania.dw.util.DefParams;
import org.genemania.dw.util.GenUtil;
import org.jdom.Element;
import org.pathwaycommons.trans.util.XMLElementInfo;
import org.pathwaycommons.trans.util.XMLUtil;

public class XMLStats {
    private static final String DEF_STATS_FILE_NAME = "XMLStats.txt";
    private static PrintWriter log = GenUtil.getDefaultLog();
    private String inputPathName;

    public void setInputPathName(String inputPathName) {
        GenUtil.validateString((String)inputPathName);
        this.inputPathName = inputPathName;
    }

    public String getInputPathName() {
        return this.inputPathName;
    }

    public void generateStats() throws Exception {
        File sourceFileOrDir = new File(this.getInputPathName());
        if (sourceFileOrDir.isFile()) {
            String fileName = sourceFileOrDir.getAbsolutePath();
            System.out.print("Stats for: " + fileName);
            Element rootElement = XMLUtil.readSchemaBasedXML(fileName);
            this.generateStats(rootElement, fileName);
            rootElement = null;
            System.gc();
        } else {
            File[] filesArr = sourceFileOrDir.listFiles();
            int cnt = 1;
            for (int i = 0; i < filesArr.length; ++i) {
                if (!filesArr[i].getAbsolutePath().contains(".xml")) continue;
                System.out.println("Stats for: " + cnt++ + " " + filesArr[i]);
                Element rootElement = XMLUtil.readSchemaBasedXML(filesArr[i].getAbsolutePath());
                this.generateStats(rootElement, filesArr[i].getAbsolutePath());
                rootElement = null;
                System.gc();
            }
        }
    }

    public void generateStats(Element rootElement, String fileName) {
        new XMLElementInfo(rootElement, fileName);
        ArrayList childrenList = new ArrayList(rootElement.getChildren());
        for (int i = 0; i < childrenList.size(); ++i) {
            this.generateStats((Element)childrenList.get(i), fileName);
        }
    }

    public void dumpStats() throws IOException {
        File outputFile = new File(DefParams.getDefaultProp((String)"DefToolsPath"), DEF_STATS_FILE_NAME);
        BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));
        Iterator<String> iterator = XMLElementInfo.getAll().keySet().iterator();
        System.out.println("Total num of unique elements: " + XMLElementInfo.getAll().size());
        System.out.println("Dumping all unique elements...");
        bw.write(XMLElementInfo.getHeaders());
        bw.newLine();
        while (iterator.hasNext()) {
            XMLElementInfo xei = XMLElementInfo.getAll().get(iterator.next());
            bw.write(xei.toString());
            bw.newLine();
        }
        bw.flush();
        bw.close();
        System.out.println("Done...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        log = GenUtil.getDefaultLog();
        log.println(GenUtil.getTimeStamp());
        GenUtil.registerStart();
        String usageMsg = "Usage: XMLStats inputpath";
        String warnMsg = "WARNING: Missing command line args, using defaults";
        if (args == null || args.length < 1) {
            log.println(warnMsg);
            log.println(usageMsg);
            System.out.println(warnMsg);
            System.out.println(usageMsg);
            args = DefParams.getCommandLineArgs((String)XMLStats.class.getName());
        }
        try {
            XMLStats xmlStats = new XMLStats();
            xmlStats.setInputPathName(args[0]);
            xmlStats.generateStats();
            xmlStats.dumpStats();
        }
        catch (Throwable e) {
            e.printStackTrace();
            e.printStackTrace(log);
        }
        finally {
            log.println(GenUtil.getExecTimeStr());
            log.flush();
            log.close();
        }
    }
}

