/*
 * Decompiled with CFR 0.152.
 */
package org.pathwaycommons.trans.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.xml.bind.JAXBException;
import org.pathwaycommons.trans.util.PSIMIMiner;
import psidev.psi.mi.xml.PsimiXmlPullReader;
import psidev.psi.mi.xml.PsimiXmlReader;
import psidev.psi.mi.xml.PsimiXmlReaderException;
import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.DbReference;
import psidev.psi.mi.xml.model.Entry;
import psidev.psi.mi.xml.model.EntrySet;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Interactor;
import psidev.psi.mi.xml.model.Participant;

public class PSIMIMinerModel
extends PSIMIMiner {
    private PsimiXmlPullReader pullReader;
    private Interaction interaction;

    protected PSIMIMinerModel(String inputFileName, String reportFileName, String miningType) throws Exception {
        super(inputFileName, reportFileName, miningType);
    }

    protected void minePSIMI(String inputFileName) throws PsimiXmlReaderException, IOException, JAXBException, ConverterException {
        this.termMap = new TreeMap();
        this.interactionCnt = 0;
        File inputFile = new File(inputFileName);
        PsimiXmlReader pr = new PsimiXmlReader();
        this.pullReader = new PsimiXmlPullReader(inputFile);
        EntrySet entrySet = pr.read(inputFile);
        for (Entry entry : entrySet.getEntries()) {
            ArrayList interactionsList = (ArrayList)entry.getInteractions();
            for (int i = 0; i < interactionsList.size(); ++i) {
                this.interaction = (Interaction)interactionsList.get(i);
                try {
                    if (this.getAtt("Complex Number of Subunits") != null) {
                        if (!"Complex Number of Subunits".equals(this.miningType)) {
                            ++this.skipCnt;
                            continue;
                        }
                        ++this.interactionCnt;
                    }
                    if (!"Complex Number of Subunits".equals(this.miningType)) {
                        ++this.interactionCnt;
                    }
                    if ("interactionDetectionMethod".equals(this.miningType)) {
                        this.mineDetMethod();
                        continue;
                    }
                    if ("interactorType".equals(this.miningType)) {
                        this.mineInteractorType();
                        continue;
                    }
                    if ("Complex Number of Subunits".equals(this.miningType)) {
                        this.mineComplexSubunits();
                        continue;
                    }
                    if ("BIND Interaction Division".equals(this.miningType)) {
                        this.mineBINDDivCategory();
                        continue;
                    }
                    if ("xref".equals(this.miningType)) {
                        this.mineInteractorXRef();
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported mining request: " + this.miningType);
                }
                catch (Exception e) {
                    e.printStackTrace(log);
                    System.err.println("ERROR: Skipping in file: " + this.interactionCnt + " " + inputFileName);
                    ++this.skipCnt;
                }
            }
            super.incrementCounts(inputFileName);
        }
    }

    protected void mineDetMethod() {
        ArrayList expDescList = (ArrayList)this.interaction.getExperiments();
        for (int i = 0; i < expDescList.size(); ++i) {
            String shortLabel = ((ExperimentDescription)expDescList.get(i)).getInteractionDetectionMethod().getNames().getShortLabel();
            this.trackTermCnt(shortLabel);
        }
    }

    protected void mineInteractorType() throws PsimiXmlReaderException {
        ArrayList partList = (ArrayList)this.interaction.getParticipants();
        for (int j = 0; j < partList.size(); ++j) {
            Interactor interactor = this.pullReader.getInteractorById(((Participant)partList.get(j)).getId());
            String type = interactor.getInteractorType().getNames().getShortLabel();
            this.trackTermCnt(type);
        }
    }

    protected void mineInteractorXRef() throws Exception {
        ArrayList partList = (ArrayList)this.interaction.getParticipants();
        for (int j = 0; j < partList.size(); ++j) {
            Interactor interactor = this.pullReader.getInteractorById(((Participant)partList.get(j)).getId());
            ArrayList<DbReference> refList = new ArrayList<DbReference>();
            refList.add(interactor.getXref().getPrimaryRef());
            refList.addAll(interactor.getXref().getSecondaryRef());
            for (int i = 0; i < refList.size(); ++i) {
                this.trackTermCnt(((DbReference)refList.get(i)).getDb());
            }
        }
    }

    protected void trackAtt(String attName) {
        String attVal = this.getAtt(attName);
        if (attVal != null) {
            this.trackTermCnt(attVal);
        }
    }

    protected String getAtt(String attName) {
        ArrayList attList = (ArrayList)this.interaction.getAttributeList();
        String attVal = null;
        for (int i = 0; i < attList.size(); ++i) {
            Attribute att = (Attribute)attList.get(i);
            if (!att.getName().equals(attName)) continue;
            attVal = att.getValue();
            break;
        }
        return attVal;
    }
}

