/*
 * Decompiled with CFR 0.152.
 */
package org.pathwaycommons.trans.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import org.genemania.dw.util.DefParams;
import org.genemania.dw.util.GenUtil;
import org.pathwaycommons.trans.util.PSIMIMinerModel;
import org.pathwaycommons.trans.util.PSIMIMinerXML;

public abstract class PSIMIMiner {
    public static final String MINING_INT_DET_METHOD = "interactionDetectionMethod";
    public static final String MINING_INTERACTOR_TYPE = "interactorType";
    public static final String MINING_COMPLEX_SUBUNIT_NUM = "Complex Number of Subunits";
    public static final String MINING_INT_XREF = "xref";
    public static final String MINING_BIND_DIV = "BIND Interaction Division";
    public static final String MINING_METHOD_XML = "MINING_XML";
    public static final String MINING_METHOD_MODEL = "MINING_MODEL";
    protected static final String DEF_REPORT_NAME_PREFIX = "PSIMIMiner";
    protected static final String DEF_REPORT_NAME_SUFFIX = ".txt";
    protected static final String FILE_NAME_HEADER = "File Name";
    protected static final String INT_PROCESSED_HEADER = "Interactions Processed";
    protected static PrintWriter log;
    protected int interactionCnt;
    protected int skipCnt;
    protected String reportFileName;
    protected String miningType;
    protected TreeMap<String, TreeMap<String, Integer>> resultMap = new TreeMap();
    protected TreeMap<String, Integer> termMap;
    protected TreeMap<String, Integer> intCntMap = new TreeMap();
    private TreeMap<String, Integer> globalTermMap = new TreeMap();

    public static PSIMIMiner getMiner(String inputFileName, String reportFileName, String miningType, String miningMethod) throws Exception {
        if (MINING_METHOD_XML.equals(miningMethod)) {
            return new PSIMIMinerXML(inputFileName, reportFileName, miningType);
        }
        if (MINING_METHOD_MODEL.equals(miningMethod)) {
            return new PSIMIMinerModel(inputFileName, reportFileName, miningType);
        }
        throw new IllegalArgumentException("Invalid mining method: " + miningMethod);
    }

    protected PSIMIMiner(String inputFileName, String reportFileName, String miningType) throws Exception {
        GenUtil.validateString((String)inputFileName);
        this.setReportFileName(reportFileName);
        this.setMiningType(miningType);
        if (new File(inputFileName).isDirectory()) {
            Object[] filesArr = new File(inputFileName).listFiles();
            Arrays.sort(filesArr);
            int cnt = 1;
            for (int i = 0; i < filesArr.length; ++i) {
                if (!((File)filesArr[i]).getAbsolutePath().endsWith(".xml")) continue;
                String currentFileName = ((File)filesArr[i]).getAbsolutePath();
                System.out.println("Mining file: " + cnt++ + " " + currentFileName);
                this.minePSIMI(currentFileName);
            }
        } else {
            this.minePSIMI(inputFileName);
        }
    }

    private void setReportFileName(String reportFileName) {
        GenUtil.validateString((String)reportFileName);
        this.reportFileName = reportFileName;
    }

    private void setMiningType(String miningType) {
        GenUtil.validateString((String)miningType);
        this.miningType = miningType;
    }

    protected void trackTermCnt(String term) {
        if (this.termMap.containsKey(term)) {
            this.termMap.put(term, new Integer(this.termMap.get(term) + 1));
        } else {
            this.termMap.put(term, new Integer(1));
        }
        if (this.globalTermMap.containsKey(term)) {
            this.globalTermMap.put(term, new Integer(this.globalTermMap.get(term) + 1));
        } else {
            this.globalTermMap.put(term, new Integer(1));
        }
    }

    protected void incrementCounts(String inputFileName) {
        if (this.termMap.size() > 0) {
            this.resultMap.put(inputFileName, this.termMap);
        }
        this.intCntMap.put(inputFileName, new Integer(this.interactionCnt));
        System.gc();
        System.out.println("Total interactions in: " + inputFileName + ": " + this.interactionCnt);
    }

    protected void dump() throws IOException {
        File reportFile = new File(this.reportFileName, "PSIMIMiner_" + this.miningType + DEF_REPORT_NAME_SUFFIX);
        BufferedWriter bw = new BufferedWriter(new FileWriter(reportFile.getAbsolutePath()));
        for (String term : this.globalTermMap.keySet()) {
            log.println(term + "\t" + this.globalTermMap.get(term));
            System.out.println(term + "\t" + this.globalTermMap.get(term));
        }
        log.println();
        ArrayList<String> tempList = new ArrayList<String>();
        tempList.addAll(this.globalTermMap.keySet());
        bw.write("File Name\tInteractions Processed\t");
        for (int i = 0; i < tempList.size(); ++i) {
            bw.write((String)tempList.get(i) + "\t");
        }
        bw.newLine();
        int totalIntCnt = 0;
        for (String currentFileName : this.resultMap.keySet()) {
            String reportStr = currentFileName + "\t" + this.intCntMap.get(currentFileName).toString() + "\t";
            totalIntCnt += this.intCntMap.get(currentFileName).intValue();
            for (int i = 0; i < tempList.size(); ++i) {
                String cntStr = "N/A";
                TreeMap<String, Integer> currentTermsMap = this.resultMap.get(currentFileName);
                Integer cntInt = currentTermsMap.get(tempList.get(i));
                if (cntInt != null) {
                    cntStr = cntInt.toString();
                }
                reportStr = reportStr + cntStr + "\t";
            }
            bw.write(reportStr);
            bw.newLine();
        }
        bw.flush();
        bw.close();
        System.out.println("Report generated: " + reportFile.getCanonicalPath());
        System.out.println("Total files processed: " + this.resultMap.size() + ". Total terms found/processed: " + this.globalTermMap.size() + ".\nTotal interactions: " + totalIntCnt + ". Total skipped: " + this.skipCnt);
        this.resultMap.clear();
        this.globalTermMap.clear();
        this.interactionCnt = 0;
        this.skipCnt = 0;
        System.gc();
    }

    protected void mineComplexSubunits() {
        this.trackAtt(MINING_COMPLEX_SUBUNIT_NUM);
    }

    protected void mineBINDDivCategory() {
        this.trackAtt(MINING_BIND_DIV);
    }

    protected abstract void minePSIMI(String var1) throws Exception;

    protected abstract void mineDetMethod();

    protected abstract void mineInteractorType() throws Exception;

    protected abstract void mineInteractorXRef() throws Exception;

    protected abstract void trackAtt(String var1);

    protected abstract String getAtt(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        log = GenUtil.getDefaultLog();
        log.println(GenUtil.getTimeStamp());
        GenUtil.registerStart();
        String usageMsg = "Usage: PSIMIMiner MiningType [interactionDetectionMethod|interactorType|Complex Number of Subunits|xref|BIND Interaction Division] inputpath miningMethod [MINING_XML|MINING_MODEL]";
        String warnMsg = "WARNING: Missing command line args, using defaults";
        if (args == null || args.length < 3) {
            log.println(warnMsg);
            log.println(usageMsg);
            System.out.println(warnMsg);
            System.out.println(usageMsg);
            args = DefParams.getCommandLineArgs((String)PSIMIMiner.class.getName());
        }
        try {
            String reportFileName = DefParams.getDefaultProp((String)"DefToolsPath");
            PSIMIMiner miner = PSIMIMiner.getMiner(args[1], reportFileName, args[0], args[2]);
            miner.dump();
        }
        catch (Throwable e) {
            e.printStackTrace();
            e.printStackTrace(log);
        }
        finally {
            log.println(GenUtil.getExecTimeStr());
            log.flush();
            log.close();
        }
    }
}

