/*
 * Decompiled with CFR 0.152.
 */
package org.pathwaycommons.trans;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.pathwaycommons.trans.BINDToPSIMITrans;
import org.pathwaycommons.trans.CVMapEntry;
import org.pathwaycommons.trans.util.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BINDToPSIMITransComplex
extends BINDToPSIMITrans {
    private int cntTotalComplex;
    private int cntTransComplex;
    private int cntSkippedComplex;
    private int cntBadComplex;
    private String BINDComplexID;

    protected BINDToPSIMITransComplex(String inputFilesPath, String fileName, Namespace psins, int interactionID, int interactorID, int partID, int expID, BufferedWriter bw) {
        this.psins = psins;
        this.fileName = fileName;
        this.inputFilesPath = inputFilesPath;
        this.bw = bw;
        this.interactionID = interactionID;
        this.interactorID = interactorID;
        this.partID = partID;
        this.expID = expID;
    }

    protected void translateAllComplexes(Element entryE, Element BINDSubmitE) throws JDOMException, IOException {
        Element interactionListE = entryE.getChild("interactionList", this.psins);
        if (interactionListE == null) {
            interactionListE = new Element("interactionList", this.psins);
            entryE.addContent((Content)interactionListE);
        }
        ArrayList<Element> bindIntList = XMLUtil.getElement("BIND-Molecular-Complex", BINDSubmitE, 1);
        for (int i = 0; i < bindIntList.size(); ++i) {
            this.translateComplex(interactionListE, bindIntList.get(i));
        }
        System.out.println("For file: " + this.getInputFilesPath() + ": ");
        System.out.println("Total Complexes: " + this.cntTotalComplex + " Translated: " + this.cntTransComplex + " Skipped: " + this.cntSkippedComplex + " Bad: " + this.cntBadComplex);
    }

    private void translateComplex(Element interactionListE, Element BINDCompE) throws JDOMException, IOException {
        String complexDesc = "NO_VALUE";
        String complexNum = "NO_VALUE";
        String orderedFlag = "NO_VALUE";
        this.BINDComplexID = "NO_VALUE";
        ArrayList<String> interactionIDsList = new ArrayList<String>();
        ArrayList<Element> tempList = XMLUtil.getElement("Molecular-Complex-id", BINDCompE.getChild("BIND-Molecular-Complex_mcid"), XMLUtil.getDepth(BINDCompE.getChild("BIND-Molecular-Complex_mcid").getName()));
        if (XMLUtil.validateSingle("Molecular-Complex-id", tempList)) {
            this.BINDComplexID = this.getDefText(tempList.get(0), "NO_VALUE");
        }
        if (this.BINDComplexID.equals("NO_VALUE")) {
            System.err.println("Error 1: NO ID for complex.");
            this.badInteractionData = true;
        }
        if (XMLUtil.validateSingle("BIND-Molecular-Complex_descr", tempList = XMLUtil.getElement("BIND-Molecular-Complex_descr", BINDCompE, XMLUtil.getDepth(BINDCompE.getName())))) {
            complexDesc = this.getDefText(tempList.get(0), "NO_VALUE");
        }
        if (complexDesc.equals("NO_VALUE")) {
            System.err.println("Error 2: NO Desc for complex: " + this.BINDComplexID);
            this.badInteractionData = true;
        }
        if (XMLUtil.validateSingle("BIND-mol-sub-num_num", tempList = XMLUtil.getElement("BIND-mol-sub-num_num", BINDCompE, XMLUtil.getDepth(BINDCompE.getName())))) {
            complexNum = this.getDefText(tempList.get(0), "NO_VALUE");
        }
        if (complexNum.equals("NO_VALUE")) {
            System.err.println("Warning: NO count for complex: " + this.BINDComplexID);
        }
        if (!XMLUtil.validateSingle("BIND-Molecular-Complex_interaction-list", tempList = XMLUtil.getElement("BIND-Molecular-Complex_interaction-list", BINDCompE, XMLUtil.getDepth(BINDCompE.getName())))) {
            System.err.println("Warning: No interaction list found for complex: " + this.BINDComplexID);
        } else {
            ArrayList<Element> interactionIDList = XMLUtil.getElement("Interaction-id", tempList.get(0), XMLUtil.getDepth(tempList.get(0).getName()));
            if (XMLUtil.validateExists("Interaction-id", interactionIDList)) {
                for (int i = 0; i < interactionIDList.size(); ++i) {
                    if (this.getDefText(interactionIDList.get(i), "NO_VALUE").equals("NO_VALUE")) {
                        System.err.println("Error 3: Bad interaction ID for complex: " + this.BINDComplexID);
                        continue;
                    }
                    interactionIDsList.add(interactionIDList.get(i).getTextTrim());
                }
            }
        }
        tempList = XMLUtil.getElement("BIND-Molecular-Complex_ordered", BINDCompE, XMLUtil.getDepth(BINDCompE.getName()));
        if (XMLUtil.validateSingle("BIND-Molecular-Complex_ordered", tempList)) {
            orderedFlag = tempList.get(0).getAttributeValue("value");
        }
        Element interactionE = new Element("interaction", this.psins);
        this.addComplex(interactionE, BINDCompE, this.BINDComplexID, complexDesc, complexNum, orderedFlag, interactionIDsList);
        tempList = XMLUtil.getElement("BIND-Rec-coll-descr_descr", BINDCompE, XMLUtil.getDepth(BINDCompE.getName()));
        if (XMLUtil.validateSingle("BIND-Rec-coll-descr_descr", tempList)) {
            String BINDDivision = tempList.get(0).getTextTrim();
            this.addAttribute(interactionE, "BIND Interaction Division", BINDDivision);
        }
        interactionsMap.put(this.BINDComplexID, interactionE.getAttributeValue("id"));
        if (!this.badInteractionData) {
            interactionListE.addContent((Content)interactionE);
        } else {
            this.badInteractionData = false;
            this.addAttribute(interactionE, "BAD Data File", this.fileName);
            XMLUtil.dump(interactionE, this.bw);
            this.bw.newLine();
            ++this.cntBadComplex;
            badInteractionsMap.put(this.BINDComplexID, interactionE.getAttributeValue("id"));
        }
        ++this.cntTotalComplex;
        ++this.cntTransComplex;
    }

    private void addComplex(Element interactionE, Element BINDCompE, String BINDComplexID, String shortLabel, String subunitNum, String orderedFlag, ArrayList<String> interactionIDsList) throws JDOMException {
        interactionE.setAttribute("id", Integer.toString(this.interactionID++));
        if (!shortLabel.equals("NO_VALUE")) {
            this.setNames(interactionE, shortLabel, shortLabel);
        } else {
            this.setNames(interactionE, shortLabel, null);
        }
        this.setCVRef(interactionE, "bind", "identity", "primaryRef", BINDComplexID);
        Element expListE = new Element("experimentList", this.psins);
        interactionE.addContent((Content)expListE);
        this.translateExpDesc(expListE, BINDCompE, BINDComplexID);
        Element partListE = new Element("participantList", this.psins);
        interactionE.addContent((Content)partListE);
        this.translateMolObj(partListE, BINDCompE, BINDComplexID, interactionIDsList);
        String intIDStr = "";
        String BINDIntIDStr = "";
        for (int i = 0; i < interactionIDsList.size(); ++i) {
            BINDIntIDStr = BINDIntIDStr + interactionIDsList.get(i);
            intIDStr = intIDStr + this.matchIntID(interactionIDsList.get(i));
            if (i >= interactionIDsList.size() - 1) continue;
            BINDIntIDStr = BINDIntIDStr + ";";
            intIDStr = intIDStr + ";";
        }
        this.addAttribute(interactionE, "Complex Interactions List", intIDStr);
        this.addAttribute(interactionE, "Complex Interactions List - BIND IDs", BINDIntIDStr);
        this.addAttribute(interactionE, "Complex Interactions List Ordered", orderedFlag);
        this.addAttribute(interactionE, "Complex Number of Subunits", subunitNum);
    }

    private void translateExpDesc(Element expListE, Element BINDCompE, String BINDComplexID) throws JDOMException {
        Element expDescE = new Element("experimentDescription", this.psins);
        expDescE.setAttribute("id", Integer.toString(this.expID++));
        expListE.addContent((Content)expDescE);
        Element intDetMethodE = new Element("interactionDetectionMethod", this.psins);
        this.setNames(intDetMethodE, "unspecified method", "unspecified method");
        this.setXRef(intDetMethodE, "primaryRef", "psimi", "MI:0488", "MI:0686", null, null);
        this.translatePubMed(expDescE, BINDCompE);
        this.translatePubMed2(expDescE, BINDCompE);
        if (expDescE.getChildren("bibref", this.psins).size() == 0) {
            Element bibRefE = new Element("bibref", this.psins);
            CVMapEntry CVMapped = CVMapEntry.getMappedEntry("bind");
            this.setXRef(bibRefE, "primaryRef", CVMapped.getPSIMITerm_SL(), CVMapped.getPSIMITermID(), BINDComplexID, null, null);
            expDescE.addContent((Content)bibRefE);
        }
        expDescE.addContent((Content)intDetMethodE);
    }

    private void translateMolObj(Element partListE, Element BINDCompE, String BINDComplexID, ArrayList<String> interactionIDsList) throws JDOMException {
        ArrayList<Element> bindMolObjList = XMLUtil.getElement("BIND-mol-object", BINDCompE, XMLUtil.getDepth(BINDCompE.getName()));
        for (int i = 0; i < bindMolObjList.size(); ++i) {
            String subUnitNum = "NO_VALUE";
            Element interactionRefE = null;
            String BINDIntID = null;
            String newIntID = null;
            String interactantAtt = null;
            ArrayList<Element> tempList = XMLUtil.getElement("BIND-mol-object-id", bindMolObjList.get(i), XMLUtil.getDepth(bindMolObjList.get(i).getName()));
            if (XMLUtil.validateSingle("BIND-mol-object-id", tempList)) {
                subUnitNum = tempList.get(0).getTextTrim();
            }
            if (subUnitNum.equals("NO_VALUE")) {
                System.err.println("Error 4: NO ID for subunit for complex: " + BINDComplexID);
            }
            Element partE = new Element("participant", this.psins);
            partE.setAttribute("id", Integer.toString(this.partID++));
            partListE.addContent((Content)partE);
            tempList = XMLUtil.getElement("BIND-mol-object-source_a", bindMolObjList.get(i), XMLUtil.getDepth(bindMolObjList.get(i).getName()));
            if (XMLUtil.validateSingle("BIND-mol-object-source_a", tempList)) {
                interactionRefE = new Element("interactionRef", this.psins);
                BINDIntID = tempList.get(0).getChildText("Interaction-id").trim();
                if (!interactionIDsList.contains(BINDIntID)) {
                    System.err.println("Error 5: Wrong interaction ID referenced in complex: " + BINDIntID);
                    this.badInteractionData = true;
                }
                newIntID = this.matchIntID(BINDIntID);
                interactionRefE.setText(newIntID);
                partE.addContent((Content)interactionRefE);
                interactantAtt = "BIND Interactant A";
            } else {
                tempList = XMLUtil.getElement("BIND-mol-object-source_b", bindMolObjList.get(i), XMLUtil.getDepth(bindMolObjList.get(i).getName()));
                if (XMLUtil.validateSingle("BIND-mol-object-source_b", tempList)) {
                    interactionRefE = new Element("interactionRef", this.psins);
                    BINDIntID = tempList.get(0).getChildText("Interaction-id").trim();
                    if (!interactionIDsList.contains(BINDIntID)) {
                        System.err.println("Error 5: Wrong interaction ID referenced in complex: " + BINDIntID);
                        this.badInteractionData = true;
                    }
                    newIntID = this.matchIntID(BINDIntID);
                    interactionRefE.setText(newIntID);
                    partE.addContent((Content)interactionRefE);
                    interactantAtt = "BIND Interactant B";
                }
            }
            Element interactorE = new Element("interactor", this.psins);
            this.translateInteractor(interactorE, bindMolObjList.get(i), this.interactorID++);
            if (interactantAtt == null) {
                partE.addContent((Content)interactorE);
            } else {
                this.addAttribute(partE, "Complex Interactant Source", interactantAtt);
                this.addAttribute(partE, "Interaction Ref - BIND ID", BINDIntID);
            }
            this.addAttribute(partE, "Complex Subunit Number", subUnitNum);
        }
    }

    private String matchIntID(String BINDIntID) {
        if (interactionsMap.containsKey(BINDIntID)) {
            if (badInteractionsMap.containsKey(BINDIntID)) {
                System.err.println("Error 6: Interaction referenced from complex is a 'bad' interaction.");
                this.badInteractionData = true;
            }
            return (String)interactionsMap.get(BINDIntID);
        }
        System.err.println("Error 7: Bad reference from complex. Interaction does not exist for this species: " + BINDIntID);
        this.badInteractionData = true;
        return BINDIntID;
    }
}

