/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.jdo.engine.AbstractConnectionFactory;
import org.castor.jdo.engine.DatabaseRegistry;
import org.castor.jdo.engine.SQLTypeInfos;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.engine.JDOFieldDescriptor;
import org.exolab.castor.jdo.engine.KeyGeneratorDescriptor;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.engine.SQLFieldInfo;
import org.exolab.castor.jdo.engine.SQLStatementLookup;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.Complex;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.util.Messages;

public final class SQLStatementCreate {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$exolab$castor$jdo$engine$SQLStatementCreate == null ? (class$org$exolab$castor$jdo$engine$SQLStatementCreate = SQLStatementCreate.class$("org.exolab.castor.jdo.engine.SQLStatementCreate")) : class$org$exolab$castor$jdo$engine$SQLStatementCreate));
    private final SQLEngine _engine;
    private final PersistenceFactory _factory;
    private final String _type;
    private final String _mapTo;
    private KeyGenerator _keyGen;
    private final boolean _useJDBC30;
    private SQLStatementLookup _lookupStatement;
    private String _statement;
    static /* synthetic */ Class class$org$exolab$castor$jdo$engine$SQLStatementCreate;

    public SQLStatementCreate(SQLEngine engine, PersistenceFactory factory) throws MappingException {
        KeyGeneratorDescriptor keyGenDesc;
        this._engine = engine;
        this._factory = factory;
        this._type = engine.getDescriptor().getJavaClass().getName();
        this._mapTo = engine.getDescriptor().getTableName();
        this._keyGen = null;
        if (engine.getDescriptor().getExtends() == null && (keyGenDesc = engine.getDescriptor().getKeyGeneratorDescriptor()) != null) {
            int[] tempType = ((JDOFieldDescriptor)engine.getDescriptor().getIdentity()).getSQLType();
            this._keyGen = keyGenDesc.getKeyGeneratorRegistry().getKeyGenerator(this._factory, keyGenDesc, tempType == null ? 0 : tempType[0]);
            this._keyGen.supportsSqlType(tempType[0]);
        }
        this._useJDBC30 = Boolean.valueOf(LocalConfiguration.getInstance().getProperty("org.castor.jdo.use.jdbc30", "false"));
        this._lookupStatement = new SQLStatementLookup(engine, factory);
        this.buildStatement();
    }

    private void buildStatement() {
        int i;
        StringBuffer sql = new StringBuffer("INSERT INTO ");
        sql.append(this._factory.quoteName(this._mapTo)).append(" (");
        int count = 0;
        boolean keyGened = false;
        SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
        for (int i2 = 0; i2 < ids.length; ++i2) {
            if (this._keyGen != null && this._keyGen.getStyle() != -1) continue;
            if (count > 0) {
                sql.append(',');
            }
            keyGened = true;
            sql.append(this._factory.quoteName(ids[i2].getName()));
            ++count;
        }
        SQLFieldInfo[] fields = this._engine.getInfo();
        for (i = 0; i < fields.length; ++i) {
            if (!fields[i].isStore()) continue;
            SQLColumnInfo[] columns = fields[i].getColumnInfo();
            for (int j = 0; j < columns.length; ++j) {
                if (count > 0) {
                    sql.append(',');
                }
                sql.append(this._factory.quoteName(columns[j].getName()));
                ++count;
            }
        }
        if (count == 0) {
            sql.setLength(sql.length() - 2);
        } else {
            sql.append(")");
        }
        sql.append(" VALUES (");
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                sql.append(',');
            }
            sql.append('?');
        }
        sql.append(')');
        this._statement = sql.toString();
        if (!keyGened) {
            try {
                this._statement = this._keyGen.patchSQL(this._statement, ids[0].getName());
            }
            catch (MappingException except) {
                LOG.fatal((Object)except);
                this._keyGen = null;
                this.buildStatement();
                return;
            }
            if (this._keyGen.getStyle() == 0) {
                this._statement = "{call " + this._statement + "}";
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.format("jdo.creating", this._type, this._statement));
        }
    }

    public Object executeStatement(Database database, Object conn, Object identity, Object[] fields) throws PersistenceException {
        SQLEngine extended = this._engine.getExtends();
        if (extended == null && this._keyGen == null && identity == null) {
            throw new PersistenceException(Messages.format("persist.noIdentity", this._type));
        }
        PreparedStatement stmt = null;
        try {
            int i;
            if (extended != null) {
                if (!extended.getDescriptor().getTableName().equals(this._mapTo)) {
                    identity = extended.create(database, conn, fields, identity);
                }
            } else if (this._keyGen != null && this._keyGen.getStyle() == -1) {
                identity = this.generateKey(database, conn, null);
            }
            stmt = this._keyGen != null && this._keyGen.getStyle() == 0 ? ((Connection)conn).prepareCall(this._statement) : (this._useJDBC30 ? ((Connection)conn).prepareStatement(this._statement, 1) : ((Connection)conn).prepareStatement(this._statement));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.format("jdo.creating", this._type, stmt.toString()));
            }
            int count = 1;
            SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
            if (this._keyGen == null || this._keyGen.getStyle() == -1) {
                if (ids.length > 1 && !(identity instanceof Complex)) {
                    throw new PersistenceException("Multiple identities expected!");
                }
                if (identity instanceof Complex) {
                    Complex id = (Complex)identity;
                    if (id.size() != ids.length || ids.length <= 1) {
                        throw new PersistenceException("Size of complex field mismatched!");
                    }
                    for (i = 0; i < ids.length; ++i) {
                        stmt.setObject(count++, ids[i].toSQL(id.get(i)));
                    }
                } else {
                    if (ids.length != 1) {
                        throw new PersistenceException("Complex field expected!");
                    }
                    stmt.setObject(count++, ids[0].toSQL(identity));
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.format("jdo.creating", this._type, stmt.toString()));
            }
            count = this.bindFields(fields, stmt, count);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.format("jdo.creating", this._type, stmt.toString()));
            }
            if (this._keyGen != null && this._keyGen.getStyle() == 0) {
                CallableStatement cstmt = (CallableStatement)stmt;
                int sqlType = ids[0].getSqlType();
                cstmt.registerOutParameter(count, sqlType);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.format("jdo.creating.bound", this._type, cstmt));
                }
                cstmt.execute();
                while (cstmt.getMoreResults() || cstmt.getUpdateCount() != -1) {
                }
                identity = sqlType == 4 ? new Integer(cstmt.getInt(count)) : cstmt.getObject(count);
                identity = ids[0].toJava(identity);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.format("jdo.creating", this._type, stmt.toString()));
                }
                stmt.executeUpdate();
                if (this._useJDBC30 && identity == null) {
                    ResultSet keySet = stmt.getGeneratedKeys();
                    i = 1;
                    LinkedList<Object> keys = new LinkedList<Object>();
                    while (keySet.next()) {
                        int sqlType = ids[i - 1].getSqlType();
                        Object temp = sqlType == 4 ? new Integer(keySet.getInt(i)) : (sqlType == 2 ? keySet.getBigDecimal(i) : keySet.getObject(i));
                        keys.add(temp);
                        ++i;
                    }
                    identity = keys.size() > 1 ? keys.toArray() : ids[0].toJava(keys.iterator().next());
                }
            }
            stmt.close();
            if (this._keyGen != null && this._keyGen.getStyle() == 1 && !this._useJDBC30) {
                identity = this.generateKey(database, conn, stmt);
            }
            return identity;
        }
        catch (SQLException except) {
            Boolean isDupKey;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.format("jdo.storeFatal", this._type, this._statement), (Throwable)except);
            }
            if (Boolean.TRUE.equals(isDupKey = this._factory.isDuplicateKeyException(except))) {
                throw new DuplicateIdentityException(Messages.format("persist.duplicateIdentity", this._type, identity));
            }
            if (Boolean.FALSE.equals(isDupKey)) {
                throw new PersistenceException(Messages.format("persist.nested", except), except);
            }
            this._lookupStatement.executeStatement(conn, identity);
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException except2) {
                LOG.warn((Object)"Problem closing JDBC statement", (Throwable)except2);
            }
            throw new PersistenceException(Messages.format("persist.nested", except), except);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object generateKey(Database database, Object conn, PreparedStatement stmt) throws PersistenceException {
        SQLColumnInfo id = this._engine.getColumnInfoForIdentities()[0];
        Connection connection = !this._keyGen.isInSameConnection() ? this.getSeparateConnection(database) : (Connection)conn;
        Properties prop = null;
        if (stmt != null) {
            prop = new Properties();
            prop.put("insertStatement", stmt);
        }
        try {
            Object identity;
            Object object = connection;
            synchronized (object) {
                identity = this._keyGen.generateKey(connection, this._mapTo, id.getName(), prop);
            }
            if (identity == null) {
                throw new PersistenceException(Messages.format("persist.noIdentity", this._type));
            }
            object = id.toJava(identity);
            Object var11_10 = null;
            if (!this._keyGen.isInSameConnection()) {
                this.closeSeparateConnection(connection);
            }
            return object;
        }
        catch (Throwable throwable) {
            block8: {
                Object var11_11 = null;
                if (this._keyGen.isInSameConnection()) break block8;
                this.closeSeparateConnection(connection);
            }
            throw throwable;
        }
    }

    private int bindFields(Object[] values, PreparedStatement stmt, int count) throws SQLException, PersistenceException {
        SQLFieldInfo[] fields = this._engine.getInfo();
        for (int i = 0; i < fields.length; ++i) {
            SQLColumnInfo[] columns = fields[i].getColumnInfo();
            if (!fields[i].isStore()) continue;
            if (values[i] == null) {
                for (int j = 0; j < columns.length; ++j) {
                    stmt.setNull(count++, columns[j].getSqlType());
                }
                continue;
            }
            if (values[i] instanceof Complex) {
                Complex complex = (Complex)values[i];
                if (complex.size() != columns.length) {
                    throw new PersistenceException("Size of complex field mismatch!");
                }
                for (int j = 0; j < columns.length; ++j) {
                    Object value = complex == null ? null : complex.get(j);
                    SQLTypeInfos.setValue(stmt, count++, columns[j].toSQL(value), columns[j].getSqlType());
                }
                continue;
            }
            if (columns.length != 1) {
                throw new PersistenceException("Complex field expected!");
            }
            SQLTypeInfos.setValue(stmt, count++, columns[0].toSQL(values[i]), columns[0].getSqlType());
        }
        return count;
    }

    private Connection getSeparateConnection(Database database) throws PersistenceException {
        AbstractConnectionFactory factory = null;
        try {
            factory = DatabaseRegistry.getConnectionFactory(database.getDatabaseName());
        }
        catch (MappingException e) {
            throw new PersistenceException(Messages.message("persist.cannotCreateSeparateConn"), e);
        }
        try {
            Connection conn = factory.createConnection();
            conn.setAutoCommit(false);
            return conn;
        }
        catch (SQLException e) {
            throw new PersistenceException(Messages.message("persist.cannotCreateSeparateConn"), e);
        }
    }

    private void closeSeparateConnection(Connection conn) {
        try {
            if (!conn.isClosed()) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

