/*
 * Decompiled with CFR 0.152.
 */
package org.castor.persist.resolver;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.persist.ProposedObject;
import org.castor.persist.TransactionContext;
import org.castor.persist.UpdateAndRemovedFlags;
import org.castor.persist.UpdateFlags;
import org.castor.persist.proxy.SingleProxy;
import org.castor.persist.resolver.ResolverStrategy;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.ClassMolderHelper;
import org.exolab.castor.persist.FieldMolder;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.OID;

public final class PersistanceCapableRelationResolver
implements ResolverStrategy {
    private ClassMolder _classMolder;
    private FieldMolder _fieldMolder;
    private boolean _debug;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$castor$persist$resolver$PersistanceCapableRelationResolver == null ? (class$org$castor$persist$resolver$PersistanceCapableRelationResolver = PersistanceCapableRelationResolver.class$("org.castor.persist.resolver.PersistanceCapableRelationResolver")) : class$org$castor$persist$resolver$PersistanceCapableRelationResolver));
    static /* synthetic */ Class class$org$castor$persist$resolver$PersistanceCapableRelationResolver;

    public PersistanceCapableRelationResolver(ClassMolder classMolder, FieldMolder fieldMolder, boolean debug) {
        this._classMolder = classMolder;
        this._fieldMolder = fieldMolder;
        this._debug = debug;
    }

    public Object create(TransactionContext tx, Object object) {
        Object fid;
        Object field = null;
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        Object o = this._fieldMolder.getValue(object, tx.getClassLoader());
        if (o != null && (fid = fieldClassMolder.getIdentity(tx, o)) != null) {
            field = fid;
        }
        return field;
    }

    public boolean markCreate(TransactionContext tx, OID oid, Object object) throws PersistenceException {
        boolean updateCache = false;
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        LockEngine fieldEngine = this._fieldMolder.getFieldLockEngine();
        Object o = this._fieldMolder.getValue(object, tx.getClassLoader());
        if (o != null) {
            if (this._fieldMolder.isDependent()) {
                if (!tx.isRecorded(o)) {
                    tx.markCreate(fieldEngine, fieldClassMolder, o, oid);
                    if (!this._fieldMolder.isStored() && fieldClassMolder.isKeyGenUsed()) {
                        updateCache = true;
                    }
                } else if (!tx.isDepended(oid, o)) {
                    throw new PersistenceException("Dependent object may not change its master. Object: " + o + " new master: " + oid);
                }
            } else if (tx.isAutoStore() && !tx.isRecorded(o)) {
                tx.markCreate(fieldEngine, fieldClassMolder, o, null);
                if (!this._fieldMolder.isStored() && fieldClassMolder.isKeyGenUsed()) {
                    updateCache = true;
                }
            }
        }
        return updateCache;
    }

    public UpdateFlags preStore(TransactionContext tx, OID oid, Object object, int timeout, Object field) throws PersistenceException {
        UpdateFlags flags = new UpdateFlags();
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        LockEngine fieldEngine = this._fieldMolder.getFieldLockEngine();
        Object value = this._fieldMolder.getValue(object, tx.getClassLoader());
        Object newField = null;
        if (value != null) {
            newField = fieldClassMolder.getIdentity(tx, value);
            flags.setNewField(newField);
        }
        if (ClassMolderHelper.isEquals(field, newField)) {
            if (field == null && value != null && this._fieldMolder.isDependent() && !tx.isRecorded(value)) {
                if (this._fieldMolder.isStored() && this._fieldMolder.isCheckDirty()) {
                    flags.setUpdatePersist(true);
                }
                flags.setUpdateCache(true);
                tx.markCreate(fieldEngine, fieldClassMolder, value, oid);
            }
            if (!this._debug) {
                return flags;
            }
            if (field == null) {
                return flags;
            }
            if (value != null && tx.isDeleted(value)) {
                LOG.warn((Object)"Deleted object found!");
                if (this._fieldMolder.isStored() && this._fieldMolder.isCheckDirty()) {
                    flags.setUpdatePersist(true);
                }
                flags.setUpdateCache(true);
                this._fieldMolder.setValue(object, null, tx.getClassLoader());
                return flags;
            }
            if ((tx.isAutoStore() || this._fieldMolder.isDependent()) && value != tx.fetch(fieldEngine, fieldClassMolder, field, null)) {
                throw new DuplicateIdentityException("");
            }
        } else {
            if (this._fieldMolder.isStored() && this._fieldMolder.isCheckDirty()) {
                flags.setUpdatePersist(true);
            }
            flags.setUpdateCache(true);
            if (this._fieldMolder.isDependent()) {
                Object reldel;
                if (field != null && (reldel = tx.fetch(fieldEngine, fieldClassMolder, field, null)) != null) {
                    tx.delete(reldel);
                }
                if (value != null && !tx.isRecorded(value)) {
                    tx.markCreate(fieldEngine, fieldClassMolder, value, oid);
                }
            } else if (tx.isAutoStore()) {
                Object deref;
                if (field != null && (deref = tx.fetch(fieldEngine, fieldClassMolder, field, null)) != null) {
                    fieldClassMolder.removeRelation(tx, deref, this._classMolder, object);
                }
                if (value != null && !tx.isRecorded(value)) {
                    tx.markCreate(fieldEngine, fieldClassMolder, value, null);
                }
            } else {
                Object deref;
                if (field != null && (deref = tx.fetch(fieldEngine, fieldClassMolder, field, null)) != null) {
                    fieldClassMolder.removeRelation(tx, deref, this._classMolder, object);
                }
                if (value != null && !tx.isRecorded(value)) {
                    throw new PersistenceException("Object, " + object + ", links to another object, " + value + " that is not loaded/updated/created in this transaction");
                }
            }
        }
        return flags;
    }

    public Object store(TransactionContext tx, Object object, Object field) {
        Object newField = null;
        if (this._fieldMolder.isStored()) {
            ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
            Object value = this._fieldMolder.getValue(object, tx.getClassLoader());
            if (value != null) {
                newField = fieldClassMolder.getIdentity(tx, value);
            }
        }
        return newField;
    }

    public void update(TransactionContext tx, OID oid, Object object, AccessMode suggestedAccessMode, Object field) throws PersistenceException {
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        LockEngine fieldEngine = this._fieldMolder.getFieldLockEngine();
        Object o = this._fieldMolder.getValue(object, tx.getClassLoader());
        if (this._fieldMolder.isDependent()) {
            if (o != null && !tx.isRecorded(o)) {
                tx.markUpdate(fieldEngine, fieldClassMolder, o, oid);
            }
            if (field != null) {
                ProposedObject proposedValue = new ProposedObject();
                tx.load(fieldEngine, fieldClassMolder, field, proposedValue, suggestedAccessMode);
            }
        } else if (tx.isAutoStore()) {
            if (o != null && !tx.isRecorded(o)) {
                tx.markUpdate(fieldEngine, fieldClassMolder, o, null);
            }
            if (field != null) {
                ProposedObject proposedValue = new ProposedObject();
                tx.load(fieldEngine, fieldClassMolder, field, proposedValue, suggestedAccessMode);
            }
        }
    }

    public Object updateCache(TransactionContext tx, OID oid, Object object) {
        Object field = null;
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        Object value = this._fieldMolder.getValue(object, tx.getClassLoader());
        if (value != null) {
            Object fid = fieldClassMolder.getIdentity(tx, value);
            if (fid != null) {
                field = fid;
            }
        } else {
            field = null;
        }
        return field;
    }

    public void markDelete(TransactionContext tx, Object object, Object field) throws PersistenceException {
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        LockEngine fieldEngine = this._fieldMolder.getFieldLockEngine();
        if (this._fieldMolder.isDependent()) {
            Object fobject;
            Object fid = field;
            Object fetched = null;
            if (fid != null && (fetched = tx.fetch(fieldEngine, fieldClassMolder, fid, null)) != null) {
                tx.delete(fetched);
            }
            if ((fobject = this._fieldMolder.getValue(object, tx.getClassLoader())) != null && tx.isPersistent(fobject)) {
                tx.delete(fobject);
            }
        } else {
            Object fid = field;
            Object fetched = null;
            if (fid != null && (fetched = tx.fetch(fieldEngine, fieldClassMolder, field, null)) != null) {
                fieldClassMolder.removeRelation(tx, fetched, this._classMolder, object);
            }
        }
    }

    public void revertObject(TransactionContext tx, OID oid, Object object, Object field) throws PersistenceException {
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        LockEngine fieldEngine = this._fieldMolder.getFieldLockEngine();
        if (field != null) {
            Object value = tx.fetch(fieldEngine, fieldClassMolder, field, null);
            this._fieldMolder.setValue(object, value, tx.getClassLoader());
        } else {
            this._fieldMolder.setValue(object, null, tx.getClassLoader());
        }
    }

    public void expireCache(TransactionContext tx, Object field) throws PersistenceException {
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        LockEngine fieldEngine = this._fieldMolder.getFieldLockEngine();
        if (field != null) {
            tx.expireCache(fieldEngine, fieldClassMolder, field);
        }
    }

    public void load(TransactionContext tx, OID oid, ProposedObject proposedObject, AccessMode suggestedAccessMode, Object field) throws PersistenceException {
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        LockEngine fieldEngine = this._fieldMolder.getFieldLockEngine();
        if (field != null) {
            Object temp;
            try {
                if (this._fieldMolder.isLazy()) {
                    temp = SingleProxy.getProxy(tx, fieldEngine, fieldClassMolder, field, null, suggestedAccessMode);
                } else {
                    ProposedObject proposedTemp = new ProposedObject();
                    temp = tx.load(fieldEngine, fieldClassMolder, field, proposedTemp, suggestedAccessMode);
                }
            }
            catch (ObjectNotFoundException ex) {
                temp = null;
            }
            this._fieldMolder.setValue(proposedObject.getObject(), temp, tx.getClassLoader());
        } else {
            this._fieldMolder.setValue(proposedObject.getObject(), null, tx.getClassLoader());
        }
    }

    public Object postCreate(TransactionContext tx, OID oid, Object object, Object field, Object createdId) {
        return field;
    }

    public UpdateAndRemovedFlags removeRelation(TransactionContext tx, Object object, ClassMolder relatedMolder, Object relatedObject) {
        Object related;
        ClassMolder relatedBaseMolder;
        UpdateAndRemovedFlags flags = new UpdateAndRemovedFlags();
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        for (relatedBaseMolder = relatedMolder; fieldClassMolder != relatedBaseMolder && relatedBaseMolder != null; relatedBaseMolder = relatedBaseMolder.getExtends()) {
        }
        if (fieldClassMolder == relatedBaseMolder && (related = this._fieldMolder.getValue(object, tx.getClassLoader())) == relatedObject) {
            this._fieldMolder.setValue(object, null, tx.getClassLoader());
            flags.setUpdateCache(true);
            flags.setUpdatePersist(true);
            flags.setRemoved(true);
        }
        return flags;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

