/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.proteomics.common;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class CommonUtilities {
    private CommonUtilities() {
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static URL getResource(String string) {
        return CommonUtilities.getClassLoader().getResource(string);
    }

    public static URL getResource(String string, String string2) {
        URL uRL = null;
        try {
            if (string2 == null) {
                throw new IOException("Restriction string cannot be null");
            }
            Enumeration<URL> enumeration = CommonUtilities.getClassLoader().getResources(string);
            while (enumeration.hasMoreElements()) {
                URL uRL2 = enumeration.nextElement();
                if (uRL2.toString().indexOf(string2) <= 0) continue;
                uRL = uRL2;
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            return null;
        }
        return uRL;
    }

    public static boolean xorNull(Object object, Object object2) {
        if (object != null && object2 == null) {
            return true;
        }
        return object == null && object2 != null;
    }

    public static void dumpCollection(Collection collection, Logger logger) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            logger.debug(iterator.next());
        }
    }

    public static int safeParseInt(String string, int n) {
        int n2;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n;
        }
        return n2;
    }

    public static long safeParseLong(String string, long l) {
        long l2;
        try {
            l2 = Long.parseLong(string);
        }
        catch (Exception exception) {
            return l;
        }
        return l2;
    }
}

