/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import org.exolab.castor.builder.ClassInfo;
import org.exolab.castor.builder.XMLInfo;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class FieldInfo
extends XMLInfo {
    public static final int READ_METHOD = 1;
    public static final int WRITE_METHOD = 2;
    public static final int READ_WRITE_METHODS = 3;
    private static final String METHOD_PREFIX_ADD = "add";
    private static final String METHOD_PREFIX_DELETE = "delete";
    private static final String METHOD_PREFIX_GET = "get";
    private static final String METHOD_PREFIX_HAS = "has";
    private static final String METHOD_PREFIX_SET = "set";
    private String name = null;
    private ClassInfo declaringClassInfo = null;
    private String _comment = null;
    private String _default = null;
    private String _fixed = null;
    private boolean _final = false;
    private int _methods = 3;
    private String _reference = null;
    private boolean _static = false;
    private boolean _transient = false;
    private boolean _bound = false;
    private boolean _isContainer = false;
    private String _fieldHandler;
    private boolean _nillable = false;
    private String _validator;

    public FieldInfo(XSType type, String name) {
        this.name = name;
        this.setSchemaType(type);
    }

    public void createJavaField(JClass jClass) {
        XSType type = this.getSchemaType();
        JType jType = type.getJType();
        JField field = new JField(type.getJType(), this.name);
        if (this._static || this._final) {
            JModifiers modifiers = field.getModifiers();
            modifiers.setFinal(this._final);
            modifiers.setStatic(this._static);
        }
        if (this._default != null) {
            field.setInitString(this._default);
        }
        if (this._fixed != null && !this.getSchemaType().isDateTime()) {
            field.setInitString(this._fixed);
        }
        if (this._comment != null) {
            field.setComment(this._comment);
        }
        jClass.addField(field);
        if (!type.isEnumerated() && jType.isPrimitive()) {
            field = new JField(JType.Boolean, "_has" + this.name);
            field.setComment("keeps track of state for field: " + this.name);
            jClass.addField(field);
        }
    }

    public void createAccessMethods(JClass jClass) {
        if ((this._methods & 1) > 0) {
            this.createGetterMethod(jClass);
        }
        if ((this._methods & 2) > 0) {
            this.createSetterMethod(jClass);
        }
        if (this.isHasAndDeleteMethods()) {
            this.createHasAndDeleteMethods(jClass);
        }
    }

    public void createGetterComment(JDocComment jDocComment) {
        String fieldName = this.name;
        if (fieldName.indexOf(95) == 0) {
            fieldName = fieldName.substring(1);
        }
        String at_return = "the value of field '" + fieldName + "'.";
        String mComment = "Returns " + at_return;
        if (this._comment != null && this._comment.length() > 0) {
            mComment = mComment + " The field '" + fieldName + "' has the following description: ";
            if (this._comment.startsWith("@")) {
                mComment = mComment + "\n\n";
            }
            mComment = mComment + this._comment;
        }
        jDocComment.setComment(mComment);
        jDocComment.addDescriptor(JDocDescriptor.createReturnDesc(at_return));
    }

    public void createGetterMethod(JClass jClass) {
        JMethod method = null;
        JSourceCode jsc = null;
        String mname = this.methodSuffix();
        XSType xsType = this.getSchemaType();
        JType jType = xsType.getJType();
        method = new JMethod(jType, METHOD_PREFIX_GET + mname);
        jClass.addMethod(method);
        this.createGetterComment(method.getJDocComment());
        jsc = method.getSourceCode();
        jsc.add("return this.");
        jsc.append(this.name);
        jsc.append(";");
    }

    public void createHasAndDeleteMethods(JClass jClass) {
        JMethod method = null;
        JSourceCode jsc = null;
        String mname = this.methodSuffix();
        XSType xsType = this.getSchemaType();
        JType jType = xsType.getJType();
        method = new JMethod(JType.Boolean, METHOD_PREFIX_HAS + mname);
        jClass.addMethod(method);
        jsc = method.getSourceCode();
        jsc.add("return this._has");
        jsc.append(this.getName());
        jsc.append(";");
        method = new JMethod(null, METHOD_PREFIX_DELETE + mname);
        jClass.addMethod(method);
        jsc = method.getSourceCode();
        jsc.add("this._has");
        jsc.append(this.getName());
        jsc.append("= false;");
        if (this._bound) {
            jsc.add("notifyPropertyChangeListeners(\"");
            jsc.append(this.getName());
            jsc.append("\", ");
            jsc.append(xsType.createToJavaObjectCode("this." + this.getName()));
            jsc.append(", null");
            jsc.append(");");
        }
    }

    public void createSetterComment(JDocComment jDocComment) {
        String fieldName = this.name;
        if (fieldName.indexOf(95) == 0) {
            fieldName = fieldName.substring(1);
        }
        String at_param = "the value of field '" + fieldName + "'.";
        String mComment = "Sets " + at_param;
        if (this._comment != null && this._comment.length() > 0) {
            mComment = mComment + " The field '" + fieldName + "' has the following description: ";
            if (this._comment.startsWith("@")) {
                mComment = mComment + "\n\n";
            }
            mComment = mComment + this._comment;
        }
        jDocComment.setComment(mComment);
        JDocDescriptor paramDesc = jDocComment.getParamDescriptor(fieldName);
        if (paramDesc == null) {
            paramDesc = JDocDescriptor.createParamDesc(fieldName, null);
            jDocComment.addDescriptor(paramDesc);
        }
        paramDesc.setDescription(at_param);
    }

    public void createSetterMethod(JClass jClass) {
        String tempName;
        JMethod method = null;
        JSourceCode jsc = null;
        String mname = this.methodSuffix();
        XSType xsType = this.getSchemaType();
        JType jType = xsType.getJType();
        method = new JMethod(null, METHOD_PREFIX_SET + mname);
        jClass.addMethod(method);
        String paramName = this.name;
        if (paramName.indexOf(95) == 0 && JavaNaming.isValidJavaIdentifier(tempName = paramName.substring(1))) {
            paramName = tempName;
        }
        method.addParameter(new JParameter(jType, paramName));
        this.createSetterComment(method.getJDocComment());
        jsc = method.getSourceCode();
        if (this._bound) {
            jsc.add("java.lang.Object old");
            jsc.append(mname);
            jsc.append(" = ");
            jsc.append(xsType.createToJavaObjectCode("this." + this.getName()));
            jsc.append(";");
        }
        jsc.add("this.");
        jsc.append(this.getName());
        jsc.append(" = ");
        jsc.append(paramName);
        jsc.append(";");
        if (this._reference != null) {
            jsc.add("this.");
            jsc.append(this._reference);
            jsc.append(" = ");
            jsc.append(paramName);
            jsc.append(";");
        }
        if (this.isHasAndDeleteMethods()) {
            jsc.add("this._has");
            jsc.append(this.getName());
            jsc.append(" = true;");
        }
        if (this._bound) {
            jsc.add("notifyPropertyChangeListeners(\"");
            jsc.append(this.getName());
            jsc.append("\", old");
            jsc.append(mname);
            jsc.append(", ");
            jsc.append(xsType.createToJavaObjectCode("this." + this.getName()));
            jsc.append(");");
        }
    }

    public String getDefaultValue() {
        return this._default;
    }

    public String getFixedValue() {
        return this._fixed;
    }

    public String getDeleteMethodName() {
        return METHOD_PREFIX_DELETE + this.methodSuffix();
    }

    public String getHasMethodName() {
        return METHOD_PREFIX_HAS + this.methodSuffix();
    }

    public String getReadMethodName() {
        return METHOD_PREFIX_GET + this.methodSuffix();
    }

    public String getValidator() {
        return this._validator;
    }

    public String getWriteMethodName() {
        if (this.isMultivalued()) {
            return METHOD_PREFIX_ADD + this.methodSuffix();
        }
        return METHOD_PREFIX_SET + this.methodSuffix();
    }

    public String getXMLFieldHandler() {
        return this._fieldHandler;
    }

    public void generateInitializerCode(JSourceCode jsc) {
        if (!this.getSchemaType().isPrimitive()) {
            String value = this.getDefaultValue();
            boolean dateTime = this.getSchemaType().isDateTime();
            if (value == null) {
                value = this.getFixedValue();
            }
            if (value != null) {
                StringBuffer buffer = new StringBuffer(50);
                if (dateTime) {
                    jsc.add("try {");
                    jsc.indent();
                }
                buffer.append(METHOD_PREFIX_SET);
                buffer.append(this.methodSuffix());
                buffer.append('(');
                buffer.append(value);
                buffer.append(");");
                jsc.add(buffer.toString());
                if (dateTime) {
                    jsc.unindent();
                    jsc.add("} catch (java.text.ParseException pe) {");
                    jsc.indent();
                    jsc.add("throw new IllegalStateException(pe.getMessage());");
                    jsc.unindent();
                    jsc.add("}");
                }
            }
        }
    }

    public String getComment() {
        return this._comment;
    }

    public int getMethods() {
        return this._methods;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBound() {
        return this._bound;
    }

    public boolean isContainer() {
        return this._isContainer;
    }

    public boolean isHasAndDeleteMethods() {
        XSType xsType = this.getSchemaType();
        JType jType = xsType.getJType();
        return !xsType.isEnumerated() && jType.isPrimitive();
    }

    public boolean isNillable() {
        return this._nillable;
    }

    public boolean isTransient() {
        return this._transient || this._final || this._static;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }

    public ClassInfo getDeclaringClassInfo() {
        return this.declaringClassInfo;
    }

    public void setBound(boolean bound) {
        this._bound = bound;
    }

    public void setContainer(boolean isContainer) {
        this._isContainer = isContainer;
    }

    public void setDeclaringClassInfo(ClassInfo declaringClassInfo) {
        this.declaringClassInfo = declaringClassInfo;
    }

    public void setDefaultValue(String defaultValue) {
        this._default = defaultValue;
    }

    public void setFinal(boolean isFinal) {
        this._final = isFinal;
    }

    public void setFixedValue(String fixedValue) {
        this._fixed = fixedValue;
    }

    public void setMethods(int methods) {
        this._methods = methods;
    }

    public void setNillable(boolean nillable) {
        this._nillable = nillable;
    }

    public void setReference(String fieldName) {
        this._reference = fieldName;
    }

    public void setStatic(boolean isStatic) {
        this._static = isStatic;
    }

    public void setTransient(boolean isTransient) {
        this._transient = isTransient;
    }

    public void setValidator(String validator) {
        this._validator = validator;
    }

    public void setXMLFieldHandler(String handler) {
        this._fieldHandler = handler;
    }

    protected String methodSuffix() {
        if (this.name.startsWith("_")) {
            return JavaNaming.toJavaClassName(this.name.substring(1));
        }
        return JavaNaming.toJavaClassName(this.name);
    }
}

