/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.custommonkey.xmlunit.ComparisonController;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceEngine;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.ElementNameQualifier;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.Transform;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Diff
implements DifferenceListener,
ComparisonController {
    private final Document controlDoc;
    private final Document testDoc;
    private boolean similar = true;
    private boolean identical = true;
    private boolean compared = false;
    private boolean haltComparison = false;
    private StringBuffer messages;
    private DifferenceEngine differenceEngine;
    private DifferenceListener differenceListenerDelegate;
    private ElementQualifier elementQualifierDelegate;

    public Diff(String control, String test) throws SAXException, IOException, ParserConfigurationException {
        this(new StringReader(control), new StringReader(test));
    }

    public Diff(Reader control, Reader test) throws SAXException, IOException, ParserConfigurationException {
        this(XMLUnit.buildDocument(XMLUnit.getControlParser(), control), XMLUnit.buildDocument(XMLUnit.getTestParser(), test));
    }

    public Diff(Document controlDoc, Document testDoc) {
        this(controlDoc, testDoc, null);
    }

    public Diff(String control, Transform testTransform) throws IOException, TransformerException, ParserConfigurationException, SAXException {
        this(XMLUnit.buildControlDocument(control), testTransform.getResultDocument());
    }

    public Diff(InputSource control, InputSource test) throws SAXException, IOException, ParserConfigurationException {
        this(XMLUnit.buildDocument(XMLUnit.getControlParser(), control), XMLUnit.buildDocument(XMLUnit.getTestParser(), test));
    }

    public Diff(DOMSource control, DOMSource test) {
        this(control.getNode().getOwnerDocument(), test.getNode().getOwnerDocument());
    }

    public Diff(Document controlDoc, Document testDoc, DifferenceEngine comparator) {
        this(controlDoc, testDoc, comparator, new ElementNameQualifier());
    }

    public Diff(Document controlDoc, Document testDoc, DifferenceEngine comparator, ElementQualifier elementQualifier) {
        this.controlDoc = this.getWhitespaceManipulatedDocument(controlDoc);
        this.testDoc = this.getWhitespaceManipulatedDocument(testDoc);
        this.elementQualifierDelegate = elementQualifier;
        this.differenceEngine = comparator == null ? new DifferenceEngine(this) : comparator;
        this.messages = new StringBuffer();
    }

    protected Diff(Diff prototype) {
        this(prototype.controlDoc, prototype.testDoc, prototype.differenceEngine, prototype.elementQualifierDelegate);
    }

    private Document getWhitespaceManipulatedDocument(Document originalDoc) {
        if (!XMLUnit.getIgnoreWhitespace()) {
            return originalDoc;
        }
        try {
            Transform whitespaceStripper = XMLUnit.getStripWhitespaceTransform(originalDoc);
            return whitespaceStripper.getResultDocument();
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessageAndLocation() + "\n" + e.getCause());
        }
    }

    protected final void compare() {
        if (this.compared) {
            return;
        }
        this.differenceEngine.compare(this.controlDoc, this.testDoc, this, this.elementQualifierDelegate);
        this.compared = true;
    }

    public boolean similar() {
        this.compare();
        return this.similar;
    }

    public boolean identical() {
        this.compare();
        return this.identical;
    }

    private void appendDifference(StringBuffer appendTo, Difference difference) {
        appendTo.append(" ").append(difference).append('\n');
    }

    public int differenceFound(Difference difference) {
        int returnValue = 0;
        if (this.differenceListenerDelegate != null) {
            returnValue = this.differenceListenerDelegate.differenceFound(difference);
        }
        switch (returnValue) {
            case 1: {
                return returnValue;
            }
            case 2: {
                this.identical = false;
                this.haltComparison = false;
                break;
            }
            case 0: {
                this.identical = false;
                if (difference.isRecoverable()) {
                    this.haltComparison = false;
                    break;
                }
                this.similar = false;
                this.haltComparison = true;
                break;
            }
            default: {
                throw new IllegalArgumentException(returnValue + " is not a defined DifferenceListener.RETURN_... value");
            }
        }
        if (this.haltComparison) {
            this.messages.append("\n[different]");
        } else {
            this.messages.append("\n[not identical]");
        }
        this.appendDifference(this.messages, difference);
        return returnValue;
    }

    public void skippedComparison(Node control, Node test) {
        if (this.differenceListenerDelegate != null) {
            this.differenceListenerDelegate.skippedComparison(control, test);
        } else {
            System.err.println("DifferenceListener.skippedComparison: unhandled control node type=" + control + ", unhandled test node type=" + test);
        }
    }

    public boolean haltComparison(Difference afterDifference) {
        return this.haltComparison;
    }

    public StringBuffer appendMessage(StringBuffer toAppendTo) {
        this.compare();
        if (this.messages.length() == 0) {
            this.messages.append("[identical]");
        }
        return toAppendTo.append(this.messages.toString());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        this.appendMessage(buf);
        return buf.toString();
    }

    public void overrideDifferenceListener(DifferenceListener delegate) {
        this.differenceListenerDelegate = delegate;
    }

    public void overrideElementQualifier(ElementQualifier delegate) {
        this.elementQualifierDelegate = delegate;
    }
}

