/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.verify.impl;

import java.util.Collection;
import java.util.LinkedList;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.verify.VerificationEngine;
import org.geneontology.oboedit.verify.impl.AbstractTextCheck;

public class NameCheck
extends AbstractTextCheck {
    public NameCheck() {
        this.setAllowNewlines(false);
        this.setAllowBlank(false);
        this.setSentenceStructureChecks(false);
        this.setAllowExtended(Controller.getController().getPreferences().getAllowExtendedCharacters());
    }

    public String getID() {
        return "NAME_CHECK";
    }

    public String getDescription() {
        return "Name checks";
    }

    public String getWarningLabel(IdentifiedObject io, byte condition, int index) {
        if (VerificationEngine.isTextCommitCondition(condition)) {
            return "Name";
        }
        return "Name of <a href='file:" + io.getID() + "'>" + io.getID() + "</a>";
    }

    public Collection getStrings(IdentifiedObject io) {
        LinkedList<String> out = new LinkedList<String>();
        out.add(io.getName());
        return out;
    }
}

