/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.verify.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.verify.AbstractCheck;
import org.geneontology.oboedit.verify.CheckWarning;
import org.geneontology.oboedit.verify.OntologyCheck;
import org.geneontology.util.ProgressEvent;

public class DisjointednessCheck
extends AbstractCheck
implements OntologyCheck {
    public static final int MAX_BAD_ITEMS = 100;

    protected void initConfiguration() {
        this.configuration.setCondition((byte)14);
    }

    public boolean needsReasoner() {
        return true;
    }

    public Collection check(OBOSession history, IdentifiedObject currentObject, byte condition, boolean checkObsoletes) {
        HashSet<CheckWarning> out = new HashSet<CheckWarning>();
        int badItems = 0;
        Iterator it = history.getObjects().iterator();
        int i = 0;
        while (badItems < 100 && it.hasNext()) {
            Object o = it.next();
            boolean isBad = false;
            int percentage = 100 * i / history.getObjects().size();
            this.fireProgressEvent(new ProgressEvent((Object)this, percentage, "checking object " + (i + 1) + " of " + history.getObjects().size()));
            if (o instanceof LinkedObject) {
                LinkedObject lo = (LinkedObject)o;
                HashSet<LinkedObject> superClasses = new HashSet<LinkedObject>();
                Iterator it2 = this.linkDatabase.getParents(lo).iterator();
                while (it2.hasNext()) {
                    Link link = (Link)it2.next();
                    if (!(link.getParent() instanceof OBOClass) || !this.linkDatabase.isSubProperty(link.getType(), OBOProperty.IS_A)) continue;
                    superClasses.add(link.getParent());
                }
                it2 = superClasses.iterator();
                while (it2.hasNext()) {
                    OBOClass oboClass = (OBOClass)it2.next();
                    it2.remove();
                    Iterator it3 = superClasses.iterator();
                    while (it3.hasNext()) {
                        OBOClass oboClass2 = (OBOClass)it3.next();
                        if (!TermUtil.isDisjoint(this.linkDatabase, oboClass, oboClass2, false)) continue;
                        if (!isBad) {
                            ++badItems;
                        }
                        isBad = true;
                        CheckWarning warning = new CheckWarning(lo.getName() + " (" + lo.getID() + ") " + "has disjoint superclasses " + oboClass + " and " + oboClass2, true, this, lo);
                        out.add(warning);
                    }
                }
            }
            ++i;
        }
        return out;
    }

    public String getDescription() {
        return "Disjointedness Check";
    }

    public String getID() {
        return "DISJOINTEDNESS_CHECK";
    }
}

