/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.verify.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.geneontology.oboedit.datamodel.DanglingObject;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.verify.AbstractCheck;
import org.geneontology.oboedit.verify.CheckWarning;
import org.geneontology.oboedit.verify.OntologyCheck;

public class DanglingIntersectionCheck
extends AbstractCheck
implements OntologyCheck {
    protected void initConfiguration() {
        this.configuration.setCondition((byte)24);
    }

    public Collection check(OBOSession history, IdentifiedObject currentObject, byte condition, boolean checkObsoletes) {
        LinkedList out = new LinkedList();
        if (currentObject != null) {
            if (currentObject instanceof LinkedObject) {
                this.check((LinkedObject)currentObject, out);
            }
        } else {
            Iterator it = history.getObjects().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof LinkedObject)) continue;
                LinkedObject lo = (LinkedObject)o;
                this.check(lo, out);
            }
        }
        return out;
    }

    protected void check(LinkedObject object, List warnings) {
        Iterator it = object.getParents().iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            if (!TermUtil.isIntersection(link) || !(link.getParent() instanceof DanglingObject)) continue;
            CheckWarning warning = new CheckWarning("The cross product definition of " + object.getName() + " (" + object.getID() + ") refers to a " + "dangling parent " + link.getParent() + ". " + "Dangling parents cannot be used by " + "the reasoner, so this cross product " + "definition will not be used.", false, this, object);
            warnings.add(warning);
        }
    }

    public String getDescription() {
        return "Dangling Intersection Check";
    }

    public String getID() {
        return "DANGLING_INTERSECTION_CHECK";
    }
}

