/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.verify.impl;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.ReasonedLinkDatabase;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.verify.AbstractCheck;
import org.geneontology.oboedit.verify.CheckConfiguration;
import org.geneontology.oboedit.verify.CheckWarning;
import org.geneontology.oboedit.verify.ObjectCheck;
import org.geneontology.swing.SpringUtilities;

public abstract class AbstractTextCheck
extends AbstractCheck
implements ObjectCheck {
    protected String[] selections = new String[]{"On Text Edit", "Always", "Never"};
    protected JComboBox finalPunctuationList = new JComboBox<String>(this.selections);
    protected JComboBox repeatedWordList = new JComboBox<String>(this.selections);
    protected JComboBox repeatedWhitespaceList = new JComboBox<String>(this.selections);
    protected JComboBox sentenceCaseList = new JComboBox<String>(this.selections);
    protected JComboBox sentenceSeparationList = new JComboBox<String>(this.selections);
    protected ConfigurationPanel configurationPanel = new ConfigurationPanel();
    protected boolean allowNewlines = false;
    protected boolean allowBlank = false;
    protected boolean allowExtended = false;
    protected boolean sentenceStructureChecks = false;
    protected static Collection defaultPeriodWords = new LinkedList();
    protected static Set periodWords = null;
    protected static Set allowedRepeats = null;
    protected static Set alwaysLowercaseWords = null;

    public AbstractTextCheck() {
        defaultPeriodWords.add("i.e.");
        defaultPeriodWords.add("e.g.");
        defaultPeriodWords.add("etc.");
    }

    protected static Set getAllowedRepeats() {
        if (allowedRepeats == null) {
            AbstractTextCheck.reloadWordSets();
        }
        return allowedRepeats;
    }

    protected static Set getPeriodWords() {
        if (periodWords == null) {
            AbstractTextCheck.reloadWordSets();
        }
        return periodWords;
    }

    protected static Set getAlwaysLowercaseWords() {
        if (alwaysLowercaseWords == null) {
            AbstractTextCheck.reloadWordSets();
        }
        return alwaysLowercaseWords;
    }

    protected static void reloadWordSets() {
        allowedRepeats = AbstractTextCheck.loadWordSet("allowedrepeats.txt");
        periodWords = AbstractTextCheck.loadWordSet("periodwords.txt");
        alwaysLowercaseWords = AbstractTextCheck.loadWordSet("alwayslowercase.txt");
        periodWords.addAll(defaultPeriodWords);
    }

    protected static void flushWordSets() {
        AbstractTextCheck.writeWordSet(allowedRepeats, "allowedrepeats.txt");
        AbstractTextCheck.writeWordSet(periodWords, "periodwords.txt");
        AbstractTextCheck.writeWordSet(alwaysLowercaseWords, "alwayslowercase.txt");
    }

    protected static Set loadWordSet(String filename) {
        HashSet<String> out = new HashSet<String>();
        try {
            String line;
            Controller.getController();
            BufferedReader reader = new BufferedReader(new FileReader(new File(Controller.getPrefsDir(), filename)));
            while ((line = reader.readLine()) != null) {
                out.add(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out;
    }

    protected static void writeWordSet(Collection words, String filename) {
        StringBuffer buf = new StringBuffer();
        Iterator it = words.iterator();
        while (it.hasNext()) {
            buf.append(it.next().toString() + "\n");
        }
        AbstractTextCheck.writeWordSet(buf.toString(), filename);
    }

    protected static void writeWordSet(String words, String filename) {
        Controller.getController();
        File file = new File(Controller.getPrefsDir(), filename);
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write(words.trim());
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static String getConditionWord(int condition) {
        if ((condition & 1) > 0) {
            if (condition != 1) {
                return "Always";
            }
            return "On Text Edit";
        }
        return "Never";
    }

    protected static byte getCondition(String word) {
        if (word.equals("Always")) {
            return 31;
        }
        if (word.equals("On Text Edit")) {
            return 1;
        }
        return 0;
    }

    protected void updateConfiguration() {
        AbstractCheckConfiguration config = (AbstractCheckConfiguration)this.configuration;
        config.setRepeatedWordCondition(AbstractTextCheck.getCondition(this.repeatedWordList.getSelectedItem().toString()));
        config.setFinalPunctuationCondition(AbstractTextCheck.getCondition(this.finalPunctuationList.getSelectedItem().toString()));
        config.setRepeatedWhitespaceCondition(AbstractTextCheck.getCondition(this.repeatedWhitespaceList.getSelectedItem().toString()));
        config.setSentenceCaseCondition(AbstractTextCheck.getCondition(this.sentenceCaseList.getSelectedItem().toString()));
        config.setSentenceSeparationCondition(AbstractTextCheck.getCondition(this.sentenceSeparationList.getSelectedItem().toString()));
        AbstractTextCheck.reloadWordSets();
    }

    protected void initConfiguration() {
        this.configuration.setCondition((byte)13);
    }

    protected abstract Collection getStrings(IdentifiedObject var1);

    protected abstract String getWarningLabel(IdentifiedObject var1, byte var2, int var3);

    public boolean needsReasoner() {
        return false;
    }

    public void setReasoner(ReasonedLinkDatabase linkDatabase) {
    }

    protected CheckConfiguration createConfiguration() {
        return new AbstractCheckConfiguration();
    }

    public boolean getSentenceStructureChecks() {
        return this.sentenceStructureChecks;
    }

    public boolean getAllowNewlines() {
        return this.allowNewlines;
    }

    public boolean getAllowExtended() {
        return this.allowExtended;
    }

    public boolean getAllowBlank() {
        return this.allowBlank;
    }

    public void setSentenceStructureChecks(boolean sentenceStructureChecks) {
        this.sentenceStructureChecks = sentenceStructureChecks;
    }

    public void setAllowExtended(boolean allowExtended) {
        this.allowExtended = allowExtended;
    }

    public void setAllowNewlines(boolean allowNewlines) {
        this.allowNewlines = allowNewlines;
    }

    public void setAllowBlank(boolean allowBlank) {
        this.allowBlank = allowBlank;
    }

    public JComponent getConfigurationPanel() {
        this.configurationPanel.removeAll();
        this.configurationPanel.setLayout(new BoxLayout(this.configurationPanel, 1));
        JPanel springPanel = new JPanel();
        springPanel.setLayout(new SpringLayout());
        Color background = Controller.getController().getPreferences().getBackgroundColor();
        Color buttonColor = Controller.getController().getPreferences().getButtonColor();
        Font font = Controller.getController().getPreferences().getFont();
        springPanel.setBackground(background);
        this.finalPunctuationList.setBackground(buttonColor);
        this.repeatedWordList.setBackground(buttonColor);
        this.repeatedWhitespaceList.setBackground(buttonColor);
        this.sentenceCaseList.setBackground(buttonColor);
        this.sentenceSeparationList.setBackground(buttonColor);
        JLabel finalPunctuationLabel = new JLabel("Do final punctuation check");
        JLabel repeatedWordLabel = new JLabel("Do repeated word check");
        JLabel repeatedWhitespaceLabel = new JLabel("Do repeated whitespace check");
        JLabel sentenceCaseLabel = new JLabel("Do sentence case check");
        JLabel sentenceSeparationLabel = new JLabel("Do sentence separation check");
        JLabel repeatLabel = new JLabel("Words to ignore while checking repeats");
        finalPunctuationLabel.setFont(font);
        repeatedWordLabel.setFont(font);
        repeatedWhitespaceLabel.setFont(font);
        sentenceCaseLabel.setFont(font);
        sentenceSeparationLabel.setFont(font);
        repeatLabel.setFont(font);
        this.finalPunctuationList.setFont(font);
        this.repeatedWordList.setFont(font);
        this.repeatedWhitespaceList.setFont(font);
        this.sentenceCaseList.setFont(font);
        this.sentenceSeparationList.setFont(font);
        springPanel.add(finalPunctuationLabel);
        springPanel.add(this.finalPunctuationList);
        springPanel.add(repeatedWordLabel);
        springPanel.add(this.repeatedWordList);
        springPanel.add(repeatedWhitespaceLabel);
        springPanel.add(this.repeatedWhitespaceList);
        if (this.getSentenceStructureChecks()) {
            springPanel.add(sentenceCaseLabel);
            springPanel.add(this.sentenceCaseList);
            springPanel.add(sentenceSeparationLabel);
            springPanel.add(this.sentenceSeparationList);
        }
        this.finalPunctuationList.setSelectedItem(AbstractTextCheck.getConditionWord(((AbstractCheckConfiguration)this.configuration).getFinalPunctuationCondition()));
        this.repeatedWordList.setSelectedItem(AbstractTextCheck.getConditionWord(((AbstractCheckConfiguration)this.configuration).getRepeatedWordCondition()));
        this.repeatedWhitespaceList.setSelectedItem(AbstractTextCheck.getConditionWord(((AbstractCheckConfiguration)this.configuration).getRepeatedWhitespaceCondition()));
        this.sentenceCaseList.setSelectedItem(AbstractTextCheck.getConditionWord(((AbstractCheckConfiguration)this.configuration).getSentenceCaseCondition()));
        this.sentenceSeparationList.setSelectedItem(AbstractTextCheck.getConditionWord(((AbstractCheckConfiguration)this.configuration).getSentenceSeparationCondition()));
        SpringUtilities.makeCompactGrid((Container)springPanel, (int)-1, (int)2, (int)6, (int)6, (int)6, (int)6);
        this.configurationPanel.add(springPanel);
        return this.configurationPanel;
    }

    public Collection check(OBOSession session, IdentifiedObject currentObject, byte condition, boolean checkObsoletes) {
        if (!checkObsoletes && TermUtil.isObsolete(currentObject)) {
            return Collections.EMPTY_LIST;
        }
        LinkedList out = new LinkedList();
        Collection strings = this.getStrings(currentObject);
        Iterator it = strings.iterator();
        int i = 1;
        while (it.hasNext()) {
            String string = (String)it.next();
            out.addAll(this.getWarnings(string, currentObject, this.allowNewlines, this.allowBlank, this.allowExtended, this.sentenceStructureChecks, condition, strings.size() > 1 ? i : 0));
            ++i;
        }
        this.appendAdditionalWarnings(out, session, currentObject, condition);
        return out;
    }

    protected void appendAdditionalWarnings(Collection out, OBOSession session, IdentifiedObject currentObject, byte condition) {
    }

    protected int[] getCurrentPeriodWordRange(String text, int index) {
        int nextIndex;
        char c;
        int previousIndex;
        for (previousIndex = index - 1; previousIndex > 0; --previousIndex) {
            c = text.charAt(previousIndex);
            if (Character.isLetterOrDigit(c) || c == '.') continue;
            ++previousIndex;
            break;
        }
        if (previousIndex == -1) {
            previousIndex = 0;
        }
        for (nextIndex = index; nextIndex < text.length() && (Character.isLetterOrDigit(c = text.charAt(nextIndex)) || c == '.'); ++nextIndex) {
        }
        int[] out = new int[]{previousIndex, nextIndex};
        return out;
    }

    protected int isLegalPeriodWord(String text, int index, IdentifiedObject currentObject) {
        int[] range = this.getCurrentPeriodWordRange(text, index);
        String currentWord = text.substring(range[0], range[1]);
        if (AbstractTextCheck.getPeriodWords().contains(currentWord)) {
            return range[1];
        }
        if (currentWord.length() == 2 && currentWord.charAt(1) == '.') {
            return range[1];
        }
        int numCount = 0;
        int periodCount = 0;
        int otherCount = 0;
        int dashCount = 0;
        for (int i = 0; i < currentWord.length(); ++i) {
            char c = currentWord.charAt(i);
            if (Character.isDigit(c)) {
                ++numCount;
                continue;
            }
            if (c == '.') {
                ++periodCount;
                continue;
            }
            if (c == '-') {
                ++dashCount;
                continue;
            }
            ++otherCount;
        }
        if (otherCount == 0 && numCount > 1 && periodCount > 1) {
            return range[1];
        }
        try {
            Double.parseDouble(currentWord);
            return range[1];
        }
        catch (NumberFormatException ex) {
            boolean isURL = false;
            try {
                new URL(currentWord);
                isURL = true;
            }
            catch (MalformedURLException ex2) {
                // empty catch block
            }
            if (isURL) {
                return range[1];
            }
            return -1;
        }
    }

    protected boolean doFinalPunctuationCheck(byte condition) {
        return this.getSentenceStructureChecks() && ((AbstractCheckConfiguration)this.configuration).getFinalPunctuationCondition() > 0;
    }

    protected boolean doRepeatedWordCheck(byte condition) {
        return ((AbstractCheckConfiguration)this.configuration).getRepeatedWordCondition() > 0;
    }

    protected boolean doRepeatedWhitespaceCheck(byte condition) {
        return ((AbstractCheckConfiguration)this.configuration).getRepeatedWhitespaceCondition() > 0;
    }

    protected boolean doSentenceCaseCheck(byte condition) {
        return this.getSentenceStructureChecks() && ((AbstractCheckConfiguration)this.configuration).getSentenceCaseCondition() > 0;
    }

    protected boolean doSentenceSeparationCheck(byte condition) {
        return this.getSentenceStructureChecks() && ((AbstractCheckConfiguration)this.configuration).getSentenceSeparationCondition() > 0;
    }

    protected boolean isWord(String wordStr) {
        return wordStr.equals("a") || wordStr.equals("A") || wordStr.equals("I") || wordStr.length() > 1;
    }

    protected boolean isRepeatAllowed(String word) {
        boolean allowed = AbstractTextCheck.getAllowedRepeats().contains(word);
        return allowed;
    }

    protected HistoryItem getFieldChangeHistoryItem(IdentifiedObject currentObject, String newText) {
        return null;
    }

    protected Collection getWarnings(String text, IdentifiedObject currentObject, boolean allowNewlines, boolean allowBlank, boolean allowExtended, boolean sentenceStructureChecks, byte condition, int index) {
        HashSet<String> repeatedWords = null;
        if (this.doRepeatedWordCheck(condition)) {
            repeatedWords = new HashSet<String>();
        }
        boolean foundNoCapSentences = false;
        boolean foundNoSepSentences = false;
        boolean foundExtended = false;
        boolean foundNewlines = false;
        int repeatedWhitespaceStart = -1;
        int repeatedWhitespaceEnd = -1;
        LinkedList<CheckWarning> out = new LinkedList<CheckWarning>();
        if (!allowBlank && text.length() == 0) {
            out.add(new CheckWarning(this.getWarningLabel(currentObject, condition, index) + " cannot be blank.", true, this, currentObject));
            return out;
        }
        if (allowBlank && text.length() == 0) {
            return out;
        }
        if (!allowExtended || !allowNewlines) {
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (!(allowExtended || TermUtil.isLegal(c) || foundExtended)) {
                    out.add(new CheckWarning(this.getWarningLabel(currentObject, condition, index) + " cannot contain extended " + "characters.", true, this, currentObject));
                    foundExtended = true;
                }
                if (allowNewlines || c != '\n' || foundNewlines) continue;
                out.add(new CheckWarning(this.getWarningLabel(currentObject, condition, index) + " cannot contain newlines.", true, this, currentObject));
                foundNewlines = true;
            }
        }
        boolean foundRepeatedWhitespace = false;
        char finalChar = text.charAt(text.length() - 1);
        if (this.doFinalPunctuationCheck(condition) && finalChar != '?' && finalChar != '.' && finalChar != '!') {
            out.add(new CheckWarning(this.getWarningLabel(currentObject, condition, index) + " does not end with a period, " + "question mark or exclamation point.", false, this, currentObject));
        }
        LinkedList<String> words = new LinkedList<String>();
        StringBuffer word = new StringBuffer();
        StringBuffer sentence = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            sentence.append(c);
            if (!foundRepeatedWhitespace && i < text.length() - 1 && Character.isWhitespace(c) && Character.isWhitespace(text.charAt(i + 1))) {
                if (repeatedWhitespaceStart == -1) {
                    repeatedWhitespaceStart = i;
                }
                repeatedWhitespaceEnd = i + 1;
                foundRepeatedWhitespace = true;
            }
            int abbrevIndex = -1;
            if ((c == '?' || c == '!' || c == '.') && (abbrevIndex = this.isLegalPeriodWord(text, i, currentObject)) == -1 && this.isWord(word.toString())) {
                int firstSentenceWordEndIndex;
                int sentenceStartIndex;
                int[] ranges = this.getCurrentPeriodWordRange(text, i);
                final String periodWord = text.substring(ranges[0], ranges[1]);
                words.add(word.toString());
                word = new StringBuffer();
                String s = sentence.toString().trim();
                if (this.doSentenceSeparationCheck(condition) && i < text.length() - 1 && !Character.isWhitespace(text.charAt(i + 1)) && !foundNoSepSentences) {
                    HistoryItem item;
                    LinkedList<AbstractAction> fixes = new LinkedList<AbstractAction>();
                    AbstractAction fixAction = new AbstractAction("Add \"" + periodWord + "\" to legal period-containing words"){

                        public void actionPerformed(ActionEvent e) {
                            AbstractTextCheck.getPeriodWords().add(periodWord);
                            AbstractTextCheck.flushWordSets();
                        }
                    };
                    fixes.add(fixAction);
                    fixAction.putValue("GLOBAL", Boolean.TRUE);
                    String newText = text.substring(0, i + 1) + " " + text.substring(i + 1, text.length());
                    if (condition != 1 && (item = this.getFieldChangeHistoryItem(currentObject, newText)) != null) {
                        int secondWordIndex;
                        int firstWordIndex;
                        for (firstWordIndex = i - 1; firstWordIndex >= 0 && !Character.isWhitespace(text.charAt(firstWordIndex)); --firstWordIndex) {
                        }
                        if (firstWordIndex < 0) {
                            firstWordIndex = 0;
                        }
                        String firstWord = text.substring(firstWordIndex, i + 1);
                        for (secondWordIndex = i + 1; secondWordIndex < text.length() && !Character.isWhitespace(text.charAt(secondWordIndex)); ++secondWordIndex) {
                        }
                        String secondWord = text.substring(i + 1, secondWordIndex);
                        fixes.add(new AbstractAction("Add the missing space between \"" + firstWord + "\" and \"" + secondWord + "\""){

                            public void actionPerformed(ActionEvent e) {
                                Controller.getController().apply(item);
                                Controller.getController().getTextEditManager().forceSync();
                            }
                        });
                    }
                    CheckWarning warning = new CheckWarning(this.getWarningLabel(currentObject, condition, index) + " contains sentences that are " + " not separated by whitespace.", false, this, currentObject, fixes);
                    out.add(warning);
                    foundNoSepSentences = true;
                }
                for (sentenceStartIndex = i - sentence.length() + 1; sentenceStartIndex < text.length() && Character.isWhitespace(text.charAt(sentenceStartIndex)); ++sentenceStartIndex) {
                }
                for (firstSentenceWordEndIndex = sentenceStartIndex; firstSentenceWordEndIndex < text.length() && !Character.isWhitespace(text.charAt(firstSentenceWordEndIndex)); ++firstSentenceWordEndIndex) {
                }
                final String firstSentenceWord = text.substring(sentenceStartIndex, firstSentenceWordEndIndex);
                if (this.doSentenceCaseCheck(condition) && !AbstractTextCheck.getAlwaysLowercaseWords().contains(firstSentenceWord) && !Character.isUpperCase(s.charAt(0)) && Character.isLetter(s.charAt(0)) && !foundNoCapSentences) {
                    HistoryItem item;
                    AbstractAction fixAction = new AbstractAction("Add \"" + firstSentenceWord + "\" to legal always-lowercase words"){

                        public void actionPerformed(ActionEvent e) {
                            AbstractTextCheck.getAlwaysLowercaseWords().add(firstSentenceWord);
                            AbstractTextCheck.flushWordSets();
                        }
                    };
                    fixAction.putValue("GLOBAL", Boolean.TRUE);
                    LinkedList<AbstractAction> fixes = new LinkedList<AbstractAction>();
                    fixes.add(fixAction);
                    String newText = text.substring(0, sentenceStartIndex) + Character.toUpperCase(text.charAt(sentenceStartIndex)) + text.substring(sentenceStartIndex + 1, text.length());
                    if (condition != 1 && (item = this.getFieldChangeHistoryItem(currentObject, newText)) != null) {
                        fixes.add(new AbstractAction("Convert the character to upper case"){

                            public void actionPerformed(ActionEvent e) {
                                Controller.getController().apply(item);
                                Controller.getController().getTextEditManager().forceSync();
                            }
                        });
                    }
                    out.add(new CheckWarning(this.getWarningLabel(currentObject, condition, index) + " contains sentences that do " + "not start with a capital " + "letter.", false, this, currentObject, fixes));
                    foundNoCapSentences = true;
                }
                String lastWord = null;
                Iterator it = words.iterator();
                while (it.hasNext()) {
                    final String wordStr = (String)it.next();
                    if (lastWord != null && this.doRepeatedWordCheck(condition) && this.isWord(wordStr) && wordStr.equalsIgnoreCase(lastWord) && !this.isRepeatAllowed(wordStr) && !repeatedWords.contains(wordStr)) {
                        AbstractAction fixAction = new AbstractAction("Add \"" + wordStr + "\" to legally repeatable words"){

                            public void actionPerformed(ActionEvent e) {
                                AbstractTextCheck.getAllowedRepeats().add(wordStr);
                                AbstractTextCheck.flushWordSets();
                            }
                        };
                        fixAction.putValue("GLOBAL", Boolean.TRUE);
                        LinkedList<5> fixes = new LinkedList<5>();
                        fixes.add(fixAction);
                        out.add(new CheckWarning(this.getWarningLabel(currentObject, condition, index) + " contains the repeated " + "word \"" + wordStr + "\".", false, this, currentObject, fixes));
                        repeatedWords.add(wordStr);
                    }
                    lastWord = wordStr;
                }
                words.clear();
                sentence = new StringBuffer();
                continue;
            }
            if (abbrevIndex > 0) {
                word.append(text.substring(i, abbrevIndex));
                i = abbrevIndex + 1;
                continue;
            }
            if (!Character.isWhitespace(c)) {
                word.append(c);
                continue;
            }
            if (word.length() <= 0) continue;
            words.add(word.toString());
            word = new StringBuffer();
        }
        String lastWord = null;
        Iterator it = words.iterator();
        while (it.hasNext()) {
            final String wordStr = (String)it.next();
            if (lastWord != null && this.doRepeatedWordCheck(condition) && this.isWord(wordStr) && wordStr.equalsIgnoreCase(lastWord) && !this.isRepeatAllowed(wordStr) && !repeatedWords.contains(wordStr)) {
                AbstractAction fixAction = new AbstractAction("Add \"" + wordStr + "\" to legally repeatable words"){

                    public void actionPerformed(ActionEvent e) {
                        AbstractTextCheck.getAllowedRepeats().add(wordStr);
                        AbstractTextCheck.flushWordSets();
                    }
                };
                fixAction.putValue("GLOBAL", Boolean.TRUE);
                LinkedList<6> fixes = new LinkedList<6>();
                fixes.add(fixAction);
                out.add(new CheckWarning(this.getWarningLabel(currentObject, condition, index) + " contains the repeated word \"" + wordStr + "\".", false, this, currentObject, fixes));
                repeatedWords.add(wordStr);
            }
            lastWord = wordStr;
        }
        if (this.doRepeatedWhitespaceCheck(condition) && foundRepeatedWhitespace) {
            int secondWordIndex;
            int firstWordIndex;
            for (firstWordIndex = repeatedWhitespaceStart - 1; firstWordIndex >= 0 && !Character.isWhitespace(text.charAt(firstWordIndex)); --firstWordIndex) {
            }
            String firstWord = text.substring(firstWordIndex + 1, repeatedWhitespaceStart);
            for (secondWordIndex = repeatedWhitespaceEnd + 1; secondWordIndex < text.length() && !Character.isWhitespace(text.charAt(secondWordIndex)); ++secondWordIndex) {
            }
            String secondWord = text.substring(repeatedWhitespaceEnd + 1, secondWordIndex);
            String newText = text.substring(0, repeatedWhitespaceStart) + " " + text.substring(repeatedWhitespaceEnd + 1, text.length());
            final HistoryItem item = this.getFieldChangeHistoryItem(currentObject, newText);
            AbstractAction fixAction = new AbstractAction("Replace repeated spaces with a single space"){

                public void actionPerformed(ActionEvent e) {
                    Controller.getController().apply(item);
                    Controller.getController().getTextEditManager().forceSync();
                }
            };
            fixAction.putValue("GLOBAL", Boolean.TRUE);
            LinkedList<7> fixes = new LinkedList<7>();
            fixes.add(fixAction);
            out.add(new CheckWarning(this.getWarningLabel(currentObject, condition, index) + " contains " + "several whitespace characters " + "in a row between \"" + firstWord + "\" and \"" + secondWord + "\"", false, this, currentObject, fixes));
        }
        return out;
    }

    public static class AbstractCheckConfiguration
    extends CheckConfiguration {
        protected byte repeatedWordCondition = (byte)31;
        protected byte repeatedWhitespaceCondition = (byte)31;
        protected byte sentenceCaseCondition = (byte)31;
        protected byte sentenceSeparationCondition = (byte)31;
        protected byte finalPunctuationCondition = (byte)31;

        public byte getRepeatedWordCondition() {
            return this.repeatedWordCondition;
        }

        public void setRepeatedWordCondition(byte repeatedWordCondition) {
            this.repeatedWordCondition = repeatedWordCondition;
        }

        public byte getRepeatedWhitespaceCondition() {
            return this.repeatedWhitespaceCondition;
        }

        public void setRepeatedWhitespaceCondition(byte repeatedWhitespaceCondition) {
            this.repeatedWhitespaceCondition = repeatedWhitespaceCondition;
        }

        public byte getSentenceCaseCondition() {
            return this.sentenceCaseCondition;
        }

        public void setSentenceCaseCondition(byte sentenceCaseCondition) {
            this.sentenceCaseCondition = sentenceCaseCondition;
        }

        public byte getSentenceSeparationCondition() {
            return this.sentenceSeparationCondition;
        }

        public void setSentenceSeparationCondition(byte sentenceSeparationCondition) {
            this.sentenceSeparationCondition = sentenceSeparationCondition;
        }

        public void setFinalPunctuationCondition(byte finalPunctuationCondition) {
            this.finalPunctuationCondition = finalPunctuationCondition;
        }

        public byte getFinalPunctuationCondition() {
            return this.finalPunctuationCondition;
        }
    }

    protected class ConfigurationPanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;

        protected ConfigurationPanel() {
        }

        public void actionPerformed(ActionEvent e) {
            AbstractTextCheck.this.updateConfiguration();
        }
    }
}

