/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.verify;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Action;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.verify.Check;

public class CheckWarning {
    protected Check source;
    protected IdentifiedObject object;
    protected String message;
    protected boolean isFatal;
    protected Collection fixes;

    public CheckWarning(String message, boolean isFatal) {
        this(message, isFatal, null, null, new LinkedList());
    }

    public CheckWarning(String message, boolean isFatal, IdentifiedObject object) {
        this(message, isFatal, null, object, new LinkedList());
    }

    public CheckWarning(String message, boolean isFatal, Check source, IdentifiedObject object) {
        this(message, isFatal, source, object, new LinkedList());
    }

    public CheckWarning(String message, boolean isFatal, Check source, IdentifiedObject object, Collection fixes) {
        this.source = source;
        this.message = message;
        this.isFatal = isFatal;
        this.object = object;
        this.fixes = fixes;
        Iterator it = fixes.iterator();
        while (it.hasNext()) {
            Action action = (Action)it.next();
            action.putValue("WARNING", this);
        }
    }

    public Collection getFixes() {
        return this.fixes;
    }

    public IdentifiedObject getObject() {
        return this.object;
    }

    public Check getSource() {
        return this.source;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isFatal() {
        return this.isFatal;
    }

    public String toString() {
        return "CheckWarning" + (this.isFatal ? " (fatal)" : "") + ": " + this.message;
    }
}

