/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.verify;

import java.util.HashSet;
import java.util.Set;
import org.geneontology.oboedit.datamodel.Explanation;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOSession;

public class CheckResult {
    protected OBOSession history;
    protected OBOClass term;
    protected Link rel;
    protected boolean isWarning = false;
    protected boolean isFatal = false;
    protected String message;
    protected Set evidence = new HashSet();
    protected Set termList = new HashSet();

    public static CheckResult getFatal(OBOSession history, OBOClass term, String message) {
        return new CheckResult(history, term, null, false, true, message);
    }

    public void addTerm(OBOClass term) {
        this.termList.add(term);
    }

    public Set getTermList() {
        return this.termList;
    }

    public Set getEvidence() {
        return this.evidence;
    }

    public void addEvidence(Explanation exp) {
        this.evidence.add(exp);
    }

    public static CheckResult getError(OBOSession history, OBOClass term, String message) {
        return new CheckResult(history, term, null, false, false, message);
    }

    public static CheckResult getError(OBOSession history, Link rel, String message) {
        return new CheckResult(history, null, rel, false, false, message);
    }

    public static CheckResult getWarning(OBOSession history, OBOClass term, String message) {
        return new CheckResult(history, term, null, true, false, message);
    }

    public CheckResult(OBOSession history, OBOClass term, Link rel, boolean isWarning, boolean isFatal, String message) {
        this.history = history;
        this.term = term;
        this.rel = rel;
        this.isWarning = isWarning;
        this.isFatal = isFatal;
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isFatal() {
        return this.isFatal;
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    public Link getRel() {
        return this.rel;
    }

    public OBOSession getHistory() {
        return this.history;
    }

    public OBOClass getName() {
        return this.term;
    }

    public String toString() {
        return this.message;
    }
}

