/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.test;

import java.util.Iterator;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.geneontology.dataadapter.AdapterConfiguration;
import org.geneontology.dataadapter.IOOperation;
import org.geneontology.oboedit.dataadapter.OBOFileAdapter;
import org.geneontology.oboedit.datamodel.DefaultHistoryList;
import org.geneontology.oboedit.datamodel.HistoryGenerator;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBORestriction;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.OperationModel;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.AddDbxrefHistoryItem;
import org.geneontology.oboedit.datamodel.history.AddSynonymHistoryItem;
import org.geneontology.oboedit.datamodel.history.CardinalityHistoryItem;
import org.geneontology.oboedit.datamodel.history.CategoryChangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.ChangeSynCategoryHistoryItem;
import org.geneontology.oboedit.datamodel.history.ChangeSynScopeHistoryItem;
import org.geneontology.oboedit.datamodel.history.CommentChangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.CompletesHistoryItem;
import org.geneontology.oboedit.datamodel.history.CreateObjectHistoryItem;
import org.geneontology.oboedit.datamodel.history.CyclicHistoryItem;
import org.geneontology.oboedit.datamodel.history.DefinitionChangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.DomainHistoryItem;
import org.geneontology.oboedit.datamodel.history.InverseNecHistoryItem;
import org.geneontology.oboedit.datamodel.history.LinkTypeHistoryItem;
import org.geneontology.oboedit.datamodel.history.MaxCardinalityHistoryItem;
import org.geneontology.oboedit.datamodel.history.MinCardinalityHistoryItem;
import org.geneontology.oboedit.datamodel.history.NameChangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.NamespaceHistoryItem;
import org.geneontology.oboedit.datamodel.history.NecessarilyTrueHistoryItem;
import org.geneontology.oboedit.datamodel.history.ObsoleteObjectHistoryItem;
import org.geneontology.oboedit.datamodel.history.RangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.SecondaryIDHistoryItem;
import org.geneontology.oboedit.datamodel.history.SymmetricHistoryItem;
import org.geneontology.oboedit.datamodel.history.SynonymCategoryHistoryItem;
import org.geneontology.oboedit.datamodel.history.TRNamespaceHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermCategoryHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermCopyHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMergeHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMoveHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermNamespaceHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermSplitHistoryItem;
import org.geneontology.oboedit.datamodel.history.TransitiveHistoryItem;
import org.geneontology.oboedit.datamodel.impl.DbxrefImpl;
import org.geneontology.oboedit.datamodel.impl.DefaultOperationModel;
import org.geneontology.oboedit.datamodel.impl.SynonymCategoryImpl;
import org.geneontology.oboedit.datamodel.impl.TermCategoryImpl;
import org.geneontology.oboedit.test.TestUtil;

public class HistoryTest
extends TestCase {
    protected OBOSession session;
    protected OBOClass term;
    protected OBOClass randomTerm;
    protected OBOClass go110Term;
    protected OperationModel operationModel;
    protected TestUtil testUtil;
    protected static Link randomLink;

    public HistoryTest(String s) {
        super(s);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        for (int i = 0; i < 1; ++i) {
            suite.addTest((Test)new HistoryTest("testHistoryTracker"));
        }
        return new TestSuite(HistoryTest.class);
    }

    public HistoryList createHistoryList() {
        DefaultHistoryList out = new DefaultHistoryList();
        OBOClass randomTerm = this.testUtil.getRandomClass();
        OBOClass randomTerm2 = this.testUtil.getRandomClass();
        OBOClass randomTerm3 = this.testUtil.getRandomClass();
        OBOProperty randomProperty = this.testUtil.getRandomProperty();
        randomLink = this.testUtil.getRandomLink();
        Link randomLink2 = this.testUtil.getRandomLink();
        HistoryTest.assertNotNull((Object)randomProperty);
        if (randomTerm.equals(randomTerm2) || randomTerm2.equals(randomTerm3) || randomTerm.equals(randomTerm3)) {
            System.err.println("duplicate random terms!!!");
            System.exit(1);
        }
        out.addItem(new SynonymCategoryHistoryItem(null, new SynonymCategoryImpl("special", "my special category", -1), true, false));
        out.addItem(new TermCategoryHistoryItem(null, new TermCategoryImpl("mysubset", "my subset"), true, false));
        out.addItem(new CategoryChangeHistoryItem("mysubset", false, randomTerm.getID()));
        out.addItem(new AddSynonymHistoryItem(randomTerm.getID(), "Extra special synonym"));
        out.addItem(new ChangeSynCategoryHistoryItem(randomTerm.getID(), "Extra special synonym", null, "special"));
        out.addItem(new ChangeSynScopeHistoryItem(randomTerm.getID(), "Extra special synonym", 0, 3));
        out.addItem(new AddDbxrefHistoryItem(randomTerm.getID(), new DbxrefImpl("monkey", "mash"), false, "Extra special synonym"));
        out.addItem(new CommentChangeHistoryItem(null, "Get a load of this!", randomTerm.getID()));
        out.addItem(new DefinitionChangeHistoryItem(randomTerm.getDefinition(), "Redfined as AWESOME!", randomTerm.getID()));
        out.addItem(new NameChangeHistoryItem(randomTerm, "Moooonsooongyana!"));
        out.addItem(new TermNamespaceHistoryItem(null, "elmo", true, false));
        out.addItem(new NamespaceHistoryItem(randomTerm, new Namespace("elmo")));
        out.addItem(new SecondaryIDHistoryItem(randomTerm, "stupid:otherthing", false));
        out.addItem(new CyclicHistoryItem(randomProperty));
        out.addItem(new SymmetricHistoryItem(randomProperty));
        out.addItem(new TransitiveHistoryItem(this.testUtil.getRandomProperty()));
        out.addItem(new CreateObjectHistoryItem("new:term", OBOClass.OBO_CLASS.getID()));
        out.addItem(new DomainHistoryItem(randomProperty, randomTerm));
        out.addItem(new RangeHistoryItem(randomProperty, randomTerm));
        out.addItem(new CardinalityHistoryItem((OBORestriction)randomLink, new Integer(3)));
        out.addItem(new MaxCardinalityHistoryItem((OBORestriction)randomLink2, new Integer(15)));
        out.addItem(new MinCardinalityHistoryItem((OBORestriction)randomLink2, new Integer(12)));
        out.addItem(new InverseNecHistoryItem((OBORestriction)randomLink));
        out.addItem(new NecessarilyTrueHistoryItem((OBORestriction)randomLink));
        out.addItem(new CompletesHistoryItem((OBORestriction)randomLink));
        out.addItem(new LinkTypeHistoryItem(randomLink, OBOProperty.DISJOINT_FROM));
        out.addItem(new ObsoleteObjectHistoryItem("new:term"));
        out.addItem(new TRNamespaceHistoryItem(this.testUtil.getRandomLink(), new Namespace("elmo")));
        out.addItem(new TermCopyHistoryItem(randomTerm, randomTerm3, OBOProperty.IS_A));
        out.addItem(new TermMoveHistoryItem(this.testUtil.getRandomClass(), this.testUtil.getRandomLink()));
        out.addItem(new TermMergeHistoryItem(this.testUtil.getRandomClass(), this.testUtil.getRandomClass()));
        out.addItem(new TermSplitHistoryItem(this.testUtil.getRandomClass(), "out:split", false));
        return out;
    }

    protected void doHistoryTest(HistoryItem item, HistoryItemCheck check) {
        this.doHistoryTest(item, null, check);
    }

    protected void doHistoryTest(HistoryItem forwardItem, HistoryItem reverseItem, HistoryItemCheck check) {
        this.operationModel.apply(forwardItem);
        check.check(forwardItem, false);
        if (reverseItem != null) {
            this.operationModel.apply(reverseItem);
            check.check(reverseItem, true);
            this.operationModel.reverse(reverseItem);
            check.check(reverseItem, false);
        }
        this.operationModel.reverse(forwardItem);
        check.check(forwardItem, true);
    }

    public void setUp() throws Exception {
        OBOFileAdapter adapter = new OBOFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        config.getReadPaths().add("lib/resources/testfile.1.0.obo");
        this.session = (OBOSession)adapter.doOperation(IOOperation.READ, (AdapterConfiguration)config, null);
        this.testUtil = new TestUtil(this.session);
        this.operationModel = new DefaultOperationModel();
        this.operationModel.setHistory(this.session);
        Set s = this.session.getTerms();
        this.randomTerm = this.testUtil.getRandomClass();
        this.go110Term = (OBOClass)this.session.getObject("GO:0000110");
    }

    public void tearDown() throws Exception {
        this.session = null;
        this.randomTerm = null;
        this.operationModel = null;
        this.go110Term = null;
    }

    protected void checkForSelfLinks(OBOSession session) throws Exception {
        Iterator it = session.getObjects().iterator();
        while (it.hasNext()) {
            IdentifiedObject io = (IdentifiedObject)it.next();
            if (!(io instanceof LinkedObject)) continue;
            LinkedObject lo = (LinkedObject)io;
            Iterator it2 = lo.getParents().iterator();
            while (it2.hasNext()) {
                Link link = (Link)it2.next();
                HistoryTest.assertTrue((String)("Self link " + link + " is not allowed!"), (!link.getParent().equals(link.getChild()) ? 1 : 0) != 0);
            }
        }
    }

    public void testHistoryTracker() throws Exception {
        HistoryList historyList = this.createHistoryList();
        OBOSession changed = TestUtil.createSession();
        HistoryTest.assertNotNull((String)"Test sessions shouldn't be null", (Object)changed);
        TestUtil testUtilC = new TestUtil(changed);
        testUtilC.apply(historyList);
        this.checkForSelfLinks(changed);
        HistoryTest.assertTrue((String)"Plain applied ontology should not contain null categories", (!changed.getCategories().contains(null) ? 1 : 0) != 0);
        this.session = TestUtil.createSession();
        TestUtil testUtilS = new TestUtil(this.session);
        HistoryList generatedList = HistoryGenerator.getHistory(this.session, changed);
        NecessarilyTrueHistoryItem nec_item = null;
        Iterator it = generatedList.getHistoryItems();
        while (it.hasNext()) {
            HistoryItem item = (HistoryItem)it.next();
            if (!(item instanceof NecessarilyTrueHistoryItem)) continue;
            nec_item = (NecessarilyTrueHistoryItem)item;
            break;
        }
        HistoryTest.assertTrue((String)"There should be at least one non-necessary history item.", (nec_item != null ? 1 : 0) != 0);
        testUtilS.apply(generatedList);
        this.checkForSelfLinks(this.session);
        Link realRel = TermUtil.findRel(TermUtil.getRealRel(this.session, nec_item.getRel()));
        Link oldRel = TermUtil.getRealRel(changed, nec_item.getRel());
        LinkedObject delChild = (LinkedObject)this.session.getObject(randomLink.getChild().getID());
        HistoryTest.assertTrue((String)("randomLink " + randomLink + " should not exist in session ontology"), (TermUtil.findParentRel(randomLink, delChild) == null ? 1 : 0) != 0);
        HistoryTest.assertTrue((String)("necessarily true status of " + nec_item.getRel() + " should be false because of " + nec_item + ", realRel = " + realRel + ", isNec=" + ((OBORestriction)realRel).isNecessarilyTrue()), (!TermUtil.isNecessary(realRel) ? 1 : 0) != 0);
        HistoryTest.assertTrue((String)("is complete status of " + nec_item.getRel() + " should be true"), (boolean)TermUtil.isIntersection(oldRel));
        HistoryTest.assertTrue((String)"Generated changes ontology should not contain null categories", (!this.session.getCategories().contains(null) ? 1 : 0) != 0);
        HistoryList troubleList = HistoryGenerator.getHistory(this.session, changed);
        HistoryTest.assertTrue((String)("The history generator should find no differences: troubleList = " + troubleList.getHistoryList()), (troubleList.size() == 0 ? 1 : 0) != 0);
        HistoryTest.assertTrue((String)"The sessions should contain the same number of objects after histories are applied", (this.session.getObjects().size() == changed.getObjects().size() ? 1 : 0) != 0);
        it = this.session.getObjects().iterator();
        while (it.hasNext()) {
            IdentifiedObject io = (IdentifiedObject)it.next();
            IdentifiedObject io2 = changed.getObject(io.getID());
            HistoryTest.assertNotNull((String)("Every object in one ontology should have a corresponding object in the other. " + io.getID()), (Object)io2);
            HistoryTest.assertTrue((String)("Corresponding objects must implement the same interfaces. " + io.getID()), (io instanceof LinkedObject == io2 instanceof LinkedObject ? 1 : 0) != 0);
            HistoryTest.assertTrue((String)("Corresponding objects must have the same names: " + io.getID()), (boolean)io.getName().equals(io2.getName()));
            if (!(io instanceof LinkedObject)) continue;
            LinkedObject lo = (LinkedObject)io;
            LinkedObject lo2 = (LinkedObject)io2;
            HistoryTest.assertTrue((String)("Corresponding objects should have the same number of parents: " + lo.getID()), (lo.getParents().size() == lo2.getParents().size() ? 1 : 0) != 0);
        }
    }

    protected static interface HistoryItemCheck {
        public void check(HistoryItem var1, boolean var2);
    }
}

