/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.plugin;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.geneontology.oboedit.dataadapter.OBOConstants;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Synonym;
import org.geneontology.oboedit.datamodel.SynonymCategory;
import org.geneontology.oboedit.datamodel.SynonymedObject;
import org.geneontology.oboedit.datamodel.history.SynonymCategoryHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.datamodel.impl.SynonymCategoryImpl;
import org.geneontology.oboedit.gui.ComponentPlugin;
import org.geneontology.oboedit.gui.event.RefreshEvent;
import org.geneontology.oboedit.gui.event.RefreshListener;
import org.geneontology.oboedit.gui.event.RootChangeEvent;
import org.geneontology.oboedit.gui.event.RootChangeListener;
import org.geneontology.swing.GenericEditorComponent;
import org.geneontology.swing.ListEditor;

public class SynonymCategoryManagerPlugin
extends ComponentPlugin {
    private static final long serialVersionUID = 1L;
    protected ListEditor catList;
    protected JLabel noCategoryLabel = new JLabel("Click a category to edit it.");
    protected JButton commitButton = new JButton("Save Changes");
    protected JButton revertButton = new JButton("Revert");
    protected String[] scopes = new String[]{"<unspecified scope>", "Synonym", "Exact Synonym", "Narrow Synonym", "Broad Synonym"};
    protected ActionListener scopeListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            SynonymCategoryManagerPlugin.this.catList.commit();
        }
    };
    protected RefreshListener reloadListener = new RefreshListener(){

        public void reload(RefreshEvent e) {
            SynonymCategoryManagerPlugin.this.loadCategories();
        }
    };
    protected RootChangeListener rootListener = new RootChangeListener(){

        public void changeRoot(RootChangeEvent e) {
            SynonymCategoryManagerPlugin.this.loadCategories();
        }
    };

    public SynonymCategoryManagerPlugin() {
        this.commitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SynonymCategoryManagerPlugin.this.saveCategories();
            }
        });
        this.revertButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SynonymCategoryManagerPlugin.this.loadCategories();
            }
        });
    }

    public String getName() {
        return "Synonym Category Manager Plugin";
    }

    public void init() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.setPreferredSize(new Dimension(400, 300));
        this.catList = new ListEditor((GenericEditorComponent)new CategoryEditor(), (Component)this.noCategoryLabel, new Vector(), true, true, true, true, false);
        Box commitBox = new Box(0);
        commitBox.add(Box.createHorizontalGlue());
        commitBox.add(this.commitButton);
        commitBox.add(Box.createHorizontalStrut(10));
        commitBox.add(this.revertButton);
        commitBox.add(Box.createHorizontalGlue());
        this.commitButton.setFont(this.controller.getDefaultFont());
        this.revertButton.setFont(this.controller.getDefaultFont());
        this.noCategoryLabel.setFont(this.controller.getDefaultFont());
        this.removeAll();
        this.add((Component)this.catList);
        this.add(commitBox);
        this.validate();
        this.catList.setFont(this.controller.getDefaultFont());
        this.controller.addListener(this.reloadListener);
        this.controller.addListener(this.rootListener);
        this.loadCategories();
    }

    public void cleanup() {
        this.controller.removeListener(this.reloadListener);
        this.controller.removeListener(this.rootListener);
    }

    protected void loadCategories() {
        Vector<CategoryWrapper> v = new Vector<CategoryWrapper>();
        Iterator it = this.controller.getSession().getSynonymCategories().iterator();
        while (it.hasNext()) {
            SynonymCategory cat = (SynonymCategory)it.next();
            v.add(new CategoryWrapper(cat));
        }
        this.catList.setData(v);
    }

    protected void saveCategories() {
        int i;
        HashSet<SynonymCategory> v = new HashSet<SynonymCategory>();
        this.catList.commit();
        Vector data = this.catList.getData();
        HashSet<String> names = new HashSet<String>();
        for (int i2 = 0; i2 < data.size(); ++i2) {
            CategoryWrapper rtw = (CategoryWrapper)data.get(i2);
            if (names.contains(rtw.getID())) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Could not commit changes because multiple categories are using the id " + rtw.getName());
                return;
            }
            if (!OBOConstants.isOBOIdentifierToken(rtw.getID())) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Illegal characters in synonym category id \"" + rtw.getID() + "\".\nSynonym category ids may only " + "contain letters,\ndigits, underscores, and dashes.");
                return;
            }
            v.add(rtw.getCategory());
            names.add(rtw.getID());
        }
        Vector oldcats = new Vector(this.controller.getSession().getSynonymCategories());
        TermMacroHistoryItem item = new TermMacroHistoryItem("Category edits");
        Vector newcats = (Vector)data.clone();
        for (i = 0; i < oldcats.size(); ++i) {
            SynonymCategory cat = (SynonymCategory)oldcats.get(i);
            boolean found = false;
            for (int j = 0; j < data.size(); ++j) {
                CategoryWrapper tw = (CategoryWrapper)data.get(j);
                if (tw.getCategory() != cat) continue;
                System.err.println(tw.getCategory() + " == " + cat);
                newcats.remove(tw);
                if (tw.isChanged()) {
                    SynonymCategoryHistoryItem catitem = new SynonymCategoryHistoryItem(tw.getCategory(), new SynonymCategoryImpl(tw.getID(), tw.getName(), tw.getScope()), false, false);
                    item.addHistoryItem(catitem);
                }
                found = true;
                break;
            }
            if (found) continue;
            Iterator it = this.controller.getSession().getObjects().iterator();
            while (it.hasNext()) {
                IdentifiedObject io = (IdentifiedObject)it.next();
                if (!(io instanceof SynonymedObject)) continue;
                SynonymedObject term = (SynonymedObject)io;
                Iterator it2 = term.getSynonyms().iterator();
                while (it2.hasNext()) {
                    Synonym s = (Synonym)it2.next();
                    if (s.getSynonymCategory() == null || !s.getSynonymCategory().equals(cat)) continue;
                    JOptionPane.showMessageDialog((Component)((Object)this), "Could not commit changes because " + cat + " " + "is still in use in the " + "ontology");
                    return;
                }
            }
            SynonymCategoryHistoryItem catitem = new SynonymCategoryHistoryItem(cat, null, false, true);
            item.addHistoryItem(catitem);
        }
        for (i = 0; i < newcats.size(); ++i) {
            CategoryWrapper cw = (CategoryWrapper)newcats.get(i);
            SynonymCategoryHistoryItem catitem = new SynonymCategoryHistoryItem(null, this.controller.getSession().getObjectFactory().createSynonymCategory(cw.getID(), cw.getName(), cw.getScope()), true, false);
            item.addHistoryItem(catitem);
        }
        item.setPreSelection(this.controller.getSelectedPaths());
        item.setPostSelection(this.controller.getSelectedPaths());
        this.controller.apply(item);
    }

    protected static class CategoryWrapper {
        protected String id;
        protected String name;
        protected int scope;
        protected SynonymCategory oldcat;

        public CategoryWrapper(SynonymCategory cat) {
            this.id = cat.getID();
            this.name = cat.getName();
            this.scope = cat.getScope();
            this.oldcat = cat;
        }

        public boolean isChanged() {
            return !this.oldcat.getID().equals(this.id) || !this.oldcat.getName().equals(this.name) || this.oldcat.getScope() != this.scope;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setID(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public String getID() {
            return this.id;
        }

        public int getScope() {
            return this.scope;
        }

        public void setScope(int scope) {
            this.scope = scope;
        }

        public SynonymCategory getCategory() {
            return this.oldcat;
        }

        public String toString() {
            return this.name + " (" + this.id + ")";
        }
    }

    private class CategoryEditor
    extends JPanel
    implements GenericEditorComponent {
        private static final long serialVersionUID = 1L;
        protected JTextField idField;
        protected JTextField nameField;
        protected JComboBox scopeDrop;
        protected ListEditor editor;

        public void setMasterComponent(Component c) {
            if (c instanceof ListEditor) {
                this.editor = (ListEditor)c;
            }
        }

        public CategoryEditor() {
            JLabel idLabel = new JLabel("Category id");
            JLabel nameLabel = new JLabel("Category name");
            JLabel scopeLabel = new JLabel("Category scope");
            FocusListener listener = new FocusListener(){

                public void focusLost(FocusEvent e) {
                    ((CategoryEditor)CategoryEditor.this).SynonymCategoryManagerPlugin.this.catList.commit();
                }

                public void focusGained(FocusEvent e) {
                }
            };
            this.idField = new JTextField(10);
            this.nameField = new JTextField();
            this.scopeDrop = new JComboBox<String>(SynonymCategoryManagerPlugin.this.scopes);
            KeyAdapter keyListener = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    ((CategoryEditor)CategoryEditor.this).SynonymCategoryManagerPlugin.this.catList.commit();
                }

                public void keyReleased(KeyEvent e) {
                    ((CategoryEditor)CategoryEditor.this).SynonymCategoryManagerPlugin.this.catList.commit();
                }
            };
            this.idField.addFocusListener(listener);
            this.nameField.addFocusListener(listener);
            scopeLabel.addFocusListener(listener);
            scopeLabel.setFont(SynonymCategoryManagerPlugin.this.controller.getDefaultFont());
            this.scopeDrop.setFont(SynonymCategoryManagerPlugin.this.controller.getDefaultFont());
            this.idField.setFont(SynonymCategoryManagerPlugin.this.controller.getDefaultFont());
            idLabel.setFont(SynonymCategoryManagerPlugin.this.controller.getDefaultFont());
            nameLabel.setFont(SynonymCategoryManagerPlugin.this.controller.getDefaultFont());
            this.nameField.setFont(SynonymCategoryManagerPlugin.this.controller.getDefaultFont());
            this.setLayout(new BoxLayout(this, 1));
            this.add(idLabel);
            this.add(this.idField);
            this.add(Box.createVerticalStrut(10));
            this.add(nameLabel);
            this.add(this.nameField);
            this.add(Box.createVerticalStrut(10));
            this.add(scopeLabel);
            this.add(this.scopeDrop);
            this.add(Box.createVerticalGlue());
        }

        public void load(Object o) {
            CategoryWrapper rtw = (CategoryWrapper)o;
            this.idField.setText(rtw.getID());
            this.nameField.setText(rtw.getName());
            this.scopeDrop.setSelectedIndex(rtw.getScope() + 1);
        }

        public void store(Object o) {
            CategoryWrapper rtw = (CategoryWrapper)o;
            rtw.setID(this.idField.getText());
            rtw.setName(this.nameField.getText());
            rtw.setScope(this.scopeDrop.getSelectedIndex() - 1);
        }

        public Object createNewValue() {
            return new CategoryWrapper(new SynonymCategoryImpl("NEWSYNCAT", "<new synonym category>"));
        }
    }
}

