/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.geneontology.oboedit.gui.ComponentPlugin;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.FilterBuilder;
import org.geneontology.oboedit.gui.FilterPairEditor;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.gui.event.RefreshEvent;
import org.geneontology.oboedit.gui.filters.Filter;
import org.geneontology.oboedit.gui.filters.FilterPair;
import org.geneontology.oboedit.gui.filters.FilterPairImpl;
import org.geneontology.oboedit.gui.filters.LinkFilterFactory;
import org.geneontology.oboedit.gui.filters.ObjectFilterFactory;
import org.geneontology.swing.GenericEditorComponent;
import org.geneontology.swing.ListEditor;

public class GlobalFilterPlugin
extends ComponentPlugin {
    private static final long serialVersionUID = 1L;
    protected ListEditor linkFilterList;
    protected ListEditor termFilterList;
    protected ListEditor linkSpecFilterList;
    protected ListEditor termSpecFilterList;
    protected JPanel filterPanel = new JPanel();
    protected JPanel rendererPanel = new JPanel();
    protected JTabbedPane tabbedPane = new JTabbedPane();
    protected JLabel noObjectLabel = new JLabel("Click a filter to edit it.");
    protected JButton commitButton = new JButton("Save Changes");

    public String getName() {
        return "Global Filter Plugin";
    }

    public void init() {
        this.setPreferredSize(new Dimension(400, 300));
        this.setLayout(new BorderLayout());
        this.filterPanel.removeAll();
        this.filterPanel.setLayout(new GridLayout(2, 1));
        this.rendererPanel.removeAll();
        this.rendererPanel.setLayout(new GridLayout(2, 1));
        this.linkFilterList = new ListEditor((GenericEditorComponent)new FilterEditor(true), (Component)this.noObjectLabel, new Vector(), true, true, true, true, false);
        this.termFilterList = new ListEditor((GenericEditorComponent)new FilterEditor(false), (Component)this.noObjectLabel, new Vector(), true, true, true, true, false);
        this.linkSpecFilterList = new ListEditor((GenericEditorComponent)new RenderEditor(true), (Component)this.noObjectLabel, new Vector(), true, true, true, true, false);
        this.termSpecFilterList = new ListEditor((GenericEditorComponent)new RenderEditor(false), (Component)this.noObjectLabel, new Vector(), true, true, true, true, false);
        Box commitBox = new Box(0);
        commitBox.add(Box.createHorizontalGlue());
        commitBox.add(this.commitButton);
        commitBox.add(Box.createHorizontalGlue());
        this.commitButton.setFont(this.controller.getDefaultFont());
        this.noObjectLabel.setFont(this.controller.getDefaultFont());
        this.commitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GlobalFilterPlugin.this.saveFilters();
            }
        });
        this.linkFilterList.setFont(this.controller.getDefaultFont());
        this.removeAll();
        TitledBorder linkFilterBorder = new TitledBorder("Link filters");
        linkFilterBorder.setTitleFont(Controller.getController().getDefaultFont());
        this.linkFilterList.setBorder((Border)linkFilterBorder);
        this.filterPanel.add((Component)this.linkFilterList);
        Vector v = new Vector();
        v.addAll(this.controller.getGlobalLinkFilter().getFilters());
        this.linkFilterList.setData(v);
        TitledBorder termFilterBorder = new TitledBorder("Term filters");
        termFilterBorder.setTitleFont(Controller.getController().getDefaultFont());
        this.termFilterList.setBorder((Border)termFilterBorder);
        this.filterPanel.add((Component)this.termFilterList);
        v = new Vector();
        v.addAll(this.controller.getGlobalTermFilter().getFilters());
        this.termFilterList.setData(v);
        v = new Vector();
        v.addAll(this.controller.getGlobalTermRenderers());
        this.termSpecFilterList.setData(v);
        v = new Vector();
        v.addAll(this.controller.getGlobalLinkRenderers());
        this.linkSpecFilterList.setData(v);
        TitledBorder termSpecBorder = new TitledBorder("Term renderers");
        termSpecBorder.setTitleFont(Controller.getController().getDefaultFont());
        this.termSpecFilterList.setBorder((Border)termSpecBorder);
        JPanel termSpecFilterButtonPanel = new JPanel();
        termSpecFilterButtonPanel.setOpaque(false);
        termSpecFilterButtonPanel.setLayout(new BoxLayout(termSpecFilterButtonPanel, 1));
        JPanel termSpecFilterPanel = new JPanel();
        termSpecFilterPanel.setBackground(Controller.getController().getPreferences().getBackgroundColor());
        termSpecFilterPanel.setLayout(new BorderLayout());
        termSpecFilterPanel.add((Component)this.termSpecFilterList, "Center");
        termSpecFilterPanel.add((Component)termSpecFilterButtonPanel, "East");
        this.rendererPanel.add(termSpecFilterPanel);
        TitledBorder linkSpecBorder = new TitledBorder("Link renderers");
        linkSpecBorder.setTitleFont(Controller.getController().getDefaultFont());
        this.linkSpecFilterList.setBorder((Border)linkSpecBorder);
        this.rendererPanel.add((Component)this.linkSpecFilterList);
        this.tabbedPane.add((Component)this.filterPanel, "Filters");
        this.tabbedPane.add((Component)this.rendererPanel, "Renderers");
        this.add(this.tabbedPane, "Center");
        this.add(commitBox, "South");
        this.validate();
    }

    protected void saveFilters() {
        this.termFilterList.commit();
        this.linkFilterList.commit();
        this.linkSpecFilterList.commit();
        this.termSpecFilterList.commit();
        Controller.getController().getGlobalTermFilter().clear();
        Vector terms = this.termFilterList.getData();
        for (int i = 0; i < terms.size(); ++i) {
            Controller.getController().getGlobalTermFilter().addFilter((Filter)terms.get(i));
        }
        Controller.getController().getGlobalLinkFilter().clear();
        Vector links = this.linkFilterList.getData();
        for (int i = 0; i < links.size(); ++i) {
            Controller.getController().getGlobalLinkFilter().addFilter((Filter)links.get(i));
        }
        Controller.getController().getGlobalTermRenderers().clear();
        Iterator it = this.termSpecFilterList.getData().iterator();
        while (it.hasNext()) {
            FilterPair pair = (FilterPair)it.next();
            Controller.getController().getGlobalTermRenderers().add(pair);
        }
        Controller.getController().getGlobalLinkRenderers().clear();
        it = this.linkSpecFilterList.getData().iterator();
        while (it.hasNext()) {
            FilterPair pair = (FilterPair)it.next();
            Controller.getController().getGlobalLinkRenderers().add(pair);
        }
        Controller.getController().fireReload(new RefreshEvent(this));
    }

    private class RenderEditor
    extends JPanel
    implements GenericEditorComponent {
        private static final long serialVersionUID = 1L;
        protected FilterPairEditor builder;
        protected ListEditor editor;
        protected JButton loadButton = new JButton(Preferences.loadLibraryIcon("folder.gif"));
        protected JButton newButton = new JButton(Preferences.loadLibraryIcon("file.gif"));
        protected JButton saveButton = new JButton(Preferences.loadLibraryIcon("floppy.gif"));

        public void setMasterComponent(Component c) {
            if (c instanceof ListEditor) {
                this.editor = (ListEditor)c;
            }
        }

        public RenderEditor(final boolean linkFilter) {
            this.setLayout(new BorderLayout());
            this.builder = new FilterPairEditor();
            this.builder.setButtonColor(Preferences.defaultButtonColor());
            this.builder.setFont(Controller.getController().getDefaultFont());
            this.builder.setLinkFilterVisible(linkFilter);
            this.builder.setTermFilterVisible(!linkFilter);
            this.builder.setKeywordMode(false);
            this.builder.setSpecEditorVisible(true);
            this.builder.setShowAdvancedTab(false);
            this.builder.setShowCompoundFilter(true);
            this.newButton.setToolTipText("Create new filter");
            this.loadButton.setToolTipText("Load a filter from disk");
            this.saveButton.setToolTipText("Save a filter to disk");
            this.newButton.setBackground(Controller.getController().getPreferences().getButtonColor());
            this.loadButton.setBackground(Controller.getController().getPreferences().getButtonColor());
            this.saveButton.setBackground(Controller.getController().getPreferences().getButtonColor());
            this.newButton.setPreferredSize(new Dimension(20, 20));
            this.loadButton.setPreferredSize(new Dimension(20, 20));
            this.saveButton.setPreferredSize(new Dimension(20, 20));
            this.loadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FilterPair filterPair = FilterPairEditor.loadFilterPair();
                    if (linkFilter) {
                        filterPair.setObjectFilter(null);
                        filterPair.setObjectRenderSpec(null);
                    } else {
                        filterPair.setLinkFilter(null);
                        filterPair.setLinkRenderSpec(null);
                    }
                    RenderEditor.this.builder.setFilterPair(filterPair);
                }
            });
            this.newButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RenderEditor.this.builder.newFilter();
                }
            });
            this.saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FilterPair filterPair = RenderEditor.this.builder.getFilterPair();
                    if (linkFilter) {
                        filterPair.setObjectFilter(null);
                        filterPair.setObjectRenderSpec(null);
                    } else {
                        filterPair.setLinkFilter(null);
                        filterPair.setLinkRenderSpec(null);
                    }
                    FilterPairEditor.save(filterPair);
                }
            });
            JPanel buttonPanel = new JPanel();
            buttonPanel.setOpaque(false);
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
            buttonPanel.add(Box.createVerticalGlue());
            buttonPanel.add(this.newButton);
            buttonPanel.add(this.loadButton);
            buttonPanel.add(this.saveButton);
            this.add((Component)this.builder, "Center");
            this.add((Component)buttonPanel, "East");
        }

        public void load(Object o) {
            if (o instanceof FilterPair) {
                this.builder.setFilterPair((FilterPair)o);
            }
        }

        public void store(Object o) {
            if (o instanceof FilterPair) {
                this.builder.acceptEdits();
            }
        }

        public Object createNewValue() {
            this.builder.newFilter();
            return this.builder.getFilterPair();
        }
    }

    private class FilterEditor
    extends JPanel
    implements GenericEditorComponent {
        private static final long serialVersionUID = 1L;
        protected FilterBuilder builder = new FilterBuilder();
        protected ListEditor editor;
        protected JButton loadButton = new JButton(Preferences.loadLibraryIcon("folder.gif"));
        protected JButton newButton = new JButton(Preferences.loadLibraryIcon("file.gif"));
        protected JButton saveButton = new JButton(Preferences.loadLibraryIcon("floppy.gif"));

        public void setMasterComponent(Component c) {
            if (c instanceof ListEditor) {
                this.editor = (ListEditor)c;
            }
        }

        public FilterEditor(final boolean linkFilter) {
            this.setLayout(new BorderLayout());
            if (linkFilter) {
                this.builder.setFilterFactory(new LinkFilterFactory());
            } else {
                this.builder.setFilterFactory(new ObjectFilterFactory());
            }
            this.builder.setButtonColor(Preferences.defaultButtonColor());
            this.builder.setFont(Controller.getController().getDefaultFont());
            this.builder.setShowCompoundFilter(true);
            this.newButton.setToolTipText("Create new filter");
            this.loadButton.setToolTipText("Load a filter from disk");
            this.saveButton.setToolTipText("Save a filter to disk");
            this.newButton.setBackground(Controller.getController().getPreferences().getButtonColor());
            this.loadButton.setBackground(Controller.getController().getPreferences().getButtonColor());
            this.saveButton.setBackground(Controller.getController().getPreferences().getButtonColor());
            this.newButton.setPreferredSize(new Dimension(20, 20));
            this.loadButton.setPreferredSize(new Dimension(20, 20));
            this.saveButton.setPreferredSize(new Dimension(20, 20));
            this.loadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FilterPair filterPair = FilterPairEditor.loadFilterPair();
                    if (linkFilter) {
                        FilterEditor.this.builder.setFilter(filterPair.getLinkFilter());
                    } else {
                        FilterEditor.this.builder.setFilter(filterPair.getObjectFilter());
                    }
                }
            });
            this.newButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FilterEditor.this.builder.createNewFilter();
                }
            });
            this.saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FilterPairImpl filterPair = new FilterPairImpl();
                    Filter filter = FilterEditor.this.builder.getFilter();
                    if (linkFilter) {
                        filterPair.setLinkFilter(filter);
                        filterPair.setLinkRenderSpec(null);
                    } else {
                        filterPair.setObjectFilter(filter);
                        filterPair.setObjectRenderSpec(null);
                    }
                    FilterPairEditor.save(filterPair);
                }
            });
            JPanel buttonPanel = new JPanel();
            buttonPanel.setOpaque(false);
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
            buttonPanel.add(Box.createVerticalGlue());
            buttonPanel.add(this.newButton);
            buttonPanel.add(this.loadButton);
            buttonPanel.add(this.saveButton);
            this.add((Component)this.builder, "Center");
            this.add((Component)buttonPanel, "East");
        }

        public void load(Object o) {
            if (o instanceof Filter) {
                this.builder.setFilter((Filter)o);
            }
        }

        public void store(Object o) {
            if (o instanceof Filter) {
                this.builder.acceptEdits();
            }
        }

        public Object createNewValue() {
            this.builder.createNewFilter();
            return this.builder.getFilter();
        }
    }
}

