/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.plugin;

import java.awt.Component;
import java.awt.Container;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.TermCategory;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.gui.ComponentPlugin;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.gui.event.RefreshEvent;
import org.geneontology.oboedit.gui.event.RefreshListener;
import org.geneontology.oboedit.gui.event.RootChangeEvent;
import org.geneontology.oboedit.gui.event.RootChangeListener;

public class ExtendedInfoPlugin
extends ComponentPlugin {
    private static final long serialVersionUID = 1L;
    private ReloadItListener reloadlistener;
    private RerootItListener rerootlistener;
    protected static final int MAX_PARENTAGE = 100;
    protected HashMap scratch = new HashMap();

    public void init() {
        this.setBackground(Preferences.defaultBackgroundColor());
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.setFont(this.controller.getDefaultFont());
        this.attachListeners();
        this.update();
    }

    public String getName() {
        return "Extended Info Plugin";
    }

    public void update() {
        OBOClass term;
        this.removeAll();
        this.scratch.clear();
        JLabel totalTermsLabel = new JLabel("Total terms = 00000000");
        int totalTermCount = 0;
        int definedTermCount = 0;
        totalTermsLabel.setFont(this.getFont());
        Vector<JLabel> labels = new Vector<JLabel>();
        labels.add(totalTermsLabel);
        Hashtable<TermCategory, Integer> catHash = new Hashtable<TermCategory, Integer>();
        Iterator it = this.controller.getSession().getCategories().iterator();
        while (it.hasNext()) {
            TermCategory ct = (TermCategory)it.next();
            catHash.put(ct, new Integer(0));
        }
        int[] parentCounts = new int[100];
        Iterator iter = this.controller.getSession().getTerms().iterator();
        while (iter.hasNext()) {
            term = (OBOClass)iter.next();
            if (term.isBuiltIn() || term.isObsolete()) continue;
            int count = 0;
            ++totalTermCount;
            if (term.getDefinition() != null && term.getDefinition().length() > 0) {
                ++definedTermCount;
            }
            it = term.getCategories().iterator();
            while (it.hasNext()) {
                TermCategory tc = (TermCategory)it.next();
                Integer integerCount = (Integer)catHash.get(tc);
                int intCount = integerCount;
                catHash.put(tc, new Integer(++intCount));
            }
            int parentIndex = term.getParents().size();
            if (parentIndex >= 100) {
                parentIndex = 99;
            }
            int n = parentIndex;
            parentCounts[n] = parentCounts[n] + 1;
            ++count;
        }
        it = this.controller.getSession().getRoots().iterator();
        while (it.hasNext()) {
            term = (OBOClass)it.next();
            if (term.isBuiltIn()) continue;
            Set s = TermUtil.getDescendants(term);
            JLabel label = new JLabel("   " + term + " (" + term.getID() + ") has " + s.size() + " descendants");
            label.setFont(this.getFont());
            labels.add(label);
        }
        totalTermsLabel.setText("Total terms = " + totalTermCount);
        if (totalTermCount > 0) {
            int currentPercentage;
            int i;
            int acc = 0;
            for (i = 99; i >= 0 && (currentPercentage = (acc + parentCounts[i]) * 100 / totalTermCount) < 1; --i) {
                acc += parentCounts[i];
            }
            for (int j = 0; j < i + 1; ++j) {
                int percent = 100 * parentCounts[j] / totalTermCount;
                String percentStr = percent == 0 && parentCounts[j] > 0 ? " < 1" : percent + "";
                String str = "   terms with " + j + " parent" + (j == 1 ? "" : "s") + ": " + parentCounts[j] + " (" + percentStr + "%)";
                JLabel label = new JLabel(str);
                label.setFont(this.getFont());
                labels.add(label);
            }
            if (acc > 0) {
                String str = "   terms with > " + i + " parents: " + acc + " ( < 1%)";
                JLabel label = new JLabel(str);
                label.setFont(this.getFont());
                labels.add(label);
            }
        }
        Enumeration e = catHash.keys();
        while (e.hasMoreElements()) {
            TermCategory tc = (TermCategory)e.nextElement();
            Integer tcCount = (Integer)catHash.get(tc);
            JLabel catLabel = new JLabel("Category " + tc.getDesc() + " has " + tcCount + " members");
            catLabel.setFont(this.getFont());
            labels.add(catLabel);
        }
        int defPercent = (int)(100.0 * ((double)definedTermCount / (double)totalTermCount));
        JLabel defCountLabel = new JLabel(defPercent + "% of terms have definitions (" + definedTermCount + " of " + totalTermCount + ")");
        defCountLabel.setFont(this.getFont());
        labels.add(defCountLabel);
        int memPercent = (int)(100.0 * ((double)Runtime.getRuntime().freeMemory() / (double)Runtime.getRuntime().totalMemory()));
        JLabel memoryLabel = new JLabel(memPercent + "% of memory free");
        memoryLabel.setFont(this.getFont());
        labels.add(memoryLabel);
        for (int i = 0; i < labels.size(); ++i) {
            this.add((JLabel)labels.get(i));
        }
        this.revalidate();
        JDialog dialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, (Component)((Object)this));
        if (dialog != null) {
            dialog.pack();
        }
    }

    private void attachListeners() {
        this.reloadlistener = new ReloadItListener();
        this.rerootlistener = new RerootItListener();
        this.controller.addListener(this.reloadlistener);
        this.controller.addListener(this.rerootlistener);
    }

    public void cleanup() {
        this.controller.removeListener(this.reloadlistener);
        this.controller.removeListener(this.rerootlistener);
    }

    private class RerootItListener
    implements RootChangeListener {
        private RerootItListener() {
        }

        public void changeRoot(RootChangeEvent e) {
            ExtendedInfoPlugin.this.update();
        }
    }

    private class ReloadItListener
    implements RefreshListener {
        private ReloadItListener() {
        }

        public void reload(RefreshEvent e) {
            ExtendedInfoPlugin.this.update();
        }
    }
}

