/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.plugin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.gui.ComponentConfiguration;
import org.geneontology.oboedit.gui.ComponentPlugin;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.DbxrefListEditor;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.gui.event.TextEditorUpdateEvent;
import org.geneontology.swing.DragList;
import org.geneontology.swing.DropTarget;
import org.geneontology.swing.GenericEditorComponent;
import org.geneontology.swing.ListEditor;
import org.geneontology.swing.event.DragEvent;
import org.geneontology.swing.event.DropListener;

public class DbxrefPlugin
extends ComponentPlugin {
    private static final long serialVersionUID = 1L;
    ListEditor editor;
    JList refList;
    JButton useButton;
    JButton useAsDefButton;
    JButton saveButton;
    JButton configureButton;
    JButton importButton;
    JButton exportButton;
    Vector dbxrefs = new Vector();
    JDialog dialog;
    protected DropTarget dropTarget;

    public static String getVersion() {
        return "1.000";
    }

    public String getName() {
        return "Dbxref Library v" + DbxrefPlugin.getVersion();
    }

    public DbxrefPlugin() {
        this.setLayout(new BorderLayout());
        this.useButton = new JButton("Use dbxref");
        this.useAsDefButton = new JButton("Use as def dbxref");
        this.importButton = new JButton("Import dbxrefs");
        this.exportButton = new JButton("Export dbxrefs");
        this.saveButton = new JButton("Save configuration");
        this.configureButton = new JButton("Configure dbxrefs");
        this.refList = new DragList(Controller.getController().getDragController());
    }

    public void setConfiguration(ComponentConfiguration config) {
        if (config instanceof DbxrefLibrary) {
            this.dbxrefs = ((DbxrefLibrary)config).getLibrary();
            this.updateList();
        }
    }

    public ComponentConfiguration getConfiguration() {
        return new DbxrefLibrary(this.dbxrefs);
    }

    protected Vector getDbxrefList() {
        return this.dbxrefs;
    }

    protected void configure() {
        JLabel noSelection = new JLabel("Nothing selected");
        JPanel panel = new JPanel();
        panel.setBackground(Preferences.defaultBackgroundColor());
        panel.add(noSelection);
        DbxrefListEditor component = new DbxrefListEditor(this.controller);
        panel.setPreferredSize(new Dimension(250, 200));
        component.setPreferredSize(new Dimension(250, 200));
        this.editor = new ListEditor((GenericEditorComponent)component, (Component)panel, this.getDbxrefList(), true, true, true, true, false);
        this.editor.setFont(this.controller.getDefaultFont());
        this.editor.setBackground(Preferences.defaultBackgroundColor());
        this.editor.setPreferredSize(new Dimension(350, 200));
        this.dialog = new JDialog();
        JPanel dialogPanel = new JPanel();
        dialogPanel.setBackground(Preferences.defaultBackgroundColor());
        dialogPanel.setLayout(new BorderLayout());
        dialogPanel.add((Component)this.editor, "Center");
        dialogPanel.add((Component)this.saveButton, "South");
        this.dialog.setContentPane(dialogPanel);
        this.dialog.setSize(350, 230);
        this.dialog.show();
        Collections.sort(this.dbxrefs);
        this.refList.setListData(this.dbxrefs);
    }

    protected void sendUpdates(boolean isDef) {
        TextEditorUpdateEvent event = new TextEditorUpdateEvent(this);
        Vector<TextEditorUpdateEvent.DbxrefUpdate> updates = new Vector<TextEditorUpdateEvent.DbxrefUpdate>();
        Object[] selection = this.refList.getSelectedValues();
        for (int i = 0; i < selection.length; ++i) {
            Dbxref ref = (Dbxref)((Dbxref)selection[i]).clone();
            if (isDef) {
                ref.setType(2);
            } else {
                ref.setType(3);
            }
            TextEditorUpdateEvent.DbxrefUpdate update = new TextEditorUpdateEvent.DbxrefUpdate(ref, null, true, false);
            updates.add(update);
        }
        event.setDbxrefUpdates(updates);
        this.controller.fireTextEditorUpdate(event);
    }

    protected void saveConfiguration() {
        this.dbxrefs = this.editor.getData();
        if (this.dbxrefs == null) {
            this.dbxrefs = new Vector();
        }
        Collections.sort(this.dbxrefs);
        this.refList.setListData(this.dbxrefs);
        this.refList.repaint();
        Controller.getController().flushComponentConfig();
    }

    protected void attachListeners() {
        this.useButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DbxrefPlugin.this.sendUpdates(false);
            }
        });
        this.useAsDefButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DbxrefPlugin.this.sendUpdates(true);
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DbxrefPlugin.this.saveConfiguration();
                DbxrefPlugin.this.dialog.dispose();
            }
        });
        this.configureButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DbxrefPlugin.this.configure();
            }
        });
        this.exportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DbxrefPlugin.this.exportFile();
            }
        });
        this.importButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DbxrefPlugin.this.importFile();
            }
        });
    }

    protected void updateList() {
        this.refList.setListData(this.getDbxrefList());
        this.refList.repaint();
    }

    protected void exportFile() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFont(this.controller.getDefaultFont());
        if (chooser.showSaveDialog(Controller.getController().getFrame()) == 0) {
            File file = chooser.getSelectedFile();
            try {
                PrintWriter writer = new PrintWriter(new FileWriter(file));
                for (int i = 0; i < this.dbxrefs.size(); ++i) {
                    Dbxref ref = (Dbxref)this.dbxrefs.get(i);
                    String line = ref.getDatabase() + ":" + ref.getID();
                    if (ref.getDesc() != null) {
                        line = line + " " + ref.getDesc();
                    }
                    writer.println(line);
                }
                writer.close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(Controller.getController().getFrame(), "Could not write file " + file);
            }
        }
    }

    protected void importFile() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFont(this.controller.getDefaultFont());
        if (chooser.showOpenDialog(Controller.getController().getFrame()) == 0) {
            this.dbxrefs.clear();
            File file = chooser.getSelectedFile();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(file));
                while ((line = reader.readLine()) != null) {
                    if (line.length() == 0) continue;
                    int colonIndex = line.indexOf(58);
                    int spaceIndex = line.indexOf(32);
                    int dbxrefEndIndex = spaceIndex;
                    if (dbxrefEndIndex == -1) {
                        dbxrefEndIndex = line.length();
                    }
                    String db = line.substring(0, colonIndex);
                    String id = line.substring(colonIndex + 1, dbxrefEndIndex);
                    String desc = null;
                    if (spaceIndex != -1) {
                        desc = line.substring(spaceIndex + 1, line.length());
                    }
                    Dbxref dbxref = this.controller.getSession().getObjectFactory().createDbxref(db, id, desc, 3, null);
                    this.dbxrefs.add(dbxref);
                }
                Collections.sort(this.dbxrefs);
                this.refList.setListData(this.dbxrefs);
                this.refList.repaint();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Could not read file " + file);
            }
        }
    }

    public void init() {
        this.removeAll();
        this.setBackground(Preferences.defaultBackgroundColor());
        this.refList.setFont(this.controller.getDefaultFont());
        this.useButton.setFont(this.controller.getDefaultFont());
        this.useAsDefButton.setFont(this.controller.getDefaultFont());
        this.saveButton.setFont(this.controller.getDefaultFont());
        this.configureButton.setFont(this.controller.getDefaultFont());
        this.importButton.setFont(this.controller.getDefaultFont());
        this.exportButton.setFont(this.controller.getDefaultFont());
        JScrollPane scroller = new JScrollPane(this.refList, 20, 30);
        this.attachListeners();
        this.updateList();
        JPanel ioPanel = new JPanel();
        ioPanel.setLayout(new GridLayout(1, 2));
        ioPanel.add(this.importButton);
        ioPanel.add(this.exportButton);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(3, 1));
        JPanel usePanel = new JPanel();
        usePanel.setLayout(new GridLayout(1, 2));
        usePanel.add(this.useButton);
        usePanel.add(this.useAsDefButton);
        buttonPanel.add(usePanel);
        buttonPanel.add(ioPanel);
        buttonPanel.add(this.configureButton);
        this.useButton.setBackground(Preferences.defaultButtonColor());
        this.useAsDefButton.setBackground(Preferences.defaultButtonColor());
        this.saveButton.setBackground(Preferences.defaultButtonColor());
        this.configureButton.setBackground(Preferences.defaultButtonColor());
        this.importButton.setBackground(Preferences.defaultButtonColor());
        this.exportButton.setBackground(Preferences.defaultButtonColor());
        this.dropTarget = new DropTarget((Component)this.refList, (DropListener)new DropDbxrefsListener());
        this.controller.getDragController().registerDropTarget(this.dropTarget);
        this.add(scroller, "Center");
        this.add(buttonPanel, "South");
    }

    public void cleanup() {
        this.controller.getDragController().unregisterDropTarget(this.dropTarget);
    }

    public static class DbxrefLibrary
    implements ComponentConfiguration {
        protected Vector library;

        public DbxrefLibrary() {
            this.library = new Vector();
        }

        public DbxrefLibrary(Vector library) {
            this.setLibrary(library);
        }

        public void setLibrary(Vector library) {
            this.library = library;
        }

        public Vector getLibrary() {
            return this.library;
        }
    }

    protected class DropDbxrefsListener
    implements DropListener {
        protected DropDbxrefsListener() {
        }

        public boolean allowDrop(DragEvent e) {
            if (e.getData() instanceof Vector) {
                Vector v = (Vector)e.getData();
                return v.size() > 0 && v.get(0) instanceof Dbxref;
            }
            if (e.getData() instanceof Object[]) {
                Object[] v = (Object[])e.getData();
                return v.length > 0 && v[0] instanceof Dbxref;
            }
            return false;
        }

        public void dragEnter(DragEvent e) {
            DbxrefPlugin.this.refList.setBorder(new LineBorder(Color.black));
        }

        public void dragExit(DragEvent e) {
            DbxrefPlugin.this.refList.setBorder(null);
        }

        public void drop(DragEvent e) {
            DbxrefPlugin.this.refList.setBorder(null);
            if (e.getData() instanceof Vector) {
                Vector newRefs = (Vector)e.getData();
                for (int i = 0; i < newRefs.size(); ++i) {
                    Dbxref ref = (Dbxref)newRefs.get(i);
                    if (DbxrefPlugin.this.dbxrefs.contains(ref)) continue;
                    DbxrefPlugin.this.dbxrefs.add(ref);
                }
            } else if (e.getData() instanceof Object[]) {
                Object[] os = (Object[])e.getData();
                for (int i = 0; i < os.length; ++i) {
                    Dbxref ref = (Dbxref)os[i];
                    if (DbxrefPlugin.this.dbxrefs.contains(ref)) continue;
                    DbxrefPlugin.this.dbxrefs.add(ref);
                }
            }
            DbxrefPlugin.this.updateList();
        }

        public void draggedOver(DragEvent e) {
        }
    }
}

