/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.plugin;

import java.awt.Container;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.gui.ComponentPlugin;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.gui.event.SelectionEvent;
import org.geneontology.oboedit.gui.event.SelectionListener;

public class CrossProductInfoPlugin
extends ComponentPlugin {
    private static final long serialVersionUID = -7919246476674947971L;
    protected JEditorPane crossProductPane = new JEditorPane("text/html", "<html></html>");
    protected JEditorPane referencePane = new JEditorPane("text/html", "<html></html>");
    protected HyperlinkListener linkListener = new HyperlinkListener(){

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                CrossProductInfoPlugin.this.selectTerm(e.getURL(), CrossProductInfoPlugin.this.controller.getSession());
            }
        }
    };
    protected SelectionListener termSelectListener = new SelectionListener(){

        public void select(SelectionEvent e) {
            CrossProductInfoPlugin.this.update();
        }
    };

    public void selectTerm(URL url, OBOSession history) {
        String id = url.getPath();
        OBOClass t = history.getTerm(id);
        LinkedList<OBOClass> terms = new LinkedList<OBOClass>();
        terms.add(t);
        this.controller.select(terms);
    }

    public CrossProductInfoPlugin() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.setBackground(Preferences.defaultBackgroundColor());
        TitledBorder rborder = new TitledBorder("Referenced by");
        rborder.setTitleFont(Controller.getController().getDefaultFont());
        this.referencePane.setBorder(rborder);
        this.referencePane.setEditable(false);
        this.referencePane.setOpaque(false);
        TitledBorder cborder = new TitledBorder("Cross product defs");
        cborder.setTitleFont(Controller.getController().getDefaultFont());
        this.crossProductPane.setBorder(cborder);
        this.crossProductPane.setEditable(false);
        this.crossProductPane.setOpaque(false);
        this.referencePane.addHyperlinkListener(this.linkListener);
        this.crossProductPane.addHyperlinkListener(this.linkListener);
    }

    public void init() {
        this.controller.addListener(this.termSelectListener);
        this.update();
        this.referencePane.setFont(Controller.getController().getDefaultFont());
    }

    protected void update() {
        StringBuffer out;
        String fontname;
        boolean showReferencePanel;
        IdentifiedObject io;
        boolean showCrossProductPanel;
        this.removeAll();
        IdentifiedObject ss = this.controller.getSubSelection();
        if (!(ss instanceof LinkedObject)) {
            return;
        }
        LinkedObject obj = (LinkedObject)ss;
        Set genus = TermUtil.mallocSet();
        Set diff = TermUtil.mallocSet();
        Set pdiff = TermUtil.mallocSet();
        LinkedObject genusTerm = null;
        Iterator it = obj.getParents().iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            if (!TermUtil.isIntersection(link)) continue;
            if (link.getType().equals(OBOProperty.IS_A)) {
                genusTerm = link.getParent();
                continue;
            }
            pdiff.add(link);
        }
        boolean bl = showCrossProductPanel = genusTerm != null || pdiff.size() > 0;
        if (showCrossProductPanel) {
            int fontsize = Controller.getController().getDefaultFont().getSize();
            String fontname2 = Controller.getController().getDefaultFont().getFamily();
            StringBuffer out2 = new StringBuffer();
            out2.append("<html>\n");
            out2.append("<head>\n");
            out2.append("<style type='text/css'>\n");
            out2.append("  * { font-size: " + fontsize + "pt; " + "font-family: " + fontname2 + "; margin-top: 0; " + "padding-top: 0; }\n");
            out2.append("  body { font-size: " + fontsize + "pt; " + "font-family: " + fontname2 + "; }\n");
            out2.append("</style>\n");
            out2.append("</head>\n");
            out2.append("<body>\n");
            if (genusTerm != null) {
                out2.append("<b>Genus</b> <a href='file:" + genusTerm.getID() + "'>" + genusTerm + " (" + genusTerm.getID() + ")</a><br><br>");
            } else {
                out2.append("<b>No genus term defined!</b><br>");
                out2.append("<i>It is legal to define a cross product with no genus (is_a) intersection defined in OBO-Edit, but it is not recommended, and your ontology willbe incompatible with some tools.</i>");
            }
            if (pdiff.size() > 0) {
                out2.append("<b>Discriminating Properties</b>\n");
                it = pdiff.iterator();
                out2.append("<ul>");
                while (it.hasNext()) {
                    Link link = (Link)it.next();
                    io = link.getParent();
                    out2.append("<li><i><a href='file:" + link.getType().getID() + "'>" + link.getType().getID() + "</a></i><br><a href='file:" + io.getID() + "'>" + io + " (" + io.getID() + ")</a>");
                }
                out2.append("</ul>");
            }
            out2.append("</body></html>");
            this.crossProductPane.setText(out2.toString());
            this.add(this.crossProductPane);
        }
        it = obj.getChildren().iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            if (!TermUtil.isIntersection(link)) continue;
            if (link.getType().equals(OBOProperty.IS_A)) {
                genus.add(link.getChild());
                continue;
            }
            diff.add(link);
        }
        boolean bl2 = showReferencePanel = genus.size() > 0 || diff.size() > 0;
        if (showReferencePanel) {
            int fontsize = Controller.getController().getDefaultFont().getSize();
            fontname = Controller.getController().getDefaultFont().getFamily();
            out = new StringBuffer();
            out.append("<html>\n");
            out.append("<head>\n");
            out.append("<style type='text/css'>\n");
            out.append("  * { font-size: " + fontsize + "pt; " + "font-family: " + fontname + "; margin-top: 0;" + "padding-top: 0; }\n");
            out.append("  body { font-size: " + fontsize + "pt; " + "font-family: " + fontname + "; }\n");
            out.append("</style>\n");
            out.append("</head>\n");
            out.append("<body>\n");
            if (genus.size() > 0) {
                out.append("<b>Genus of</b>\n");
                it = genus.iterator();
                out.append("<ul>");
                while (it.hasNext()) {
                    io = (IdentifiedObject)it.next();
                    out.append("<li><a href='file:" + io.getID() + "'>" + io + " (" + io.getID() + ")</a>");
                }
                out.append("</ul>");
            }
            if (diff.size() > 0) {
                out.append("<b>Differentiates</b>\n");
                it = diff.iterator();
                out.append("<ul>");
                while (it.hasNext()) {
                    Link link = (Link)it.next();
                    LinkedObject io2 = link.getChild();
                    out.append("<li><a href='file:" + io2.getID() + "'>" + io2 + " (" + io2.getID() + ")</a> by <a href='file:" + link.getType().getID() + "'>" + link.getType().getID() + "</a>");
                }
                out.append("</ul>");
            }
            out.append("</body></html>");
            this.referencePane.setText(out.toString());
            this.add(this.referencePane);
        }
        if (!showCrossProductPanel && !showReferencePanel) {
            int fontsize = Controller.getController().getDefaultFont().getSize();
            fontname = Controller.getController().getDefaultFont().getFamily();
            out = new StringBuffer();
            out.append("<html>\n");
            out.append("<head>\n");
            out.append("<style type='text/css'>\n");
            out.append("  * { font-size: " + fontsize + "pt; " + "font-family: " + fontname + "; margin-top: 0;" + "padding-top: 0; }\n");
            out.append("  body { font-size: " + fontsize + "pt; " + "font-family: " + fontname + "; }\n");
            out.append("</style>\n");
            out.append("</head>\n");
            out.append("<body>\n");
            out.append("<b>No cross product definitions or references</b>");
            out.append("</body></html>");
            JLabel noDataLabel = new JLabel(out.toString());
            this.add(noDataLabel);
        }
        TermUtil.freeSet(genus);
        TermUtil.freeSet(diff);
        TermUtil.freeSet(pdiff);
        this.validate();
        this.repaint();
    }

    public void cleanup() {
        this.controller.removeListener(this.termSelectListener);
    }

    public String getName() {
        return "Cross Product Info Plugin";
    }
}

