/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.launcher;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.geneontology.dataadapter.AdapterConfiguration;
import org.geneontology.dataadapter.IOOperation;
import org.geneontology.oboedit.dataadapter.GOFlatFileAdapter;
import org.geneontology.oboedit.dataadapter.OBOFileAdapter;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.history.DeleteLinkHistoryItem;
import org.geneontology.oboedit.datamodel.history.ObsoleteObjectHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.datamodel.impl.DefaultOperationModel;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.util.ProgressEvent;
import org.geneontology.util.ProgressListener;

public class Flat2OBO {
    protected static String ROOT_ID = "GO:0003673";
    protected static String FUNCTION_ID = "GO:0003674";
    protected static String COMPONENT_ID = "GO:0005575";
    protected static String PROCESS_ID = "GO:0008150";
    protected static String FUNCTION_OBS_ID = "GO:0008369";
    protected static String COMPONENT_OBS_ID = "GO:0008370";
    protected static String PROCESS_OBS_ID = "GO:0008371";
    protected static double oldValue;
    protected static boolean starting;

    private Flat2OBO() {
    }

    public static void main(String[] args) throws Exception {
        Controller.setSuppressInstallations(true);
        ConvertRecord record = Flat2OBO.getRecord(args);
        Flat2OBO.convert(record.flatfiles, record.obsHolders, record.newroots, record.dels, record.defFile, record.outFile, record.defaultNamespace, record.verbose, record.allowDangling, record.translateTypes, record.allowCycles);
    }

    private static ConvertRecord getRecord(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage: flat2obo [options] flatfile1 flatfile2 -out outputfile");
            System.err.println();
            System.err.println("IO Switches:");
            System.err.println("  -def\tPath to the definition file");
            System.err.println("  -out, -o\tPath to the ouput file");
            System.err.println();
            System.err.println("Graph rearrangement:");
            System.err.println("  -del\tThe id of a term to be deleted");
            System.err.println("  -root\tThe id of a term to be made into a root");
            System.err.println("  -ns\tRenames the namespace of the last node given by the -root switch");
            System.err.println("  -obs\tThe id of a holder node for obsolete terms");
            System.err.println("  -defaultns\tSets the default namespace");
            System.err.println();
            System.err.println("Adapter options:");
            System.err.println("  -dangling\tAllows dangling relationships in the input file");
            System.err.println("  -notranslate\tDoes not translate type names ");
            System.err.println("  -cycles\tAllows cycles in the input file");
            System.err.println();
            System.err.println("Presets:");
            System.err.println("  --gopresets\tSets all options to suit the Gene Ontology flat files");
            System.err.println();
            System.err.println("Other switches:");
            System.err.println("  -v, -verbose\tVerbose mode");
            System.exit(1);
        }
        ConvertRecord record = new ConvertRecord();
        String lastroot = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-def")) {
                record.defFile = args[++i];
                continue;
            }
            if (args[i].equals("-del")) {
                record.dels.add(args[++i]);
                continue;
            }
            if (args[i].equals("-obs")) {
                record.obsHolders.add(args[++i]);
                continue;
            }
            if (args[i].equals("-root")) {
                lastroot = args[++i];
                record.newroots.put(lastroot, null);
                continue;
            }
            if (args[i].equals("-defaultns")) {
                record.defaultNamespace = args[++i];
                continue;
            }
            if (args[i].equals("-dangling")) {
                record.allowDangling = true;
                continue;
            }
            if (args[i].equals("-notranslate")) {
                record.translateTypes = false;
                continue;
            }
            if (args[i].equals("-cycles")) {
                record.allowCycles = true;
                continue;
            }
            if (args[i].equals("-ns")) {
                String ns = args[++i];
                if (lastroot == null) {
                    System.err.println("Assigned namespace " + ns + "without specifying root");
                    System.exit(1);
                }
                record.newroots.put(lastroot, ns);
                continue;
            }
            if (args[i].equals("--gopresets")) {
                record.obsHolders.add(FUNCTION_OBS_ID);
                record.obsHolders.add(COMPONENT_OBS_ID);
                record.obsHolders.add(PROCESS_OBS_ID);
                record.newroots.put(FUNCTION_ID, "molecular_function");
                record.newroots.put(COMPONENT_ID, "cellular_component");
                record.newroots.put(PROCESS_ID, "biological_process");
                record.dels.add(ROOT_ID);
                record.defaultNamespace = "gene_ontology";
                continue;
            }
            if (args[i].equals("-o") || args[i].equals("-out")) {
                String outfile = args[++i];
                if (record.outFile == null) {
                    record.outFile = outfile;
                    continue;
                }
                System.err.println("Tried to specify multiple output files");
                System.exit(1);
                continue;
            }
            if (args[i].equals("-v") || args[i].equals("-verbose")) {
                record.verbose = true;
                continue;
            }
            record.flatfiles.add(args[i]);
        }
        return record;
    }

    public static void convert(Vector flatfiles, Vector obsHolders, HashMap newroots, Vector dels, String defFile, String outfile, String defaultNamespace, boolean verbose, boolean allowDangling, boolean translateTypes, boolean allowCycles) throws Exception {
        if (verbose) {
            System.err.print("Setting up flat file adapter...");
            System.err.flush();
        }
        GOFlatFileAdapter indriver = new GOFlatFileAdapter();
        GOFlatFileAdapter.GOFlatFileConfiguration config = new GOFlatFileAdapter.GOFlatFileConfiguration();
        config.setHideDownstream(true);
        config.setAllowCycles(allowCycles);
        config.setAllowDangling(allowDangling);
        config.setTranslateTypes(translateTypes);
        config.setDefFilename(defFile);
        config.setReadPaths(flatfiles);
        oldValue = 0.0;
        starting = true;
        ProgressListener plistener = new ProgressListener(){
            int reportInc = 10;

            public void progressMade(ProgressEvent e) {
                Double d = e.getValue();
                if (d != null) {
                    if (starting) {
                        System.err.print(e.getDescription() + " 0%");
                        System.err.flush();
                        starting = false;
                    } else {
                        if (d.intValue() % this.reportInc == 0) {
                            System.err.print(d.intValue() + "%");
                        } else if (d.intValue() % 2 == 0) {
                            System.err.print(".");
                        }
                        System.err.flush();
                    }
                    if (d < oldValue) {
                        System.err.println("done");
                        starting = true;
                    }
                    oldValue = d;
                }
            }
        };
        if (verbose) {
            indriver.addProgressListener(plistener);
        }
        if (verbose) {
            System.err.println("done");
        }
        OBOSession history = (OBOSession)indriver.doOperation(IOOperation.READ, (AdapterConfiguration)config, null);
        if (verbose) {
            System.err.println("done");
        }
        if (verbose) {
            System.err.print("Applying transformations...");
            System.err.flush();
        }
        DefaultOperationModel opmodel = new DefaultOperationModel();
        opmodel.setHistory(history);
        opmodel.apply(Flat2OBO.getChangeItem(history, newroots, obsHolders, dels));
        if (defaultNamespace != null) {
            history.setDefaultNamespace(new Namespace(defaultNamespace));
        }
        Iterator it = newroots.keySet().iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            OBOClass t = history.getTerm(id);
            String ns_name = (String)newroots.get(id);
            if (t.getNamespace() == null) {
                Namespace ns = new Namespace(ns_name);
                if (!history.getNamespaces().contains(ns)) {
                    history.addNamespace(ns);
                }
                t.setNamespace(ns);
                continue;
            }
            t.getNamespace().setID(ns_name);
        }
        history.getCurrentHistory().setComment("");
        if (verbose) {
            System.err.println("done");
        }
        oldValue = 0.0;
        starting = true;
        OBOFileAdapter outdriver = new OBOFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration outconfig = new OBOFileAdapter.OBOAdapterConfiguration();
        System.err.println("outfile = " + outfile);
        outconfig.setAllowDangling(allowDangling);
        outconfig.setWritePath(outfile);
        outdriver.doOperation(IOOperation.WRITE, (AdapterConfiguration)outconfig, history);
    }

    public static TermMacroHistoryItem getChangeItem(OBOSession history, HashMap newroots, Vector obsHolders, Vector dels) {
        OBOClass t;
        String id;
        int i;
        TermMacroHistoryItem item = new TermMacroHistoryItem("Flat File conversion");
        Iterator it = newroots.keySet().iterator();
        while (it.hasNext()) {
            String id2 = (String)it.next();
            OBOClass t2 = history.getTerm(id2);
            Flat2OBO.addDeleteMacro(item, t2.getParents());
        }
        for (i = 0; i < obsHolders.size(); ++i) {
            id = (String)obsHolders.get(i);
            t = history.getTerm(id);
            Flat2OBO.addDeleteMacro(item, t.getChildren());
            Flat2OBO.addDeleteMacro(item, t.getParents());
            item.addHistoryItem(new ObsoleteObjectHistoryItem(t));
        }
        for (i = 0; i < dels.size(); ++i) {
            id = (String)dels.get(i);
            t = history.getTerm(id);
            if (t.getChildren().size() > 0) {
                Flat2OBO.addDeleteMacro(item, t.getChildren());
                item.addHistoryItem(new ObsoleteObjectHistoryItem(t));
            }
            if (t.getParents().size() > 0) {
                Flat2OBO.addDeleteMacro(item, t.getParents());
                item.addHistoryItem(new ObsoleteObjectHistoryItem(t));
                continue;
            }
            item.addHistoryItem(new DeleteLinkHistoryItem(history.getObjectFactory().createOBORestriction(t, null, null, false, null)));
        }
        return item;
    }

    protected static void addDeleteMacro(TermMacroHistoryItem item, Set parents) {
        Iterator it = parents.iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            item.addHistoryItem(new DeleteLinkHistoryItem(link));
        }
    }

    static {
        starting = true;
    }

    private static class ConvertRecord {
        Vector flatfiles = new Vector();
        Vector obsHolders = new Vector();
        Vector dels = new Vector();
        HashMap newroots = new HashMap();
        String defFile;
        String outFile;
        String defaultNamespace;
        boolean verbose = false;
        boolean allowDangling = false;
        boolean translateTypes = true;
        boolean allowCycles = false;

        private ConvertRecord() {
        }
    }
}

