/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui.filters;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JTextField;
import org.geneontology.oboedit.gui.filters.AbstractFilterEditor;
import org.geneontology.oboedit.gui.filters.AllTextFieldsCriterion;
import org.geneontology.oboedit.gui.filters.CompoundEditable;
import org.geneontology.oboedit.gui.filters.CompoundFilter;
import org.geneontology.oboedit.gui.filters.CompoundFilterImpl;
import org.geneontology.oboedit.gui.filters.ContainsComparison;
import org.geneontology.oboedit.gui.filters.Filter;
import org.geneontology.oboedit.gui.filters.FilterFactory;
import org.geneontology.oboedit.gui.filters.KeywordSearchCriterion;
import org.geneontology.oboedit.gui.filters.LinkFilter;
import org.geneontology.oboedit.gui.filters.ObjectFilter;
import org.geneontology.oboedit.gui.filters.ObjectFilterImpl;

public class KeywordFilterBuilder
extends AbstractFilterEditor
implements CompoundEditable {
    private static final long serialVersionUID = 1L;
    protected JTextField textField = new JTextField();
    protected Filter filter;

    public KeywordFilterBuilder() {
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalGlue());
        this.add(this.textField);
        this.add(Box.createVerticalGlue());
    }

    public void setShowCompoundFilter(boolean showCompoundFilter) {
    }

    public void setFilterFactory(FilterFactory filterFactory) {
    }

    public void addActionListener(ActionListener listener) {
        this.textField.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.textField.addActionListener(listener);
    }

    public Filter getFilter() {
        return this.filter;
    }

    protected void populateList(Collection c, Filter filter) {
        if (filter instanceof CompoundFilter) {
            this.populateList(c, (CompoundFilter)filter);
        } else if (filter instanceof LinkFilter) {
            this.populateList(c, (LinkFilter)filter);
        } else if (filter instanceof ObjectFilter) {
            this.populateList(c, (ObjectFilter)filter);
        } else {
            System.err.println("what do I do with " + filter.getClass());
        }
    }

    protected void populateList(Collection c, CompoundFilter filter) {
        Iterator it = filter.getFilters().iterator();
        while (it.hasNext()) {
            Filter f = (Filter)it.next();
            this.populateList(c, f);
        }
    }

    protected void populateList(Collection c, LinkFilter filter) {
        this.populateList(c, filter.getFilter());
    }

    protected void populateList(Collection c, ObjectFilter filter) {
        c.add(filter.getValue());
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
        if (filter == null) {
            this.textField.setText("");
            return;
        }
        LinkedList vals = new LinkedList();
        this.populateList(vals, filter);
        StringBuffer out = new StringBuffer();
        boolean first = true;
        Iterator it = vals.iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            if (first) {
                out.append(s);
            } else {
                out.append(" ");
                out.append(s);
            }
            first = false;
        }
        this.textField.setText(out.toString());
    }

    protected Collection unescapeValues(String string) {
        LinkedList out = new LinkedList();
        KeywordSearchCriterion.extractKeywords(out, string);
        return out;
    }

    public void acceptEdits() {
        CompoundFilterImpl cf = new CompoundFilterImpl();
        cf.setBooleanOperation(0);
        Collection c = this.unescapeValues(this.textField.getText());
        if (c.size() > 0) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                ObjectFilterImpl f = new ObjectFilterImpl();
                f.setCriterion(new KeywordSearchCriterion());
                f.setComparison(new ContainsComparison());
                f.setValue(s);
                cf.addFilter(f);
            }
        } else {
            ObjectFilterImpl f = new ObjectFilterImpl();
            f.setCriterion(new AllTextFieldsCriterion());
            f.setComparison(new ContainsComparison());
            f.setValue("");
            cf.addFilter(f);
        }
        this.filter = cf;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.textField != null) {
            this.textField.setFont(font);
            this.textField.setMaximumSize(new Dimension(Integer.MAX_VALUE, font.getSize() + 20));
        }
    }

    public void setButtonColor(Color buttonColor) {
    }
}

