/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui.actions;

import java.util.List;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.ObsoletableObject;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.RemoveConsiderHistoryItem;
import org.geneontology.oboedit.gui.ClickMenuAction;
import org.geneontology.oboedit.gui.Controller;

public class RemoveConsiderAction
implements ClickMenuAction {
    protected TreePath[] sources;
    protected boolean isLegal = false;
    protected Controller controller;
    protected ObsoletableObject clearObject;
    protected ObsoletableObject considerObject;

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public KeyStroke getKeyStroke() {
        return null;
    }

    public String getName() {
        return "Remove consider term";
    }

    public String getDesc() {
        return this.getName();
    }

    public List getSubActions() {
        return null;
    }

    public void clickInit(TreePath[] sources, TreePath destItem) {
        this.isLegal = true;
        this.sources = sources;
        if (sources.length != 1) {
            this.isLegal = false;
            return;
        }
        Link link = (Link)sources[0].getLastPathComponent();
        if (!TermUtil.isObsolete(link.getParent()) || !link.getType().equals(OBOProperty.CONSIDER)) {
            this.isLegal = false;
            return;
        }
        this.clearObject = (ObsoletableObject)((Object)link.getParent());
        this.considerObject = (ObsoletableObject)((Object)link.getChild());
    }

    public boolean isLegal() {
        return this.isLegal;
    }

    public HistoryItem execute() {
        RemoveConsiderHistoryItem item = new RemoveConsiderHistoryItem(this.clearObject, this.considerObject);
        TreePath[] outPaths = new TreePath[]{TermUtil.convertPathToIDs(this.sources[0].getParentPath())};
        item.setPreSelection(outPaths);
        item.setPostSelection(outPaths);
        return item;
    }
}

