/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui.actions;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.DeleteLinkHistoryItem;
import org.geneontology.oboedit.datamodel.history.DestroyObjectHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.gui.ClickMenuAction;
import org.geneontology.oboedit.gui.Controller;

public class DestroyAction
implements ClickMenuAction {
    protected TreePath[] sources;
    protected List deleteThese = new Vector();
    protected TreePath destItem;
    protected boolean isLegal = false;
    protected Controller controller;
    protected static KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 2);

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public KeyStroke getKeyStroke() {
        return keyStroke;
    }

    public String getName() {
        return "Destroy";
    }

    public String getDesc() {
        return "Destroy";
    }

    public List getSubActions() {
        return null;
    }

    public void clickInit(TreePath[] sources, TreePath destItem) {
        this.isLegal = sources.length > 0;
        this.sources = sources;
        this.deleteThese.clear();
        for (int i = 0; i < sources.length; ++i) {
            LinkedObject term;
            if (!(sources[i].getLastPathComponent() instanceof Link)) {
                this.isLegal = false;
                return;
            }
            Link tr = (Link)sources[i].getLastPathComponent();
            this.deleteThese.add(tr);
            LinkedObject child = tr.getChild();
            if (child.getParents().size() > 1) {
                this.isLegal = false;
                return;
            }
            if (child.getChildren().size() > 0 && !TermUtil.hasAncestor(child, child)) {
                this.isLegal = false;
                return;
            }
            if (child.isBuiltIn()) {
                this.isLegal = false;
                return;
            }
            if (!TermUtil.isProperty(child)) continue;
            Iterator it = this.controller.getSession().getTerms().iterator();
            while (it.hasNext()) {
                term = (LinkedObject)it.next();
                if (!TermUtil.usesType(term, (OBOProperty)child)) continue;
                this.isLegal = false;
                return;
            }
            it = this.controller.getSession().getRelationshipTypes().iterator();
            while (it.hasNext()) {
                term = (LinkedObject)it.next();
                if (!TermUtil.usesType(term, (OBOProperty)child)) continue;
                this.isLegal = false;
                return;
            }
        }
        this.sources = sources;
        this.destItem = null;
    }

    public boolean isLegal() {
        return this.isLegal;
    }

    public HistoryItem execute() {
        HistoryItem item;
        if (JOptionPane.showConfirmDialog(Controller.getController().getFrame(), "The terms will be permanently destroyed.\nThey will be entirely removed from the ontology\nand will not appear as obsolete terms.\nAre you sure you want to proceed?", "Destroy warning", 0) != 0) {
            return null;
        }
        Vector<HistoryItem> itemList = new Vector<HistoryItem>();
        Iterator it = this.deleteThese.iterator();
        while (it.hasNext()) {
            Link tr = (Link)it.next();
            Iterator it2 = tr.getChild().getParents().iterator();
            while (it2.hasNext()) {
                Link parent = (Link)it2.next();
                itemList.add(new DeleteLinkHistoryItem(parent));
            }
            DestroyObjectHistoryItem item2 = new DestroyObjectHistoryItem(tr.getChild());
            itemList.add(item2);
        }
        if (itemList.size() == 1) {
            item = (HistoryItem)itemList.get(0);
        } else {
            item = new TermMacroHistoryItem("Destroyed multiple terms");
            it = itemList.iterator();
            while (it.hasNext()) {
                HistoryItem subItem = (HistoryItem)it.next();
                ((TermMacroHistoryItem)item).addHistoryItem(subItem);
            }
        }
        item.setPreSelection(TermUtil.convertPathsToIDs(this.sources));
        item.setPostSelection(new TreePath[0]);
        return item;
    }
}

