/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.NameChangeHistoryItem;
import org.geneontology.oboedit.gui.AbstractTextEditComponent;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.util.ObjectUtil;

public class NameEditorComponent
extends AbstractTextEditComponent {
    private static final long serialVersionUID = 1L;
    protected JTextField textField = new JTextField();

    public Component resolveName(String id, Properties props, String xml) {
        if (id.equals("field")) {
            return this.textField;
        }
        return new JButton(id);
    }

    protected boolean useSubLayout() {
        return true;
    }

    protected String getDefaultLayout() {
        return "<box orientation='HORZ'><label text='Name'/><spacer orientation='horz' size='10'/><component id='field'/></box>";
    }

    protected void loadGUI() {
        if (this.currentObject != null) {
            this.textField.setText(this.currentObject.getName());
            boolean enable = !TermUtil.isObsolete(this.currentObject);
            this.textField.setEnabled(enable);
        } else {
            this.textField.setEnabled(false);
            this.textField.setText("<no selection>");
        }
    }

    protected void initializeGUI() {
        Font font = Controller.getController().getDefaultFont();
        this.textField.setFont(font);
        this.textField.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)this.textField.getPreferredSize().getHeight()));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)this.getPreferredSize().getHeight()));
    }

    protected String getText() {
        return this.textField.getText().trim();
    }

    public String getID() {
        return "NAME_EDITOR";
    }

    public void populateFields(IdentifiedObject io) {
        io.setName(this.textField.getText());
    }

    public List getChanges() {
        if (this.currentObject != null) {
            if (!ObjectUtil.equals((Object)this.textField.getText(), (Object)this.currentObject.getName())) {
                NameChangeHistoryItem item = new NameChangeHistoryItem(this.currentObject, this.textField.getText());
                return Collections.singletonList(item);
            }
            return Collections.EMPTY_LIST;
        }
        return Collections.EMPTY_LIST;
    }
}

