/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.history.DomainHistoryItem;
import org.geneontology.oboedit.gui.AbstractTextEditComponent;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.swing.DropTarget;
import org.geneontology.swing.event.DragEvent;
import org.geneontology.swing.event.DropAdapter;
import org.geneontology.swing.event.DropListener;
import org.geneontology.util.ObjectUtil;

public class DomainEditorComponent
extends AbstractTextEditComponent {
    private static final long serialVersionUID = 1L;
    protected Border lineBorder = new LineBorder(Color.black);
    protected Border oldBorder;
    protected JButton domainButton = new JButton("<no domain>");
    protected IdentifiedObject domain;
    protected DropListener dropDomainListener = new DropAdapter(){

        public boolean allowDrop(DragEvent e) {
            TreePath[] paths = (TreePath[])e.getData();
            if (paths.length == 1) {
                LinkedObject termDomain = ((Link)paths[0].getLastPathComponent()).getChild();
                return !DomainEditorComponent.this.currentObject.equals(termDomain);
            }
            return false;
        }

        public void dragEnter(DragEvent e) {
            DomainEditorComponent.this.oldBorder = DomainEditorComponent.this.domainButton.getBorder();
            DomainEditorComponent.this.domainButton.setBorder(DomainEditorComponent.this.lineBorder);
        }

        public void dragExit(DragEvent e) {
            DomainEditorComponent.this.domainButton.setBorder(DomainEditorComponent.this.oldBorder);
        }

        public void drop(DragEvent e) {
            TreePath[] paths = (TreePath[])e.getData();
            if (paths.length == 1 && ((Link)paths[0].getLastPathComponent()).getChild() instanceof OBOClass) {
                DomainEditorComponent.this.setDomain(((Link)paths[0].getLastPathComponent()).getChild());
            }
            DomainEditorComponent.this.domainButton.setBorder(DomainEditorComponent.this.oldBorder);
        }
    };
    protected DropTarget dropTarget = new DropTarget((Component)this.domainButton, this.dropDomainListener);

    public Component resolveName(String id, Properties props, String xml) {
        if (id.equals("domain_button")) {
            return this.domainButton;
        }
        return new JButton(id);
    }

    protected boolean useSubLayout() {
        return true;
    }

    protected String getDefaultLayout() {
        return "<box orientation='HORZ'><label text='Domain'/><spacer orientation='horz' size='10'/><component id='domain_button'/></box>";
    }

    protected void loadGUI() {
        if (this.currentObject != null && this.currentObject instanceof OBOProperty) {
            this.setDomain(((OBOProperty)this.currentObject).getDomain());
        } else {
            this.setDomain(null);
        }
    }

    public void setDomain(IdentifiedObject domain) {
        this.domain = domain;
        if (domain == null) {
            this.domainButton.setLabel("<no domain specified>");
        } else {
            this.domainButton.setLabel(domain.getName() + " (" + domain.getID() + ")");
        }
        this.domainButton.setMinimumSize(this.domainButton.getPreferredSize());
    }

    protected String getWarningLabel() {
        return "";
    }

    protected void installListeners() {
        Controller.getController().getDragController().registerDropTarget(this.dropTarget);
    }

    protected void uninstallListeners() {
        Controller.getController().getDragController().unregisterDropTarget(this.dropTarget);
    }

    protected void initializeGUI() {
        Font font = Controller.getController().getDefaultFont();
        this.domainButton.setFont(font);
        this.domainButton.setBackground(Controller.getController().getPreferences().getButtonColor());
        this.setMinimumSize(this.getPreferredSize());
    }

    public List getWarnings() {
        return Collections.EMPTY_LIST;
    }

    public String getID() {
        return "DOMAIN_EDITOR";
    }

    public void populateFields(IdentifiedObject io) {
        if (io instanceof OBOProperty) {
            ((OBOProperty)io).setDomain(this.domain);
        }
    }

    public List getChanges() {
        if (this.currentObject != null && this.currentObject instanceof OBOProperty) {
            LinkedList<DomainHistoryItem> out = new LinkedList<DomainHistoryItem>();
            if (!ObjectUtil.equals((Object)this.domain, (Object)((OBOProperty)this.currentObject).getDomain())) {
                out.add(new DomainHistoryItem((OBOProperty)this.currentObject, this.domain));
            }
            return out;
        }
        return Collections.EMPTY_LIST;
    }
}

