/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.gui.ClickMenuAction;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.DropMenuAction;
import org.geneontology.oboedit.gui.EditAction;
import org.geneontology.oboedit.gui.InputHandlerI;
import org.geneontology.oboedit.gui.OBOTermPanel;
import org.geneontology.swing.KeyRecorder;

public class DefaultInputHandler
implements InputHandlerI {
    protected JPopupMenu dragMenu = new JPopupMenu();
    protected Controller controller;

    public void setController(Controller controller) {
        this.dragMenu.setFont(controller.getDefaultFont());
        this.controller = controller;
    }

    public boolean click(OBOTermPanel panel, Controller controller, TreePath dest, MouseEvent e, KeyRecorder.KeyChecker keyChecker) {
        if (Controller.isPopupTrigger(e, keyChecker)) {
            this.dragMenu.removeAll();
            DefaultInputHandler.buildMenu(this.dragMenu, controller.getEditActions(), controller, panel.getSelectionPaths(), dest, controller.useLeadAsClickDestination(), true, false);
            this.dragMenu.addSeparator();
            panel.fillInMenu(this.dragMenu);
            this.dragMenu.show(panel, e.getX(), e.getY());
            return true;
        }
        return false;
    }

    public static void buildMenu(JComponent menu, List editActions, Controller controller, boolean fromDrop) {
        DefaultInputHandler.buildMenu(menu, editActions, controller, null, null, controller.useLeadAsClickDestination(), true, fromDrop);
    }

    public static int buildMenu(JComponent menu, List editActions, Controller controller, TreePath[] selected, TreePath dest, boolean useLeadAsDest, boolean showDisabled, boolean fromDrop) {
        boolean liveSelection;
        boolean bl = liveSelection = selected == null;
        if (selected == null) {
            selected = controller.getSelectedPaths();
        }
        if (useLeadAsDest) {
            int trimmedSize = selected.length - 1;
            if (trimmedSize < 0) {
                trimmedSize = 0;
            }
            TreePath[] trimmedSelected = new TreePath[trimmedSize];
            for (int i = 1; i < selected.length; ++i) {
                trimmedSelected[i - 1] = selected[i];
            }
            dest = selected.length == 0 ? null : selected[0];
            selected = trimmedSelected;
        }
        Iterator it = editActions.iterator();
        int enabledCount = 0;
        while (it.hasNext()) {
            ClickMenuAction editAction = (ClickMenuAction)it.next();
            JMenuItem item = DefaultInputHandler.getMenuItem(selected, dest, editAction, controller, useLeadAsDest, liveSelection, fromDrop);
            if (item.isEnabled()) {
                ++enabledCount;
                menu.add(item);
                continue;
            }
            if (!showDisabled) continue;
            menu.add(item);
        }
        return enabledCount;
    }

    public static JMenuItem getMenuItem(final TreePath[] selection, final TreePath dest, final EditAction editAction, final Controller controller, final boolean useLeadAsDest, final boolean liveSelection, boolean fromDrop) {
        JMenuItem item;
        boolean hasChildren;
        if (editAction instanceof DropMenuAction && editAction instanceof ClickMenuAction) {
            if (fromDrop) {
                ((DropMenuAction)editAction).dropInit(selection, dest);
            } else {
                ((ClickMenuAction)editAction).clickInit(selection, dest);
            }
        } else if (editAction instanceof DropMenuAction) {
            ((DropMenuAction)editAction).dropInit(selection, dest);
        } else if (editAction instanceof ClickMenuAction) {
            ((ClickMenuAction)editAction).clickInit(selection, dest);
        }
        editAction.setController(controller);
        boolean bl = hasChildren = editAction.getSubActions() != null && editAction.getSubActions().size() > 0;
        if (hasChildren) {
            item = new JMenu(editAction.getName());
            if (editAction.isLegal()) {
                boolean foundEnabled = false;
                Iterator it = editAction.getSubActions().iterator();
                while (it.hasNext()) {
                    ClickMenuAction ea = (ClickMenuAction)it.next();
                    JMenuItem subItem = DefaultInputHandler.getMenuItem(selection, dest, ea, controller, useLeadAsDest, liveSelection, fromDrop);
                    if (subItem.isEnabled()) {
                        foundEnabled = true;
                    }
                    item.add(subItem);
                }
                item.setEnabled(foundEnabled);
            } else {
                item.setEnabled(false);
            }
        } else {
            item = new JMenuItem(editAction.getName());
            item.setEnabled(editAction.isLegal());
            if (editAction.isLegal()) {
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        HistoryItem item;
                        TreePath[] selected = liveSelection ? controller.getSelectedPaths() : selection;
                        TreePath tempDest = dest;
                        if (useLeadAsDest) {
                            int trimmedSize = selected.length - 1;
                            if (trimmedSize < 0) {
                                trimmedSize = 0;
                            }
                            TreePath[] trimmedSelected = new TreePath[trimmedSize];
                            for (int i = 1; i < selected.length; ++i) {
                                trimmedSelected[i - 1] = selected[i];
                            }
                            tempDest = selected.length == 0 ? null : selected[0];
                            selected = trimmedSelected;
                        }
                        if (editAction instanceof DropMenuAction) {
                            ((DropMenuAction)editAction).dropInit(selected, tempDest);
                        } else if (editAction instanceof ClickMenuAction) {
                            ((ClickMenuAction)editAction).clickInit(selected, tempDest);
                        }
                        editAction.setController(controller);
                        if (editAction.isLegal() && controller.getTextEditManager().checkUncommittedEdits(true) && (item = editAction.execute()) != null) {
                            controller.apply(item);
                        }
                    }
                });
            }
        }
        item.setFont(controller.getDefaultFont());
        return item;
    }

    public int allowDrop(OBOTermPanel sourcePanel, OBOTermPanel dropPanel, Controller controller, Object o, TreePath dest, MouseEvent e, KeyRecorder.KeyChecker keyChecker) {
        if (o instanceof TreePath[] && sourcePanel != null) {
            sourcePanel.setDragTitle("Dragging Terms");
            return 2;
        }
        return 0;
    }

    public boolean drop(OBOTermPanel sourcePanel, OBOTermPanel dropPanel, Controller controller, Object o, TreePath dest, MouseEvent e, KeyRecorder.KeyChecker keyChecker) {
        Point p = SwingUtilities.convertPoint(sourcePanel, e.getX(), e.getY(), dropPanel);
        this.dragMenu.removeAll();
        Iterator it = controller.getDropMenuActions().iterator();
        int enabledCount = 0;
        DropMenuAction liveAction = null;
        while (it.hasNext()) {
            DropMenuAction editAction = (DropMenuAction)it.next();
            editAction.dropInit((TreePath[])o, dest);
            if (!editAction.isLegal()) continue;
            ++enabledCount;
            liveAction = editAction;
            this.dragMenu.add(DefaultInputHandler.getMenuItem((TreePath[])o, dest, editAction, controller, false, false, true));
        }
        if (enabledCount > 0) {
            this.dragMenu.show(dropPanel, (int)p.getX(), (int)p.getY());
            return true;
        }
        return false;
    }

    public boolean press(OBOTermPanel panel, Controller controller, KeyEvent e, KeyRecorder.KeyChecker keyChecker) {
        return false;
    }
}

