/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkHistoryItem;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBORestriction;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.CompletesHistoryItem;
import org.geneontology.oboedit.datamodel.history.DeleteLinkHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermCopyHistoryItem;
import org.geneontology.oboedit.datamodel.impl.OBORestrictionImpl;
import org.geneontology.oboedit.gui.AbstractTextEditComponent;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.swing.DropTarget;
import org.geneontology.swing.event.DragEvent;
import org.geneontology.swing.event.DropListener;

public class CompleteDefPanel
extends AbstractTextEditComponent {
    private static final long serialVersionUID = 1L;
    protected static Icon deleteIcon = Preferences.loadLibraryIcon("trashcan.gif");
    protected static Icon selectIcon = Preferences.loadLibraryIcon("selector.gif");
    protected OBOClass oboClass;
    protected OBOClass genusTerm;
    protected List relationshipList = new LinkedList();
    protected JPanel editorPanel = new JPanel();
    protected JScrollPane editorScroller = new JScrollPane(this.editorPanel, 20, 31);
    protected JPanel relPanel = new JPanel();
    protected JPanel genusPanel = new JPanel();
    protected JPanel linkListPanel = new JPanel();
    protected JLabel notLoadedLabel = new JLabel("No term selected");
    protected JButton dropButton = new JButton("<drop new terms here>");
    protected JLabel genusLabel = new JLabel("Genus");
    protected JButton genusButton = new JButton("<no genus specified>");
    protected JButton genusSelectButton = new JButton(selectIcon);
    protected DropListener dropDiscriminatingListener = new DropListener(){
        LineBorder border = new LineBorder(Color.black, 2);
        Border oldBorder;

        public boolean allowDrop(DragEvent e) {
            if (e.getData() instanceof TreePath[] && ((TreePath[])e.getData()).length > 0) {
                TreePath[] paths = (TreePath[])e.getData();
                for (int i = 0; i < paths.length; ++i) {
                    if (!(paths[i].getLastPathComponent() instanceof OBORestriction)) {
                        return false;
                    }
                    OBORestriction or = (OBORestriction)paths[i].getLastPathComponent();
                    if (!or.getChild().equals(CompleteDefPanel.this.oboClass)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public void dragEnter(DragEvent e) {
            this.oldBorder = CompleteDefPanel.this.dropButton.getBorder();
            if (this.allowDrop(e)) {
                CompleteDefPanel.this.dropButton.setBorder(this.border);
            }
        }

        public void dragExit(DragEvent e) {
            CompleteDefPanel.this.dropButton.setBorder(this.oldBorder);
        }

        public void drop(DragEvent e) {
            TreePath[] paths = (TreePath[])e.getData();
            if (paths.length == 1) {
                JPopupMenu menu = new JPopupMenu();
                final Link link = (Link)paths[0].getLastPathComponent();
                OBOSession session = Controller.getController().getSession();
                JMenuItem genusItem = new JMenuItem("Set genus term");
                genusItem.setFont(Controller.getController().getDefaultFont());
                genusItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        CompleteDefPanel.this.setGenus((OBOClass)link.getChild());
                    }
                });
                menu.add(genusItem);
                menu.addSeparator();
                Iterator it = session.getRelationshipTypes().iterator();
                while (it.hasNext()) {
                    final OBOProperty prop = (OBOProperty)it.next();
                    if (prop.equals(OBOProperty.IS_A)) continue;
                    JMenuItem item = new JMenuItem("Add discriminating term with type " + prop.getID());
                    item.setFont(Controller.getController().getDefaultFont());
                    item.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            CompleteDefPanel.this.addDiscriminating((OBOClass)link.getChild(), prop);
                        }
                    });
                    menu.add(item);
                }
                Point p = SwingUtilities.convertPoint(e.getDragSource(), e.getX(), e.getY(), CompleteDefPanel.this.dropButton);
                menu.show(CompleteDefPanel.this.dropButton, (int)p.getX(), (int)p.getY());
            }
            CompleteDefPanel.this.dropButton.setBorder(this.oldBorder);
        }

        public void draggedOver(DragEvent e) {
        }
    };
    protected DropListener dropGenusListener = new DropListener(){
        LineBorder border = new LineBorder(Color.black, 2);
        Border oldBorder;

        public boolean allowDrop(DragEvent e) {
            if (e.getData() instanceof TreePath[] && ((TreePath[])e.getData()).length > 0) {
                TreePath[] paths = (TreePath[])e.getData();
                if (paths.length != 1) {
                    return false;
                }
                if (!(paths[0].getLastPathComponent() instanceof OBORestriction)) {
                    return false;
                }
                OBORestriction or = (OBORestriction)paths[0].getLastPathComponent();
                return !or.getChild().equals(CompleteDefPanel.this.oboClass);
            }
            return false;
        }

        public void dragEnter(DragEvent e) {
            this.oldBorder = CompleteDefPanel.this.genusButton.getBorder();
            if (this.allowDrop(e)) {
                CompleteDefPanel.this.genusButton.setBorder(this.border);
            }
        }

        public void dragExit(DragEvent e) {
            CompleteDefPanel.this.genusButton.setBorder(this.oldBorder);
        }

        public void drop(DragEvent e) {
            TreePath[] paths = (TreePath[])e.getData();
            if (paths.length == 1) {
                Link link = (Link)paths[0].getLastPathComponent();
                CompleteDefPanel.this.setGenus((OBOClass)link.getChild());
            }
            CompleteDefPanel.this.genusButton.setBorder(this.oldBorder);
        }

        public void draggedOver(DragEvent e) {
        }
    };
    protected DropTarget dropDiscriminatingTarget = new DropTarget((Component)this.dropButton, this.dropDiscriminatingListener);
    protected DropTarget dropGenusTarget = new DropTarget((Component)this.genusButton, this.dropGenusListener);
    protected ActionListener genusButtonListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            CompleteDefPanel.this.setGenus(null);
        }
    };
    protected ActionListener genusSelectListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (CompleteDefPanel.this.genusTerm != null) {
                Controller.getController().select(CompleteDefPanel.this.genusTerm);
            }
        }
    };

    public Component resolveName(String id, Properties props, String xml) {
        return null;
    }

    public boolean useSubLayout() {
        return false;
    }

    protected void initializeGUI() {
        this.setLayout(new GridLayout(1, 1));
        this.editorPanel.setLayout(new BorderLayout());
        this.editorPanel.setBackground(Preferences.defaultBackgroundColor());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setBackground(Preferences.defaultBackgroundColor());
        this.relPanel.setLayout(new BorderLayout());
        this.genusPanel.setLayout(new BorderLayout());
        this.linkListPanel.setLayout(new BoxLayout(this.linkListPanel, 1));
        this.relPanel.setOpaque(false);
        this.genusPanel.setOpaque(false);
        this.linkListPanel.setOpaque(false);
        TitledBorder titledBorder = new TitledBorder("Discriminating relations");
        titledBorder.setTitleFont(Controller.getController().getDefaultFont());
        CompoundBorder cBorder = new CompoundBorder(new EmptyBorder(20, 0, 5, 0), titledBorder);
        this.linkListPanel.setBorder(cBorder);
        this.genusLabel.setFont(Controller.getController().getDefaultFont());
        this.dropButton.setFont(Controller.getController().getDefaultFont());
        this.dropButton.setBackground(Preferences.defaultButtonColor());
        Font font = Controller.getController().getDefaultFont().deriveFont(1);
        this.genusButton.setMinimumSize(new Dimension(0, font.getSize() + 5));
        this.genusButton.setBackground(Preferences.defaultButtonColor());
        this.genusButton.setFont(font);
        this.genusSelectButton.setBackground(Preferences.defaultButtonColor());
        this.genusSelectButton.setPreferredSize(new Dimension(20, 20));
        this.genusSelectButton.setToolTipText("Select genus term");
        JPanel labelBox = new JPanel();
        labelBox.setOpaque(false);
        labelBox.add(this.genusLabel);
        labelBox.add(Box.createHorizontalStrut(10));
        this.genusPanel.add((Component)labelBox, "West");
        this.genusPanel.add((Component)this.genusButton, "Center");
        this.genusPanel.add((Component)this.genusSelectButton, "East");
        this.genusPanel.setOpaque(false);
        this.relPanel.add((Component)this.genusPanel, "North");
        this.relPanel.add((Component)this.linkListPanel, "Center");
        this.relPanel.setOpaque(false);
        this.editorPanel.add((Component)this.relPanel, "North");
        this.editorPanel.add((Component)this.dropButton, "Center");
    }

    protected void loadGUI() {
        this.removeAll();
        if (this.currentObject != null && this.currentObject instanceof OBOClass) {
            this.add(this.editorScroller);
            this.setClass((OBOClass)this.currentObject);
            boolean enable = !TermUtil.isObsolete(this.currentObject);
            this.genusButton.setEnabled(enable);
            this.dropButton.setEnabled(enable);
        } else {
            this.add(this.notLoadedLabel);
        }
        this.validate();
        this.repaint();
    }

    public Collection getRelationshipList() {
        LinkedList<OBORestrictionImpl> out = new LinkedList<OBORestrictionImpl>();
        if (this.genusTerm != null) {
            OBORestrictionImpl isaLink = new OBORestrictionImpl((LinkedObject)this.oboClass, OBOProperty.IS_A, this.genusTerm);
            isaLink.setCompletes(true);
            out.add(isaLink);
        }
        out.addAll(this.relationshipList);
        return out;
    }

    public boolean hasContents() {
        return this.genusTerm != null || this.relationshipList.size() > 0;
    }

    protected void setGenus(OBOClass genusTerm) {
        this.genusTerm = genusTerm;
        this.buildInterface();
    }

    protected void addDiscriminating(OBOClass discriminatingTerm, OBOProperty prop) {
        OBORestrictionImpl or = new OBORestrictionImpl((LinkedObject)this.oboClass, prop, discriminatingTerm);
        or.setCompletes(true);
        this.relationshipList.add(or);
        this.buildInterface();
    }

    public void installListeners() {
        this.genusButton.addActionListener(this.genusButtonListener);
        this.genusSelectButton.addActionListener(this.genusSelectListener);
        Controller.getController().getDragController().registerDropTarget(this.dropGenusTarget);
        Controller.getController().getDragController().registerDropTarget(this.dropDiscriminatingTarget);
    }

    public void uninstallListeners() {
        this.genusButton.removeActionListener(this.genusButtonListener);
        this.genusSelectButton.removeActionListener(this.genusSelectListener);
        Controller.getController().getDragController().unregisterDropTarget(this.dropGenusTarget);
        Controller.getController().getDragController().unregisterDropTarget(this.dropDiscriminatingTarget);
    }

    public List getChanges() {
        LinkedList<LinkHistoryItem> historyList = new LinkedList<LinkHistoryItem>();
        if (this.currentObject instanceof LinkedObject) {
            Iterator it = ((LinkedObject)this.currentObject).getParents().iterator();
            while (it.hasNext()) {
                Link link = (Link)it.next();
                if (!TermUtil.isIntersection(link)) continue;
                boolean found = false;
                Iterator it2 = this.getRelationshipList().iterator();
                while (it2.hasNext()) {
                    Link completeDefLink = (Link)it2.next();
                    if (completeDefLink.equals(link)) {
                        found = true;
                        break;
                    }
                    System.err.println("   " + completeDefLink + " != " + link);
                }
                if (found) continue;
                historyList.add(new DeleteLinkHistoryItem(link));
            }
            System.err.println("relationshipList = " + this.getRelationshipList());
            it = this.getRelationshipList().iterator();
            while (it.hasNext()) {
                OBORestriction completeDefLink = (OBORestriction)it.next();
                Link matchLink = TermUtil.findParentRel(completeDefLink, (LinkedObject)this.currentObject);
                if (matchLink == null) {
                    completeDefLink.setCompletes(false);
                    historyList.add(new TermCopyHistoryItem(completeDefLink.getParent(), completeDefLink));
                }
                if (matchLink == null || !TermUtil.isIntersection(matchLink)) {
                    completeDefLink.setCompletes(false);
                    historyList.add(new CompletesHistoryItem(completeDefLink));
                }
                completeDefLink.setCompletes(true);
            }
        }
        System.err.println("historyList = " + historyList);
        return historyList;
    }

    public void setClass(OBOClass oboClass) {
        this.oboClass = oboClass;
        this.relationshipList.clear();
        this.genusTerm = null;
        System.err.println("parents of " + oboClass + " = " + oboClass.getParents());
        Iterator it = oboClass.getParents().iterator();
        while (it.hasNext()) {
            OBORestriction link = (OBORestriction)it.next();
            if (!link.completes()) continue;
            if (link.getType().equals(OBOProperty.IS_A)) {
                this.genusTerm = (OBOClass)link.getParent();
                continue;
            }
            this.relationshipList.add(link);
        }
        this.buildInterface();
    }

    public void populateFields(IdentifiedObject currentObject) {
        if (!(currentObject instanceof OBOClass)) {
            return;
        }
        Iterator it = this.getRelationshipList().iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            if (((OBOClass)currentObject).getParents().contains(link)) continue;
            ((OBOClass)currentObject).atomicAddParent(link);
        }
    }

    protected void buildInterface() {
        boolean enabled;
        boolean bl = enabled = !TermUtil.isObsolete(this.currentObject);
        if (this.genusTerm != null) {
            this.genusButton.setText(this.genusTerm.getName());
        } else {
            this.genusButton.setText("<drop a genus term>");
        }
        this.linkListPanel.removeAll();
        if (this.relationshipList.size() == 0) {
            JLabel propertyLabel = new JLabel("<drop a discriminating link below>");
            propertyLabel.setEnabled(enabled);
            propertyLabel.setFont(Controller.getController().getDefaultFont());
            this.linkListPanel.add(propertyLabel);
        }
        Iterator it = this.relationshipList.iterator();
        while (it.hasNext()) {
            final OBORestriction tr = (OBORestriction)it.next();
            JPanel relationshipLinePanel = new JPanel();
            relationshipLinePanel.setOpaque(false);
            relationshipLinePanel.setLayout(new BoxLayout(relationshipLinePanel, 0));
            relationshipLinePanel.add(Box.createHorizontalStrut(20));
            JComboBox<String> typeBox = new JComboBox<String>();
            typeBox.setBackground(Preferences.defaultButtonColor());
            typeBox.setFont(Controller.getController().getDefaultFont());
            Iterator it2 = Controller.getController().getSession().getRelationshipTypes().iterator();
            while (it2.hasNext()) {
                OBOProperty property = (OBOProperty)it2.next();
                typeBox.addItem(property.getID());
            }
            typeBox.setSelectedItem(tr.getType().getID());
            JButton parentButton = new JButton(tr.getParent().getName());
            parentButton.setBackground(Preferences.defaultButtonColor());
            parentButton.setFont(Controller.getController().getDefaultFont());
            JButton deleteButton = new JButton(deleteIcon);
            deleteButton.setPreferredSize(new Dimension(20, 20));
            deleteButton.setBackground(Preferences.defaultButtonColor());
            deleteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CompleteDefPanel.this.relationshipList.remove(tr);
                    CompleteDefPanel.this.buildInterface();
                }
            });
            JButton selectButton = new JButton(selectIcon);
            selectButton.setPreferredSize(new Dimension(20, 20));
            selectButton.setBackground(Preferences.defaultButtonColor());
            selectButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Controller.getController().select(tr.getParent());
                }
            });
            typeBox.setEnabled(enabled);
            parentButton.setEnabled(enabled);
            deleteButton.setEnabled(enabled);
            relationshipLinePanel.add(Box.createHorizontalStrut(30));
            relationshipLinePanel.add(typeBox);
            relationshipLinePanel.add(Box.createHorizontalStrut(10));
            relationshipLinePanel.add(parentButton);
            relationshipLinePanel.add(Box.createHorizontalStrut(10));
            relationshipLinePanel.add(selectButton);
            relationshipLinePanel.add(Box.createHorizontalStrut(10));
            relationshipLinePanel.add(deleteButton);
            this.linkListPanel.add(relationshipLinePanel);
        }
        this.validate();
        this.repaint();
    }

    public String getID() {
        return "COMPLETE_DEF_EDITOR";
    }
}

