/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkDatabase;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.ReasonedLinkDatabase;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.impl.OBORestrictionImpl;
import org.geneontology.util.Subset;
import org.geneontology.util.VectorFilter;

public class TrimmedLinkDatabase
implements LinkDatabase {
    protected ReasonedLinkDatabase reasoner;
    protected LinkDatabase linkDatabase;
    protected Subset reusableSubset;
    protected boolean useReusable = false;
    public static long trimTime = 0L;

    public void setUseReusableIterator(boolean useReusable) {
        this.useReusable = useReusable;
    }

    public Collection getChildren(LinkedObject lo) {
        if (this.reasoner == null) {
            return this.linkDatabase.getChildren(lo);
        }
        VectorFilter filter = new VectorFilter(){

            public boolean satisfies(Object in) {
                Link inLink = (Link)in;
                return !TermUtil.shouldBeTrimmed(TrimmedLinkDatabase.this.linkDatabase, inLink);
            }
        };
        if (this.useReusable) {
            if (this.reusableSubset == null) {
                this.reusableSubset = new Subset();
            }
            this.reusableSubset.setFilter(filter);
            this.reusableSubset.setData(this.linkDatabase.getChildren(lo));
            return this.reusableSubset;
        }
        return new Subset(filter, this.linkDatabase.getChildren(lo));
    }

    public Collection getParents(LinkedObject lo) {
        if (this.reasoner == null) {
            return this.linkDatabase.getParents(lo);
        }
        long time = System.currentTimeMillis();
        final LinkedList<OBORestrictionImpl> timplications = new LinkedList<OBORestrictionImpl>();
        Iterator it = this.linkDatabase.getParents(lo).iterator();
        while (it.hasNext()) {
            Link parent = (Link)it.next();
            Iterator it2 = this.linkDatabase.getParents(parent.getParent()).iterator();
            while (it2.hasNext()) {
                OBORestrictionImpl result = new OBORestrictionImpl();
                Link gp = (Link)it2.next();
                if (!TermUtil.generateTransitiveImplication(this.reasoner, result, parent, gp)) continue;
                timplications.add(result);
            }
        }
        VectorFilter filter = new VectorFilter(){

            public boolean satisfies(Object in) {
                Link inLink = (Link)in;
                Iterator it = timplications.iterator();
                while (it.hasNext()) {
                    Link pLink = (Link)it.next();
                    if (!pLink.getType().equals(inLink.getType()) || !inLink.getParent().equals(pLink.getParent())) continue;
                    return false;
                }
                return true;
            }
        };
        trimTime += System.currentTimeMillis() - time;
        if (this.useReusable) {
            if (this.reusableSubset == null) {
                this.reusableSubset = new Subset();
            }
            this.reusableSubset.setFilter(filter);
            this.reusableSubset.setData(this.linkDatabase.getParents(lo));
            return this.reusableSubset;
        }
        return new Subset(filter, this.linkDatabase.getParents(lo));
    }

    public Collection getObjects() {
        return this.linkDatabase.getObjects();
    }

    public IdentifiedObject getObject(String id) {
        return this.linkDatabase.getObject(id);
    }

    public LinkDatabase getLinkDatabase() {
        return this.linkDatabase;
    }

    public void setLinkDatabase(LinkDatabase linkDatabase) {
        this.linkDatabase = linkDatabase;
    }

    public ReasonedLinkDatabase getReasoner() {
        return this.reasoner;
    }

    public void setReasoner(ReasonedLinkDatabase reasoner) {
        this.reasoner = reasoner;
    }

    public TrimmedLinkDatabase(ReasonedLinkDatabase reasoner, LinkDatabase linkDatabase) {
        this.reasoner = reasoner;
        this.linkDatabase = linkDatabase;
    }

    protected static class LinkTarget {
        protected OBOProperty type;
        protected LinkedObject parent;

        public LinkTarget() {
        }

        public LinkTarget(Link link) {
            this.type = link.getType();
            this.parent = link.getParent();
        }

        public int hashCode() {
            return this.type.hashCode() + this.parent.hashCode();
        }

        public boolean equals(Object o) {
            return ((LinkTarget)o).parent.equals(this.parent) && ((LinkTarget)o).type.equals(this.type);
        }

        public void setType(OBOProperty type) {
            this.type = type;
        }

        public void setParent(LinkedObject parent) {
            this.parent = parent;
        }
    }
}

