/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.datamodel.NestedValue;
import org.geneontology.oboedit.datamodel.Synonym;
import org.geneontology.oboedit.datamodel.SynonymCategory;
import org.geneontology.util.ObjectUtil;

public class SynonymImpl
implements Synonym {
    private static final long serialVersionUID = 45485650012520403L;
    protected String text;
    protected Set references;
    protected int type;
    protected SynonymCategory category;
    public int privateid;
    private static int idgen = 0;
    protected NestedValue nestedValue;

    public SynonymImpl() {
        this(null);
    }

    public SynonymImpl(String text) {
        this(text, 0);
    }

    public SynonymImpl(String text, int type) {
        this.setScope(type);
        this.text = text;
        this.privateid = idgen++;
        this.references = new HashSet();
    }

    public SynonymCategory getSynonymCategory() {
        return this.category;
    }

    public void setSynonymCategory(SynonymCategory category) {
        this.category = category;
    }

    public void setNestedValue(NestedValue nestedValue) {
        this.nestedValue = nestedValue;
    }

    public NestedValue getNestedValue() {
        return this.nestedValue;
    }

    public int getScope() {
        if (this.category == null || this.category.getScope() == -1) {
            return this.type;
        }
        return this.category.getScope();
    }

    public void setScope(int type) {
        if (type == -1) {
            throw new IllegalArgumentException("Cannot set synonym scope to UNKNOWN_SCOPE");
        }
        this.type = type;
    }

    public void addDbxref(Dbxref ref) {
        if (!this.references.contains(ref)) {
            this.references.add(ref);
        }
    }

    public void removeDbxref(Dbxref ref) {
        this.references.remove(ref);
    }

    public Set getDbxrefs() {
        return this.references;
    }

    public void setDbxrefs(Set references) {
        this.references = references;
    }

    public Object clone() {
        try {
            Synonym s = (Synonym)super.clone();
            ((SynonymImpl)s).references = new HashSet();
            Iterator it = this.references.iterator();
            while (it.hasNext()) {
                Dbxref ref = (Dbxref)it.next();
                s.addDbxref((Dbxref)ref.clone());
            }
            return s;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        return this.text;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int compareTo(Object o) {
        return COMPARATOR.compare(this, o);
    }

    public boolean equals(Object o) {
        if (o instanceof Synonym) {
            Synonym in = (Synonym)o;
            return ObjectUtil.equals((Object)this.text, (Object)in.getText()) && ObjectUtil.equals((Object)this.category, (Object)in.getSynonymCategory()) && this.type == in.getScope() && ((Object)in.getDbxrefs()).equals(this.references);
        }
        return false;
    }
}

