/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkDatabase;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.util.TinySet;

public class SubgraphLinkDatabase
implements LinkDatabase {
    protected LinkDatabase supportingDatabase;
    protected Map objects = new HashMap();
    protected Map parents = new HashMap();
    protected Map children = new HashMap();

    public void setLinkDatabase(LinkDatabase supportingDatabase) {
        this.supportingDatabase = supportingDatabase;
    }

    public void setObjects(Collection objects) {
        this.objects = new HashMap();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            IdentifiedObject io = (IdentifiedObject)it.next();
            this.objects.put(io.getID(), io);
        }
        this.buildSublinks();
        this.trimSublinks();
    }

    protected void buildSublinks() {
        Collection objects = this.objects.values();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            LinkedObject lo = (LinkedObject)it.next();
            Iterator it2 = this.supportingDatabase.getParents(lo).iterator();
            while (it2.hasNext()) {
                Link p = (Link)it2.next();
                if (!objects.contains(p.getChild()) || !objects.contains(p.getParent())) continue;
                this.addParent(p);
            }
        }
    }

    protected void trimSublinks() {
        Iterator it = this.parents.keySet().iterator();
        while (it.hasNext()) {
            IdentifiedObject key = (IdentifiedObject)it.next();
            Collection c = (Collection)this.parents.get(key);
            Iterator it2 = c.iterator();
            while (it2.hasNext()) {
                Link link = (Link)it2.next();
                if (!TermUtil.shouldBeTrimmed(this, link)) continue;
                it2.remove();
            }
            if (c.size() != 0) continue;
            it.remove();
        }
    }

    protected void addParent(Link link) {
        Collection out;
        Collection objects = this.objects.values();
        if (objects.contains(link.getChild())) {
            out = (Collection)this.parents.get(link.getChild());
            if (out == null) {
                out = new TinySet();
                this.parents.put(link.getChild(), out);
            }
            out.add(link);
        }
        if (objects.contains(link.getParent())) {
            out = (Collection)this.children.get(link.getParent());
            if (out == null) {
                out = new TinySet();
                this.children.put(link.getParent(), out);
            }
            out.add(link);
        }
    }

    public Collection getChildren(LinkedObject lo) {
        Set out = (Set)this.children.get(lo);
        if (out == null) {
            out = Collections.EMPTY_SET;
        }
        return out;
    }

    public Collection getObjects() {
        return this.objects.values();
    }

    public Collection getParents(LinkedObject lo) {
        Set out = (Set)this.parents.get(lo);
        if (out == null) {
            out = Collections.EMPTY_SET;
        }
        return out;
    }

    public IdentifiedObject getObject(String id) {
        return (IdentifiedObject)this.objects.get(id);
    }
}

