/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.impl;

import org.geneontology.oboedit.datamodel.Datatype;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.impl.IntegerDatatype;

public class NonPositiveIntegerDatatype
extends IntegerDatatype {
    private static final long serialVersionUID = 2283959268087758315L;

    public String getID() {
        return "xsd:nonPositiveInteger";
    }

    public String getName() {
        return this.getID();
    }

    public String getComment() {
        return "Represents a non positive integer; an integer <= 0";
    }

    public Namespace getNamespace() {
        return null;
    }

    public boolean isAbstract() {
        return false;
    }

    public Datatype getSupertype() {
        return Datatype.INTEGER;
    }

    public boolean isLegalValue(String string) {
        if (string == null) {
            return false;
        }
        try {
            int val = Integer.parseInt(string);
            return val <= 0;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public Object getValue(String string) {
        if (string == null) {
            return null;
        }
        try {
            Integer val = new Integer(string);
            if (val > 0) {
                throw new IllegalArgumentException("Non-positive integers must be < 1");
            }
            return val;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Illegal non-positive integer value " + string);
        }
    }

    public String getString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Integer || o instanceof Long) {
            int val = ((Number)o).intValue();
            if (val >= 0) {
                throw new IllegalArgumentException("Non-positive integers must be < 1");
            }
            return o.toString();
        }
        throw new IllegalArgumentException("NonPositiveIntegerDatatype can only convert values of type java.lang.Integer java.lang.Long");
    }
}

