/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.impl;

import org.geneontology.oboedit.datamodel.Datatype;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.impl.DecimalDatatype;

public class IntegerDatatype
extends DecimalDatatype {
    private static final long serialVersionUID = 7915107256768335522L;

    public String getID() {
        return "xsd:integer";
    }

    public String getName() {
        return this.getID();
    }

    public String getComment() {
        return "Represents an integer";
    }

    public Namespace getNamespace() {
        return null;
    }

    public boolean isAbstract() {
        return false;
    }

    public Datatype getSupertype() {
        return Datatype.DECIMAL;
    }

    public boolean isLegalValue(String string) {
        if (string == null) {
            return false;
        }
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public Object getValue(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new Integer(string);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Illegal integer value " + string);
        }
    }

    public String getString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Integer || o instanceof Long) {
            return o.toString();
        }
        throw new IllegalArgumentException("IntegerDatatype can only convert values of type java.lang.Integer java.lang.Long");
    }
}

