/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.impl;

import java.util.Iterator;
import org.geneontology.oboedit.datamodel.CategorizedObject;
import org.geneontology.oboedit.datamodel.CommentedObject;
import org.geneontology.oboedit.datamodel.Datatype;
import org.geneontology.oboedit.datamodel.DbxrefedObject;
import org.geneontology.oboedit.datamodel.DefinedObject;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Instance;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.MultiIDObject;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBORestriction;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.ObsoletableObject;
import org.geneontology.oboedit.datamodel.OperationModel;
import org.geneontology.oboedit.datamodel.OperationWarning;
import org.geneontology.oboedit.datamodel.Synonym;
import org.geneontology.oboedit.datamodel.SynonymCategory;
import org.geneontology.oboedit.datamodel.SynonymedObject;
import org.geneontology.oboedit.datamodel.TermCategory;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.Type;
import org.geneontology.oboedit.datamodel.Value;
import org.geneontology.oboedit.datamodel.history.AddConsiderHistoryItem;
import org.geneontology.oboedit.datamodel.history.AddDbxrefHistoryItem;
import org.geneontology.oboedit.datamodel.history.AddPropertyValueHistoryItem;
import org.geneontology.oboedit.datamodel.history.AddReplacementHistoryItem;
import org.geneontology.oboedit.datamodel.history.AddSynonymHistoryItem;
import org.geneontology.oboedit.datamodel.history.CardinalityHistoryItem;
import org.geneontology.oboedit.datamodel.history.CategoryChangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.ChangeSynCategoryHistoryItem;
import org.geneontology.oboedit.datamodel.history.ChangeSynScopeHistoryItem;
import org.geneontology.oboedit.datamodel.history.CommentChangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.CompletesHistoryItem;
import org.geneontology.oboedit.datamodel.history.CreateObjectHistoryItem;
import org.geneontology.oboedit.datamodel.history.CyclicHistoryItem;
import org.geneontology.oboedit.datamodel.history.DefinitionChangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.DelDbxrefHistoryItem;
import org.geneontology.oboedit.datamodel.history.DelSynonymHistoryItem;
import org.geneontology.oboedit.datamodel.history.DeleteLinkHistoryItem;
import org.geneontology.oboedit.datamodel.history.DeletePropertyValueHistoryItem;
import org.geneontology.oboedit.datamodel.history.DestroyObjectHistoryItem;
import org.geneontology.oboedit.datamodel.history.DomainHistoryItem;
import org.geneontology.oboedit.datamodel.history.InverseNecHistoryItem;
import org.geneontology.oboedit.datamodel.history.LinkTypeHistoryItem;
import org.geneontology.oboedit.datamodel.history.MaxCardinalityHistoryItem;
import org.geneontology.oboedit.datamodel.history.MinCardinalityHistoryItem;
import org.geneontology.oboedit.datamodel.history.NameChangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.NamespaceHistoryItem;
import org.geneontology.oboedit.datamodel.history.NecessarilyTrueHistoryItem;
import org.geneontology.oboedit.datamodel.history.ObsoleteObjectHistoryItem;
import org.geneontology.oboedit.datamodel.history.RangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.RemoveConsiderHistoryItem;
import org.geneontology.oboedit.datamodel.history.RemoveReplacementHistoryItem;
import org.geneontology.oboedit.datamodel.history.SecondaryIDHistoryItem;
import org.geneontology.oboedit.datamodel.history.SymmetricHistoryItem;
import org.geneontology.oboedit.datamodel.history.SynonymCategoryHistoryItem;
import org.geneontology.oboedit.datamodel.history.TRNamespaceHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermCategoryHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermCopyHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermNamespaceHistoryItem;
import org.geneontology.oboedit.datamodel.history.TransitiveHistoryItem;
import org.geneontology.oboedit.datamodel.impl.DatatypeValueImpl;
import org.geneontology.oboedit.datamodel.impl.OBORestrictionImpl;

public class DefaultOperationModel
implements OperationModel {
    protected OBOSession history;
    protected transient int macrodepth = 0;

    public void setHistory(OBOSession history) {
        this.history = history;
    }

    protected boolean doMark() {
        return this.macrodepth < 1;
    }

    public OperationWarning apply(HistoryItem item) {
        this.history.setNeedsSave(true);
        if (item instanceof CreateObjectHistoryItem) {
            return this.apply((CreateObjectHistoryItem)item);
        }
        if (item instanceof TermCopyHistoryItem) {
            return this.apply((TermCopyHistoryItem)item);
        }
        if (item instanceof DeleteLinkHistoryItem) {
            return this.apply((DeleteLinkHistoryItem)item);
        }
        if (item instanceof DestroyObjectHistoryItem) {
            return this.apply((DestroyObjectHistoryItem)item);
        }
        if (item instanceof ObsoleteObjectHistoryItem) {
            return this.apply((ObsoleteObjectHistoryItem)item);
        }
        if (item instanceof TermMacroHistoryItem) {
            return this.apply((TermMacroHistoryItem)item);
        }
        if (item instanceof LinkTypeHistoryItem) {
            return this.apply((LinkTypeHistoryItem)item);
        }
        if (item instanceof NamespaceHistoryItem) {
            return this.apply((NamespaceHistoryItem)item);
        }
        if (item instanceof NameChangeHistoryItem) {
            return this.apply((NameChangeHistoryItem)item);
        }
        if (item instanceof DefinitionChangeHistoryItem) {
            return this.apply((DefinitionChangeHistoryItem)item);
        }
        if (item instanceof TermCategoryHistoryItem) {
            return this.apply((TermCategoryHistoryItem)item);
        }
        if (item instanceof SynonymCategoryHistoryItem) {
            return this.apply((SynonymCategoryHistoryItem)item);
        }
        if (item instanceof ChangeSynCategoryHistoryItem) {
            return this.apply((ChangeSynCategoryHistoryItem)item);
        }
        if (item instanceof ChangeSynScopeHistoryItem) {
            return this.apply((ChangeSynScopeHistoryItem)item);
        }
        if (item instanceof TermNamespaceHistoryItem) {
            return this.apply((TermNamespaceHistoryItem)item);
        }
        if (item instanceof AddDbxrefHistoryItem) {
            return this.apply((AddDbxrefHistoryItem)item);
        }
        if (item instanceof DelDbxrefHistoryItem) {
            return this.apply((DelDbxrefHistoryItem)item);
        }
        if (item instanceof AddSynonymHistoryItem) {
            return this.apply((AddSynonymHistoryItem)item);
        }
        if (item instanceof DelSynonymHistoryItem) {
            return this.apply((DelSynonymHistoryItem)item);
        }
        if (item instanceof CommentChangeHistoryItem) {
            return this.apply((CommentChangeHistoryItem)item);
        }
        if (item instanceof CategoryChangeHistoryItem) {
            return this.apply((CategoryChangeHistoryItem)item);
        }
        if (item instanceof SecondaryIDHistoryItem) {
            return this.apply((SecondaryIDHistoryItem)item);
        }
        if (item instanceof NecessarilyTrueHistoryItem) {
            return this.apply((NecessarilyTrueHistoryItem)item);
        }
        if (item instanceof InverseNecHistoryItem) {
            return this.apply((InverseNecHistoryItem)item);
        }
        if (item instanceof CompletesHistoryItem) {
            return this.apply((CompletesHistoryItem)item);
        }
        if (item instanceof RangeHistoryItem) {
            return this.apply((RangeHistoryItem)item);
        }
        if (item instanceof DomainHistoryItem) {
            return this.apply((DomainHistoryItem)item);
        }
        if (item instanceof AddReplacementHistoryItem) {
            return this.apply((AddReplacementHistoryItem)item);
        }
        if (item instanceof RemoveReplacementHistoryItem) {
            return this.apply((RemoveReplacementHistoryItem)item);
        }
        if (item instanceof CyclicHistoryItem) {
            return this.apply((CyclicHistoryItem)item);
        }
        if (item instanceof CardinalityHistoryItem) {
            return this.apply((CardinalityHistoryItem)item);
        }
        if (item instanceof SymmetricHistoryItem) {
            return this.apply((SymmetricHistoryItem)item);
        }
        if (item instanceof TransitiveHistoryItem) {
            return this.apply((TransitiveHistoryItem)item);
        }
        if (item instanceof TRNamespaceHistoryItem) {
            return this.apply((TRNamespaceHistoryItem)item);
        }
        if (item instanceof CardinalityHistoryItem) {
            return this.apply((CardinalityHistoryItem)item);
        }
        if (item instanceof MinCardinalityHistoryItem) {
            return this.apply((MinCardinalityHistoryItem)item);
        }
        if (item instanceof MaxCardinalityHistoryItem) {
            return this.apply((MaxCardinalityHistoryItem)item);
        }
        if (item instanceof AddConsiderHistoryItem) {
            return this.apply((AddConsiderHistoryItem)item);
        }
        if (item instanceof RemoveConsiderHistoryItem) {
            return this.apply((RemoveConsiderHistoryItem)item);
        }
        if (item instanceof AddPropertyValueHistoryItem) {
            return this.apply((AddPropertyValueHistoryItem)item);
        }
        if (item instanceof DeletePropertyValueHistoryItem) {
            return this.apply((DeletePropertyValueHistoryItem)item);
        }
        return new OperationWarning("Unknown history item " + item + " found of type " + item.getClass() + "!");
    }

    public OperationWarning apply(AddPropertyValueHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not add property value to non-existant object " + item.getTarget());
        }
        if (!(target instanceof Instance)) {
            return new OperationWarning("Cannot add property value to non-instance " + target);
        }
        Instance instance = (Instance)target;
        LinkedObject property = this.getRealObject(item.getPropertyID());
        if (property == null) {
            return new OperationWarning("Cannot add property value with non-existant property " + item.getPropertyID());
        }
        if (!(property instanceof OBOProperty)) {
            return new OperationWarning("Cannot add property value with non-property " + item.getPropertyID());
        }
        OBOProperty oboProperty = (OBOProperty)property;
        Value value = null;
        if (item.getDatatypeID() == null) {
            value = this.getRealObject(item.getValue());
        } else {
            Datatype type = null;
            for (int i = 0; i < Datatype.DATATYPES.length; ++i) {
                if (!Datatype.DATATYPES[i].getID().equals(item.getDatatypeID())) continue;
                type = Datatype.DATATYPES[i];
                break;
            }
            if (type == null) {
                return new OperationWarning("Cannot use unrecognized datatype " + item.getDatatypeID());
            }
            try {
                value = new DatatypeValueImpl(type, item.getValue());
            }
            catch (Exception ex) {
                return new OperationWarning("Value " + value + " is not a legal " + "value for datatype " + type);
            }
        }
        instance.addPropertyValue(oboProperty, value);
        return null;
    }

    public OperationWarning reverse(AddPropertyValueHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not undo add property value with non-existant object " + item.getTarget());
        }
        if (!(target instanceof Instance)) {
            return new OperationWarning("Cannot not undo add property value to non-instance " + target);
        }
        Instance instance = (Instance)target;
        LinkedObject property = this.getRealObject(item.getPropertyID());
        if (property == null) {
            return new OperationWarning("Cannot undo add property value to non-existant property " + item.getPropertyID());
        }
        if (!(property instanceof OBOProperty)) {
            return new OperationWarning("Cannot undo add property value to non-property " + item.getPropertyID());
        }
        OBOProperty oboProperty = (OBOProperty)property;
        Value value = null;
        if (item.getDatatypeID() == null) {
            value = this.getRealObject(item.getValue());
        } else {
            Datatype type = null;
            for (int i = 0; i < Datatype.DATATYPES.length; ++i) {
                if (!Datatype.DATATYPES[i].getID().equals(item.getDatatypeID())) continue;
                type = Datatype.DATATYPES[i];
                break;
            }
            if (type == null) {
                return new OperationWarning("Cannot use unrecognized datatype " + item.getDatatypeID());
            }
            try {
                value = new DatatypeValueImpl(type, item.getValue());
            }
            catch (Exception ex) {
                return new OperationWarning("Value " + value + " is not a legal " + "value for datatype " + type);
            }
        }
        instance.removePropertyValue(oboProperty, value);
        return null;
    }

    public OperationWarning apply(DeletePropertyValueHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not delete property value from non-existant object " + item.getTarget());
        }
        if (!(target instanceof Instance)) {
            return new OperationWarning("Cannot delete property value from non-instance " + target);
        }
        Instance instance = (Instance)target;
        LinkedObject property = this.getRealObject(item.getPropertyID());
        if (property == null) {
            return new OperationWarning("Cannot delete property value from non-existant property " + item.getPropertyID());
        }
        if (!(property instanceof OBOProperty)) {
            return new OperationWarning("Cannot delete property value with non-property " + item.getPropertyID());
        }
        OBOProperty oboProperty = (OBOProperty)property;
        Value value = null;
        if (item.getDatatypeID() == null) {
            value = this.getRealObject(item.getValue());
        } else {
            Datatype type = null;
            for (int i = 0; i < Datatype.DATATYPES.length; ++i) {
                if (!Datatype.DATATYPES[i].getID().equals(item.getDatatypeID())) continue;
                type = Datatype.DATATYPES[i];
                break;
            }
            if (type == null) {
                return new OperationWarning("Cannot use unrecognized datatype " + item.getDatatypeID());
            }
            try {
                value = new DatatypeValueImpl(type, item.getValue());
            }
            catch (Exception ex) {
                return new OperationWarning("Value " + value + " is not a legal " + "value for datatype " + type);
            }
        }
        instance.removePropertyValue(oboProperty, value);
        return null;
    }

    public OperationWarning reverse(DeletePropertyValueHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not undo delete property value from non-existant object " + item.getTarget());
        }
        if (!(target instanceof Instance)) {
            return new OperationWarning("Cannot undo delete property value from non-instance " + target);
        }
        Instance instance = (Instance)target;
        LinkedObject property = this.getRealObject(item.getPropertyID());
        if (property == null) {
            return new OperationWarning("Cannot undo delete property value from non-existant property " + item.getPropertyID());
        }
        if (!(property instanceof OBOProperty)) {
            return new OperationWarning("Cannot undo delete property value from non-property " + item.getPropertyID());
        }
        OBOProperty oboProperty = (OBOProperty)property;
        Value value = null;
        if (item.getDatatypeID() == null) {
            value = this.getRealObject(item.getValue());
        } else {
            Datatype type = null;
            for (int i = 0; i < Datatype.DATATYPES.length; ++i) {
                if (!Datatype.DATATYPES[i].getID().equals(item.getDatatypeID())) continue;
                type = Datatype.DATATYPES[i];
                break;
            }
            if (type == null) {
                return new OperationWarning("Cannot use unrecognized datatype " + item.getDatatypeID());
            }
            try {
                value = new DatatypeValueImpl(type, item.getValue());
            }
            catch (Exception ex) {
                return new OperationWarning("Value " + value + " is not a legal " + "value for datatype " + type);
            }
        }
        instance.addPropertyValue(oboProperty, value);
        return null;
    }

    public OperationWarning apply(AddDbxrefHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not add dbxref to non-existant object " + item.getTarget());
        }
        if (item.isDef()) {
            if (!(target instanceof DefinedObject)) {
                return new OperationWarning("Could not add def dbxref to non-defined object " + item.getTarget());
            }
            ((DefinedObject)((Object)target)).addDefDbxref(item.getDbxref());
        } else if (item.getSynonym() != null) {
            if (!(target instanceof SynonymedObject)) {
                return new OperationWarning("Could not add synonym dbxref to non-synonymed object " + item.getTarget());
            }
            Synonym s = TermUtil.findSynonym((SynonymedObject)((Object)target), item.getSynonym());
            if (s == null) {
                return new OperationWarning("Could not modify non-existant synonym " + s + " of " + target);
            }
            s.addDbxref(item.getDbxref());
        } else {
            if (!(target instanceof DbxrefedObject)) {
                return new OperationWarning("Could not add dbxref to non-dbxrefed object " + item.getTarget());
            }
            ((DbxrefedObject)((Object)target)).addDbxref(item.getDbxref());
        }
        return null;
    }

    public OperationWarning reverse(AddDbxrefHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not remove dbxref from non-existant object " + item.getTarget());
        }
        if (item.isDef()) {
            if (!(target instanceof DefinedObject)) {
                return new OperationWarning("Could not remove def dbxref from non-defined object " + item.getTarget());
            }
            ((DefinedObject)((Object)target)).removeDefDbxref(item.getDbxref());
        } else if (item.getSynonym() != null) {
            if (!(target instanceof SynonymedObject)) {
                return new OperationWarning("Could not remove synonym dbxref from non-synonymed object " + item.getTarget());
            }
            Synonym s = TermUtil.findSynonym((SynonymedObject)((Object)target), item.getSynonym());
            s.removeDbxref(item.getDbxref());
        } else {
            if (!(target instanceof DbxrefedObject)) {
                return new OperationWarning("Could not remove dbxref from non-dbxrefed object " + item.getTarget());
            }
            ((DbxrefedObject)((Object)target)).removeDbxref(item.getDbxref());
        }
        return null;
    }

    public OperationWarning reverse(DelDbxrefHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not add dbxref to non-existant object " + item.getTarget());
        }
        if (item.isDef()) {
            if (!(target instanceof DefinedObject)) {
                return new OperationWarning("Could not add def dbxref to non-defined object " + item.getTarget());
            }
            ((DefinedObject)((Object)target)).addDefDbxref(item.getDbxref());
        } else if (item.getSynonym() != null) {
            if (!(target instanceof SynonymedObject)) {
                return new OperationWarning("Could not add synonym dbxref to non-synonymed object " + item.getTarget());
            }
            Synonym s = TermUtil.findSynonym((SynonymedObject)((Object)target), item.getSynonym());
            s.addDbxref(item.getDbxref());
        } else {
            if (!(target instanceof DbxrefedObject)) {
                return new OperationWarning("Could not add dbxref to non-dbxrefed object " + item.getTarget());
            }
            ((DbxrefedObject)((Object)target)).addDbxref(item.getDbxref());
        }
        return null;
    }

    public OperationWarning apply(DelDbxrefHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not remove dbxref from non-existant object " + item.getTarget());
        }
        if (item.isDef()) {
            if (!(target instanceof DefinedObject)) {
                return new OperationWarning("Could not remove def dbxref from non-defined object " + item.getTarget());
            }
            ((DefinedObject)((Object)target)).removeDefDbxref(item.getDbxref());
        } else if (item.getSynonym() != null) {
            if (!(target instanceof SynonymedObject)) {
                return new OperationWarning("Could not remove synonym dbxref from non-synonymed object " + item.getTarget());
            }
            Synonym s = TermUtil.findSynonym((SynonymedObject)((Object)target), item.getSynonym());
            s.removeDbxref(item.getDbxref());
        } else {
            if (!(target instanceof DbxrefedObject)) {
                return new OperationWarning("Could not remove dbxref from non-dbxrefed object " + item.getTarget());
            }
            System.err.println(">>>>>> trying to remove " + item.getDbxref() + "{type=" + item.getDbxref().getType() + "}" + " from " + target);
            ((DbxrefedObject)((Object)target)).removeDbxref(item.getDbxref());
            System.err.println(">>>>>>>>> remaining dbxrefs: " + ((DbxrefedObject)((Object)target)).getDbxrefs());
        }
        return null;
    }

    public OperationWarning apply(TRNamespaceHistoryItem item) {
        HistoryItem.StringRelationship sr = item.getRel();
        Link tr = this.getRealRel(sr);
        LinkedObject parent = tr.getParent();
        if (parent == null) {
            return new OperationWarning("Couldn't do relationship namespace change with missing parent " + sr.getParent());
        }
        if (tr.getChild() == null) {
            return new OperationWarning("Couldn't do relationship namespace change with missing child " + sr.getChild());
        }
        if (tr.getType() == null) {
            return new OperationWarning("Couldn't complete relationship namespace change with missing relationship type " + sr.getType());
        }
        tr = TermUtil.findChildRel(tr, tr.getParent());
        tr.setNamespace(this.history.getNamespace(item.getNewNamespace()));
        return null;
    }

    public OperationWarning reverse(TRNamespaceHistoryItem item) {
        HistoryItem.StringRelationship sr = item.getRel();
        Link tr = this.getRealRel(sr);
        LinkedObject parent = tr.getParent();
        if (parent == null) {
            return new OperationWarning("Couldn't reverse relationship namespace change with missing parent " + sr.getParent());
        }
        if (tr.getChild() == null) {
            return new OperationWarning("Couldn't reverse relationship namespace change with missing child " + sr.getChild());
        }
        if (tr.getType() == null) {
            return new OperationWarning("Couldn't reverse relationship namespace change with missing relationship type " + sr.getType());
        }
        tr = TermUtil.findChildRel(tr, tr.getParent());
        tr.setNamespace(this.history.getNamespace(item.getOldNamespace()));
        return null;
    }

    public OperationWarning apply(CyclicHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not change cyclic quality of non-existant term " + item.getTarget());
        }
        if (!(target instanceof OBOProperty)) {
            return new OperationWarning("Could not change cyclic quality of non-type term " + item.getTarget());
        }
        OBOProperty type = (OBOProperty)target;
        type.setCyclic(!item.getOldCyclic());
        return null;
    }

    public OperationWarning reverse(CyclicHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not change cyclic quality of non-existant term " + item.getTarget());
        }
        if (!(target instanceof OBOProperty)) {
            return new OperationWarning("Could not change cyclic quality of non-type term " + item.getTarget());
        }
        OBOProperty type = (OBOProperty)target;
        type.setCyclic(item.getOldCyclic());
        return null;
    }

    public OperationWarning apply(SymmetricHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not change symmetric quality of non-existant term " + item.getTarget());
        }
        if (!(target instanceof OBOProperty)) {
            return new OperationWarning("Could not change symmetric quality of non-type term " + item.getTarget());
        }
        OBOProperty type = (OBOProperty)target;
        type.setSymmetric(!item.getOldSymmetric());
        return null;
    }

    public OperationWarning reverse(SymmetricHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not change symmetric quality of non-existant term " + item.getTarget());
        }
        if (!(target instanceof OBOProperty)) {
            return new OperationWarning("Could not change symmetric quality of non-type term " + item.getTarget());
        }
        OBOProperty type = (OBOProperty)target;
        type.setSymmetric(item.getOldSymmetric());
        return null;
    }

    public OperationWarning apply(TransitiveHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not change transitive quality of non-existant term " + item.getTarget());
        }
        if (!(target instanceof OBOProperty)) {
            return new OperationWarning("Could not change transitive quality of non-type term " + item.getTarget());
        }
        OBOProperty type = (OBOProperty)target;
        type.setTransitive(!item.getOldTransitive());
        return null;
    }

    public OperationWarning reverse(TransitiveHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not change transitive quality of non-existant term " + item.getTarget());
        }
        if (!(target instanceof OBOProperty)) {
            return new OperationWarning("Could not change transitive quality of non-type term " + item.getTarget());
        }
        OBOProperty type = (OBOProperty)target;
        type.setTransitive(item.getOldTransitive());
        return null;
    }

    public OperationWarning apply(TermCategoryHistoryItem item) {
        if (item.isAdd()) {
            this.history.addCategory(item.getNewCategory());
        } else if (item.isDel()) {
            this.history.removeCategory(item.getOldCategory());
        } else {
            Iterator it = this.history.getCategories().iterator();
            while (it.hasNext()) {
                TermCategory cat = (TermCategory)it.next();
                if (!cat.equals(item.getOldCategory())) continue;
                cat.setName(item.getNewCategory().getName());
                cat.setDesc(item.getNewCategory().getDesc());
            }
        }
        return null;
    }

    public OperationWarning reverse(TermCategoryHistoryItem item) {
        if (item.isAdd()) {
            this.history.removeCategory(item.getNewCategory());
        } else if (item.isDel()) {
            this.history.addCategory(item.getOldCategory());
        } else {
            Iterator it = this.history.getCategories().iterator();
            while (it.hasNext()) {
                TermCategory cat = (TermCategory)it.next();
                if (!cat.equals(item.getNewCategory())) continue;
                cat.setName(item.getOldCategory().getName());
                cat.setDesc(item.getOldCategory().getDesc());
            }
        }
        return null;
    }

    public OperationWarning apply(SynonymCategoryHistoryItem item) {
        if (item.isAdd()) {
            this.history.addSynonymCategory(item.getNewCategory());
        } else if (item.isDel()) {
            this.history.removeSynonymCategory(item.getOldCategory());
        } else {
            Iterator it = this.history.getSynonymCategories().iterator();
            while (it.hasNext()) {
                SynonymCategory cat = (SynonymCategory)it.next();
                if (!cat.equals(item.getOldCategory())) continue;
                cat.setID(item.getNewCategory().getID());
                cat.setName(item.getNewCategory().getName());
                cat.setScope(item.getNewCategory().getScope());
            }
        }
        return null;
    }

    public OperationWarning reverse(SynonymCategoryHistoryItem item) {
        if (item.isAdd()) {
            this.history.removeSynonymCategory(item.getNewCategory());
        } else if (item.isDel()) {
            this.history.addSynonymCategory(item.getOldCategory());
        } else {
            Iterator it = this.history.getSynonymCategories().iterator();
            while (it.hasNext()) {
                SynonymCategory cat = (SynonymCategory)it.next();
                if (!cat.equals(item.getNewCategory())) continue;
                cat.setID(item.getOldCategory().getID());
                cat.setName(item.getOldCategory().getName());
                cat.setScope(item.getOldCategory().getScope());
            }
        }
        return null;
    }

    public OperationWarning apply(TermNamespaceHistoryItem item) {
        if (item.isAdd()) {
            this.history.addNamespace(this.history.getObjectFactory().createNamespace(item.getNewID(), null));
        } else if (item.isDel()) {
            this.history.removeNamespace(this.history.getNamespace(item.getOldID()));
        } else {
            Namespace ns = this.history.getNamespace(item.getOldID());
            ns.setID(item.getNewID());
        }
        return null;
    }

    public OperationWarning reverse(TermNamespaceHistoryItem item) {
        if (item.isAdd()) {
            this.history.removeNamespace(this.history.getNamespace(item.getNewID()));
        } else if (item.isDel()) {
            this.history.addNamespace(this.history.getNamespace(item.getOldID()));
        } else {
            Namespace ns = this.history.getNamespace(item.getNewID());
            ns.setID(item.getOldID());
        }
        return null;
    }

    protected LinkedObject getRealObject(String term) {
        return (LinkedObject)this.getRealIDObject(term);
    }

    protected IdentifiedObject getRealIDObject(String term) {
        if (term == null) {
            return null;
        }
        return this.history.getObject(term);
    }

    protected Link getRealRel(HistoryItem.StringRelationship tr) {
        if (tr == null) {
            return null;
        }
        LinkedObject parent = this.getRealObject(tr.getParent());
        LinkedObject child = this.getRealObject(tr.getChild());
        OBOProperty type = (OBOProperty)this.getRealObject(tr.getType());
        Namespace ns = this.history.getNamespace(tr.getNamespace());
        OBORestrictionImpl realtr = new OBORestrictionImpl(child, parent, type);
        realtr.setNamespace(ns);
        realtr.setNecessarilyTrue(tr.isNecessary());
        realtr.setInverseNecessarilyTrue(tr.isInverseNecessary());
        realtr.setCompletes(tr.completes());
        realtr.setMinCardinality(tr.getMinCardinality());
        realtr.setMaxCardinality(tr.getMaxCardinality());
        realtr.setCardinality(tr.getCardinality());
        return realtr;
    }

    public OperationWarning apply(CreateObjectHistoryItem item) {
        IdentifiedObject type = this.history.getObject(item.getObjectType());
        if (type == null) {
            return new OperationWarning("Could not find type " + item.getObjectType() + ".");
        }
        if (!(type instanceof OBOClass)) {
            return new OperationWarning(item.getObjectType() + " is not a " + "type.");
        }
        IdentifiedObject io = this.history.getObjectFactory().createObject(item.getObjectID(), (OBOClass)type, item.isAnonymous());
        this.history.addObject(io);
        if (this.doMark()) {
            this.history.markRoots();
        }
        return null;
    }

    public OperationWarning reverse(CreateObjectHistoryItem item) {
        IdentifiedObject newObj = this.history.getObject(item.getObjectID());
        this.history.removeObject(newObj);
        if (this.doMark()) {
            this.history.markRoots();
        }
        return null;
    }

    public OperationWarning apply(SecondaryIDHistoryItem item) {
        LinkedObject t = this.getRealObject(item.getTarget());
        if (t == null) {
            return new OperationWarning("Could not assign secondary id to unknown target " + item.getTarget());
        }
        if (!(t instanceof MultiIDObject)) {
            return new OperationWarning("Could not assign secondary id to " + item.getTarget() + " because it does " + "not allow secondary ids");
        }
        MultiIDObject target = (MultiIDObject)((Object)t);
        boolean hasSecondary = target.getSecondaryIDs().contains(item.getSecondaryID());
        if (item.isDelete()) {
            if (!hasSecondary) {
                return new OperationWarning("Could not remove secondary id " + item.getSecondaryID() + " from target " + item.getTarget() + ", because the " + "term does not have that id.");
            }
            target.removeSecondaryID(item.getSecondaryID());
        } else {
            if (hasSecondary) {
                return new OperationWarning("Could not add secondary id " + item.getSecondaryID() + " to target " + item.getTarget() + ", because the " + "term already has that id.");
            }
            target.addSecondaryID(item.getSecondaryID());
        }
        return null;
    }

    public OperationWarning reverse(SecondaryIDHistoryItem item) {
        LinkedObject t = this.getRealObject(item.getTarget());
        if (t == null) {
            return new OperationWarning("Could not reverse assignment of secondary id to unknown target " + item.getTarget());
        }
        if (!(t instanceof MultiIDObject)) {
            return new OperationWarning("Could not reverse assignment of secondary id to " + item.getTarget() + " because it does " + "not allow secondary ids");
        }
        MultiIDObject target = (MultiIDObject)((Object)t);
        boolean hasSecondary = target.getSecondaryIDs().contains(item.getSecondaryID());
        if (item.isDelete()) {
            if (hasSecondary) {
                return new OperationWarning("Could not reverse deletion of secondary id " + item.getSecondaryID() + " to target " + item.getTarget() + ", because the " + "term already has that id.");
            }
            target.addSecondaryID(item.getSecondaryID());
        } else {
            if (!hasSecondary) {
                return new OperationWarning("Could not reverse addition of secondary id " + item.getSecondaryID() + " from target " + item.getTarget() + ", because the " + "term does not have that id.");
            }
            target.removeSecondaryID(item.getSecondaryID());
        }
        return null;
    }

    public OperationWarning apply(InverseNecHistoryItem item) {
        OBORestriction tr = (OBORestriction)this.getRealRel(item.getRel());
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change inverse necessary status of unknown term relationship " + item.getRel() + " to " + !item.getOldInverseNecessary());
            return cwarning;
        }
        if ((tr = (OBORestriction)TermUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change inverse necessary status of unknown term relationship " + tr + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.setInverseNecessarilyTrue(!item.getOldInverseNecessary());
        return null;
    }

    public OperationWarning reverse(InverseNecHistoryItem item) {
        OBORestriction tr = (OBORestriction)this.getRealRel(item.getRel());
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change inverse necessary status of unknown term relationship " + item.getRel() + " back to " + item.getOldInverseNecessary());
            return cwarning;
        }
        if ((tr = (OBORestriction)TermUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change inverse necessary status of unknown term relationship " + tr + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.setInverseNecessarilyTrue(item.getOldInverseNecessary());
        return null;
    }

    public OperationWarning apply(RangeHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        IdentifiedObject range = this.getRealIDObject(item.getRange());
        if (target == null) {
            OperationWarning warning = new OperationWarning("Couldn't change range of " + item.getTarget() + " because it doesn't exist in the ontology" + item.getRange());
            return warning;
        }
        if (range == null) {
            OperationWarning warning = new OperationWarning("Could not apply change range of " + item.getTarget() + " to " + item.getRange() + ", because " + item.getRange() + " does not " + "exist in the ontology");
            return warning;
        }
        if (!(target instanceof OBOProperty)) {
            OperationWarning warning = new OperationWarning("Could not apply range change to non-property " + target);
            return warning;
        }
        if (range != null && !(range instanceof Type)) {
            OperationWarning warning = new OperationWarning("Could not apply range change to " + target + " with non-type object " + item.getRange());
            return warning;
        }
        OBOProperty type = (OBOProperty)target;
        type.setRange((Type)range);
        return null;
    }

    public OperationWarning reverse(RangeHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        IdentifiedObject range = this.getRealIDObject(item.getOldRange());
        if (target == null) {
            OperationWarning warning = new OperationWarning("Couldn't reverse range change of " + item.getTarget() + " because it doesn't exist in the ontology" + item.getRange());
            return warning;
        }
        if (range == null) {
            OperationWarning warning = new OperationWarning("Could not reverse change range of " + item.getTarget() + " to " + item.getOldRange() + ", because " + item.getOldRange() + " does not " + "exist in the ontology");
            return warning;
        }
        if (!(target instanceof OBOProperty)) {
            OperationWarning warning = new OperationWarning("Could not reverse range change of non-type " + target);
            return warning;
        }
        if (range != null && !(range instanceof Type)) {
            OperationWarning warning = new OperationWarning("Could not reverse range change to " + target + " with non-type object " + item.getRange());
            return warning;
        }
        OBOProperty type = (OBOProperty)target;
        type.setRange((Type)range);
        return null;
    }

    public OperationWarning apply(AddReplacementHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        LinkedObject replacedBy = this.getRealObject(item.getReplace());
        if (target == null) {
            OperationWarning warning = new OperationWarning("Couldn't change replacement for " + item.getTarget() + " because it doesn't exist in the ontology");
            return warning;
        }
        if (replacedBy == null && item.getReplace() != null) {
            OperationWarning warning = new OperationWarning("Could not change replacement of " + item.getTarget() + " to " + item.getReplace() + ", because " + item.getReplace() + " does not " + "exist in the ontology");
            return warning;
        }
        if (!(target instanceof ObsoletableObject)) {
            OperationWarning warning = new OperationWarning("Could not change replacement to non-obsoletable object " + item.getTarget());
            return warning;
        }
        if (replacedBy != null && !(replacedBy instanceof ObsoletableObject)) {
            OperationWarning warning = new OperationWarning("Could not change replacement of " + target + " to non-obsoletable object " + item.getTarget());
            return warning;
        }
        ((ObsoletableObject)((Object)target)).addReplacedBy((ObsoletableObject)((Object)replacedBy));
        return null;
    }

    public OperationWarning reverse(RemoveReplacementHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        LinkedObject replacedBy = this.getRealObject(item.getReplace());
        if (target == null) {
            OperationWarning warning = new OperationWarning("Couldn't undo replacement for " + item.getTarget() + " because it doesn't exist in the ontology");
            return warning;
        }
        if (replacedBy == null && item.getReplace() != null) {
            OperationWarning warning = new OperationWarning("Could not undo replacement of " + item.getTarget() + " to " + item.getReplace() + ", because " + item.getReplace() + " does not " + "exist in the ontology");
            return warning;
        }
        if (!(target instanceof ObsoletableObject)) {
            OperationWarning warning = new OperationWarning("Could not undo replacement to non-obsoletable object " + item.getTarget());
            return warning;
        }
        if (replacedBy != null && !(replacedBy instanceof ObsoletableObject)) {
            OperationWarning warning = new OperationWarning("Could not undo replacement of " + target + " to non-obsoletable object " + item.getTarget());
            return warning;
        }
        ((ObsoletableObject)((Object)target)).addReplacedBy((ObsoletableObject)((Object)replacedBy));
        return null;
    }

    public OperationWarning apply(RemoveReplacementHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        LinkedObject replacedBy = this.getRealObject(item.getReplace());
        if (target == null) {
            OperationWarning warning = new OperationWarning("Couldn't remove replacement for " + item.getTarget() + " because it doesn't exist in the ontology");
            return warning;
        }
        if (replacedBy == null && item.getReplace() != null) {
            OperationWarning warning = new OperationWarning("Could not remove replacement of " + item.getTarget() + " to " + item.getReplace() + ", because " + item.getReplace() + " does not exist in the ontology");
            return warning;
        }
        if (!(target instanceof ObsoletableObject)) {
            OperationWarning warning = new OperationWarning("Could not remove replacement for non-obsoletable object " + item.getTarget());
            return warning;
        }
        if (replacedBy != null && !(replacedBy instanceof ObsoletableObject)) {
            OperationWarning warning = new OperationWarning("Could not remove replacement for " + target + " of non-obsoletable object " + replacedBy);
            return warning;
        }
        ((ObsoletableObject)((Object)target)).removeReplacedBy((ObsoletableObject)((Object)replacedBy));
        return null;
    }

    public OperationWarning reverse(AddReplacementHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        LinkedObject replacedBy = this.getRealObject(item.getReplace());
        if (target == null) {
            OperationWarning warning = new OperationWarning("Couldn't reverse replacement change for " + item.getTarget() + " because it doesn't exist in the ontology");
            return warning;
        }
        if (replacedBy == null && item.getReplace() != null) {
            OperationWarning warning = new OperationWarning("Could not reverse replacement change of " + item.getTarget() + " to " + item.getReplace() + ", because " + item.getReplace() + " does not exist in the ontology");
            return warning;
        }
        if (!(target instanceof ObsoletableObject)) {
            OperationWarning warning = new OperationWarning("Could not reverse replacement change to non-obsoletable object " + item.getTarget());
            return warning;
        }
        if (replacedBy != null && !(replacedBy instanceof ObsoletableObject)) {
            OperationWarning warning = new OperationWarning("Could not reverse replacement change of " + target + " to non-obsoletable object " + replacedBy);
            return warning;
        }
        ((ObsoletableObject)((Object)target)).removeReplacedBy((ObsoletableObject)((Object)replacedBy));
        return null;
    }

    public OperationWarning apply(DomainHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        IdentifiedObject domain = this.getRealIDObject(item.getDomain());
        if (target == null) {
            OperationWarning warning = new OperationWarning("Couldn't change domain of " + item.getTarget() + " because it doesn't exist in the ontology" + item.getDomain());
            return warning;
        }
        if (domain == null && item.getDomain() != null) {
            OperationWarning warning = new OperationWarning("Could not apply change domain of " + item.getTarget() + " to " + item.getDomain() + ", because " + item.getDomain() + " does not " + "exist in the ontology");
            return warning;
        }
        if (!(target instanceof OBOProperty)) {
            OperationWarning warning = new OperationWarning("Could not apply domain change to non-type " + item.getTarget());
            return warning;
        }
        if (domain != null && !(domain instanceof OBOClass)) {
            OperationWarning warning = new OperationWarning("Could not apply domain change to " + target + " with non-type object " + item.getDomain());
            return warning;
        }
        OBOProperty type = (OBOProperty)target;
        type.setDomain((OBOClass)domain);
        return null;
    }

    public OperationWarning reverse(DomainHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        IdentifiedObject domain = this.getRealIDObject(item.getOldDomain());
        if (target == null) {
            OperationWarning warning = new OperationWarning("Couldn't reverse domain change of " + item.getTarget() + " because it doesn't exist in the ontology.");
            return warning;
        }
        if (domain == null && item.getOldDomain() != null) {
            OperationWarning warning = new OperationWarning("Could not reverse change domain of " + item.getTarget() + " back to " + item.getOldDomain() + ", because " + item.getOldDomain() + " does not " + "exist in the ontology");
            return warning;
        }
        if (!(target instanceof OBOProperty)) {
            OperationWarning warning = new OperationWarning("Could not reverse domain change to non-type " + item.getTarget());
            return warning;
        }
        if (domain != null && !(domain instanceof OBOClass)) {
            OperationWarning warning = new OperationWarning("Could not reverse domain change to " + target + " with non-type object " + item.getDomain());
            return warning;
        }
        OBOProperty type = (OBOProperty)target;
        type.setDomain((OBOClass)domain);
        return null;
    }

    public OperationWarning apply(CardinalityHistoryItem item) {
        OBORestriction tr = (OBORestriction)this.getRealRel(item.getRel());
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change cardinality of unknown term relationship " + item.getRel() + " to " + item.getOldValue());
            return cwarning;
        }
        if ((tr = (OBORestriction)TermUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change cardinality of unknown term relationship " + tr + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.setCardinality(item.getNewValue());
        return null;
    }

    public OperationWarning reverse(CardinalityHistoryItem item) {
        OBORestriction tr = (OBORestriction)this.getRealRel(item.getRel());
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change cardinality of unknown term relationship " + item.getRel() + " to " + item.getOldValue());
            return cwarning;
        }
        if ((tr = (OBORestriction)TermUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change cardinality of unknown term relationship " + tr + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.setCardinality(item.getOldValue());
        return null;
    }

    public OperationWarning apply(MinCardinalityHistoryItem item) {
        OBORestriction tr = (OBORestriction)this.getRealRel(item.getRel());
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change min cardinality of unknown term relationship " + item.getRel() + " to " + item.getNewValue());
            return cwarning;
        }
        if ((tr = (OBORestriction)TermUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change min cardinality of unknown term relationship " + tr + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.setMinCardinality(item.getNewValue());
        return null;
    }

    public OperationWarning reverse(MinCardinalityHistoryItem item) {
        OBORestriction tr = (OBORestriction)this.getRealRel(item.getRel());
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change min cardinality of unknown term relationship " + item.getRel() + " to " + item.getOldValue());
            return cwarning;
        }
        if ((tr = (OBORestriction)TermUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change min cardinality of unknown term relationship " + tr + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.setMinCardinality(item.getOldValue());
        return null;
    }

    public OperationWarning apply(MaxCardinalityHistoryItem item) {
        OBORestriction tr = (OBORestriction)this.getRealRel(item.getRel());
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change min cardinality of unknown term relationship " + item.getRel() + " to " + item.getNewValue());
            return cwarning;
        }
        if ((tr = (OBORestriction)TermUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change min cardinality of unknown term relationship " + tr + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.setMaxCardinality(item.getNewValue());
        return null;
    }

    public OperationWarning reverse(MaxCardinalityHistoryItem item) {
        OBORestriction tr = (OBORestriction)this.getRealRel(item.getRel());
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change min cardinality of unknown term relationship " + item.getRel() + " to " + item.getOldValue());
            return cwarning;
        }
        if ((tr = (OBORestriction)TermUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change min cardinality of unknown term relationship " + tr + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.setMaxCardinality(item.getOldValue());
        return null;
    }

    public OperationWarning apply(CompletesHistoryItem item) {
        OBORestriction tr = (OBORestriction)this.getRealRel(item.getRel());
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change completes status of unknown term relationship " + item.getRel() + " to " + !item.getOldCompletes());
            return cwarning;
        }
        if ((tr = (OBORestriction)TermUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change completes status of unknown term relationship " + item.getRel() + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.getParent().removeChild(tr);
        tr.setCompletes(!item.getOldCompletes());
        tr.getParent().addChild(tr);
        return null;
    }

    public OperationWarning reverse(CompletesHistoryItem item) {
        HistoryItem.StringRelationship sr = (HistoryItem.StringRelationship)item.getRel().clone();
        sr.setCompletes(!item.getOldCompletes());
        OBORestriction tr = (OBORestriction)this.getRealRel(sr);
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change completes status of unknown term relationship " + item.getRel() + " back to " + item.getOldCompletes());
            return cwarning;
        }
        if ((tr = (OBORestriction)TermUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change completes status of unknown term relationship " + tr + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.getParent().removeChild(tr);
        tr.setCompletes(item.getOldCompletes());
        tr.getParent().addChild(tr);
        return null;
    }

    public OperationWarning apply(NecessarilyTrueHistoryItem item) {
        OBORestriction tr = (OBORestriction)this.getRealRel(item.getRel());
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change necessary status of unknown term relationship " + item.getRel() + " to " + !item.getOldNecessary());
            return cwarning;
        }
        OBORestriction temp = tr;
        if ((tr = (OBORestriction)TermUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change necessary status of unknown term relationship " + item.getRel() + " because it doesn't exist in " + "the ontology. realRel = " + temp + ", tr.getChild().getParents() = " + temp.getChild().getParents());
            return cwarning;
        }
        tr.setNecessarilyTrue(!item.getOldNecessary());
        return null;
    }

    public OperationWarning reverse(NecessarilyTrueHistoryItem item) {
        OBORestriction tr = (OBORestriction)this.getRealRel(item.getRel());
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change necessary status of unknown term relationship " + item.getRel() + " back to " + item.getOldNecessary());
            return cwarning;
        }
        if ((tr = (OBORestriction)TermUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change necessary status of unknown term relationship " + tr + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.setNecessarilyTrue(item.getOldNecessary());
        return null;
    }

    public OperationWarning apply(TermCopyHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not copy terms to unknown target " + item.getTarget());
        }
        HistoryItem.StringRelationship sr = (HistoryItem.StringRelationship)item.getTerm().clone();
        sr.setParent(item.getTarget());
        Link tr = this.getRealRel(sr);
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't do copy of unknown term " + sr.getChild() + " to " + target);
            return cwarning;
        }
        if (tr.getChild() == null) {
            return new OperationWarning("Couldn't do copy of unknown child " + sr.getChild() + " to " + target + " with type " + sr.getType() + ".");
        }
        if (tr.getType() == null) {
            return new OperationWarning("Couldn't do copy of " + sr.getChild() + " to " + target + " with unknown type " + sr.getType() + ".");
        }
        if (TermUtil.hasChild(target, tr)) {
            OperationWarning cwarning = new OperationWarning("Couldn't do copy of " + sr.getChild() + " to " + target + " with type " + sr.getType() + " because it already exists there; " + "children of " + target + " = " + target.getChildren());
            return cwarning;
        }
        target.addChild(tr);
        if (this.doMark()) {
            this.history.markRoots();
        }
        return null;
    }

    public OperationWarning reverse(TermCopyHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not reverse term copy from unknown target " + item.getTarget());
        }
        HistoryItem.StringRelationship sr = (HistoryItem.StringRelationship)item.getTerm().clone();
        sr.setParent(item.getTarget());
        Link tr = this.getRealRel(sr);
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't reverse copy of unknown term " + sr.getChild() + " to " + target);
            return cwarning;
        }
        if (!TermUtil.hasChild(target, tr)) {
            OperationWarning cwarning = new OperationWarning("Couldn't reverse copy of " + sr.getChild() + " to " + target + " with type " + sr.getType() + " because the " + "relationship doesn't exist.");
            return cwarning;
        }
        target.removeChild(tr);
        if (this.doMark()) {
            this.history.markRoots();
        }
        return null;
    }

    public OperationWarning apply(ObsoleteObjectHistoryItem item) {
        IdentifiedObject io = this.history.getObject(item.getTarget());
        if (io == null) {
            return new OperationWarning("Cannot obsolete unknown object " + item.getTarget());
        }
        if (!(io instanceof ObsoletableObject)) {
            return new OperationWarning("Cannot obsolete non-obsoletable object " + item.getTarget());
        }
        if (((ObsoletableObject)io).isObsolete()) {
            return new OperationWarning("Cannot obsolete already obsolete object " + io);
        }
        this.history.addObsoleteObject((ObsoletableObject)io);
        return null;
    }

    public OperationWarning reverse(ObsoleteObjectHistoryItem item) {
        IdentifiedObject io = this.history.getObject(item.getTarget());
        if (io == null) {
            return new OperationWarning("Cannot unobsolete unknown object " + item.getTarget());
        }
        if (!(io instanceof ObsoletableObject)) {
            return new OperationWarning("Cannot unobsolete non-obsoletable object " + item.getTarget());
        }
        if (!((ObsoletableObject)io).isObsolete()) {
            return new OperationWarning("Cannot unobsolete non-obsolete object " + io);
        }
        this.history.removeObsoleteObject((ObsoletableObject)io);
        return null;
    }

    public OperationWarning apply(DestroyObjectHistoryItem item) {
        IdentifiedObject io = this.history.getObject(item.getTarget());
        if (io == null) {
            return new OperationWarning("Cannot destroy unknown object " + io);
        }
        this.history.destroy(io);
        return null;
    }

    public OperationWarning reverse(DestroyObjectHistoryItem item) {
        IdentifiedObject io = item.getObject();
        if (io == null) {
            return new OperationWarning("Cannot undestroy unknown object " + io);
        }
        this.history.undestroy(io);
        return null;
    }

    public OperationWarning apply(DeleteLinkHistoryItem item) {
        HistoryItem.StringRelationship sr = item.getRel();
        Link tr = this.getRealRel(sr);
        if ((tr = TermUtil.findChildRelNoIntersection(tr, tr.getParent())) == null) {
            return new OperationWarning("Couldn't find link " + sr + " in ontology");
        }
        if (tr.getChild() == null) {
            return new OperationWarning("Can't delete link with unknown child " + sr.getChild());
        }
        if (sr.getParent() != null && tr.getParent() == null) {
            return new OperationWarning("Couldn't delete relationship with unknown parent " + sr.getParent(), OperationWarning.DANGEROUS);
        }
        if (tr.getParent() != null) {
            if (tr.getType() == null) {
                return new OperationWarning("Can't delete relationship with unknown type " + sr.getType());
            }
            if (!TermUtil.hasChild(tr.getParent(), tr)) {
                return new OperationWarning("Couldn't delete non-existant relationship " + tr);
            }
        } else {
            return new OperationWarning("Can't delete link " + tr + " with NULL parent!");
        }
        tr.getParent().removeChild(tr);
        if (this.doMark()) {
            this.history.markRoots();
        }
        return null;
    }

    public OperationWarning reverse(DeleteLinkHistoryItem item) {
        HistoryItem.StringRelationship sr = item.getRel();
        Link tr = this.getRealRel(sr);
        if (tr.getChild() == null) {
            return new OperationWarning("Can't undelete link with unknown child " + sr.getChild());
        }
        if (sr.getParent() != null && tr.getParent() == null) {
            return new OperationWarning("Couldn't undelete relationship with unknown parent " + sr.getParent(), OperationWarning.DANGEROUS);
        }
        if (tr.getParent() != null) {
            if (tr.getType() == null) {
                return new OperationWarning("Can't undelete relationship with unknown type " + sr.getType());
            }
            tr.getParent().addChild(tr);
        }
        if (this.doMark()) {
            this.history.markRoots();
        }
        return null;
    }

    public OperationWarning apply(TermMacroHistoryItem item) {
        ++this.macrodepth;
        item.lock(this.history);
        OperationWarning warning = new OperationWarning("Couldn't apply macro history item");
        boolean failure = false;
        for (int i = 0; i < item.getHistoryItemCount(); ++i) {
            OperationWarning w = this.apply(item.getHistoryItemAt(i));
            if (w == null) continue;
            System.err.println("got warning " + w + " from " + item.getHistoryItemAt(i));
            failure = true;
            warning.addWarning(w);
        }
        --this.macrodepth;
        if (this.doMark()) {
            this.history.markRoots();
        }
        if (failure) {
            return warning;
        }
        return null;
    }

    public OperationWarning reverse(TermMacroHistoryItem item) {
        ++this.macrodepth;
        OperationWarning warning = new OperationWarning("Couldn't apply macro history item");
        boolean failure = false;
        for (int i = item.getHistoryItemCount() - 1; i >= 0; --i) {
            OperationWarning w = this.reverse(item.getHistoryItemAt(i));
            if (w == null) continue;
            failure = true;
            warning.addWarning(w);
        }
        --this.macrodepth;
        if (this.doMark()) {
            this.history.markRoots();
        }
        if (failure) {
            return warning;
        }
        return null;
    }

    public OperationWarning apply(LinkTypeHistoryItem item) {
        OBOProperty type = (OBOProperty)this.getRealObject(item.getRelationshipType());
        if (type == null) {
            return new OperationWarning("Couldn't do relationship type change with missing type " + item.getRelationshipType());
        }
        HistoryItem.StringRelationship sr = item.getRel();
        Link tr = this.getRealRel(sr);
        if (tr.getParent() == null) {
            return new OperationWarning("Couldn't do relationship type change with missing parent " + sr.getParent());
        }
        if (tr.getChild() == null) {
            return new OperationWarning("Couldn't do relationship type change with missing child " + sr.getChild());
        }
        if (tr.getType() == null) {
            return new OperationWarning("Couldn't complete relationship type change with missing relationship type " + sr.getType());
        }
        if ((tr = TermUtil.findChildRelNoIntersection(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change type status of unknown term relationship " + tr + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.setType(type);
        if (this.doMark()) {
            this.history.markRoots();
        }
        return null;
    }

    public OperationWarning reverse(LinkTypeHistoryItem item) {
        HistoryItem.StringRelationship sr = item.getRel();
        OBOProperty type = (OBOProperty)this.getRealObject(sr.getType());
        if (type == null) {
            return new OperationWarning("Couldn't do relationship type change with missing type " + item.getRelationshipType());
        }
        Link tr = this.getRealRel(sr = new HistoryItem.StringRelationship(sr.getParent(), sr.getChild(), item.getRelationshipType()));
        if (tr.getParent() == null) {
            return new OperationWarning("Couldn't undo relationship type change with missing parent " + sr.getParent());
        }
        if (tr.getChild() == null) {
            return new OperationWarning("Couldn't undo relationship type change with missing child " + sr.getChild());
        }
        if (tr.getType() == null) {
            return new OperationWarning("Couldn't undo relationship type change with missing relationship type " + sr.getType());
        }
        if ((tr = TermUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't undo type change of unknown term relationship " + tr + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.setType(type);
        if (this.doMark()) {
            this.history.markRoots();
        }
        return null;
    }

    public OperationWarning apply(NameChangeHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("no term for id " + item.getTarget());
        }
        target.setName(item.getNewText());
        return null;
    }

    public OperationWarning reverse(NameChangeHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        target.setName(item.getText());
        return null;
    }

    public OperationWarning apply(NamespaceHistoryItem item) {
        String nsid;
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not change namespace of unrecognized term " + item.getTarget());
        }
        Namespace ns = null;
        if (item.getNewNamespace() != null && (ns = this.history.getNamespace(nsid = item.getNewNamespace().getID())) == null) {
            return new OperationWarning("Could not change namespace to unrecognized namespace " + nsid);
        }
        target.setNamespace(ns);
        return null;
    }

    public OperationWarning reverse(NamespaceHistoryItem item) {
        String nsid;
        LinkedObject target = this.getRealObject(item.getTarget());
        Namespace ns = null;
        if (item.getOldNamespace() != null && (ns = this.history.getNamespace(nsid = item.getOldNamespace().getID())) == null) {
            return new OperationWarning("Could not undo change of namespace to unrecognized namespace " + nsid);
        }
        target.setNamespace(ns);
        return null;
    }

    public OperationWarning apply(DefinitionChangeHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof DefinedObject)) {
            return new OperationWarning("Could not apply definition change to non definable object " + item.getTarget());
        }
        DefinedObject target = (DefinedObject)o;
        target.setDefinition(item.getNewText());
        return null;
    }

    public OperationWarning reverse(DefinitionChangeHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof DefinedObject)) {
            return new OperationWarning("Could not reverse definition change to non-definable object " + item.getTarget());
        }
        DefinedObject target = (DefinedObject)o;
        target.setDefinition(item.getText());
        return null;
    }

    public OperationWarning apply(CommentChangeHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof CommentedObject)) {
            return new OperationWarning("Could not apply comment change to non-commentable object " + item.getTarget());
        }
        CommentedObject target = (CommentedObject)o;
        target.setComment(item.getNewText());
        return null;
    }

    public OperationWarning reverse(CommentChangeHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof CommentedObject)) {
            return new OperationWarning("Could not reverse comment change to non-commentable object " + item.getTarget());
        }
        CommentedObject target = (CommentedObject)o;
        target.setComment(item.getText());
        return null;
    }

    public OperationWarning apply(CategoryChangeHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof CategorizedObject)) {
            return new OperationWarning("Could not apply category change to non-categorizable object " + item.getTarget());
        }
        CategorizedObject target = (CategorizedObject)o;
        TermCategory cat = this.history.getCategory(item.getCategory());
        if (item.isDel()) {
            target.removeCategory(cat);
        } else {
            target.addCategory(cat);
        }
        return null;
    }

    public OperationWarning reverse(CategoryChangeHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof CategorizedObject)) {
            return new OperationWarning("Could not reverse category change to non-categorizable object " + item.getTarget());
        }
        CategorizedObject target = (CategorizedObject)o;
        TermCategory cat = this.history.getCategory(item.getCategory());
        if (item.isDel()) {
            target.addCategory(cat);
        } else {
            target.removeCategory(cat);
        }
        return null;
    }

    public OperationWarning apply(ChangeSynScopeHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof SynonymedObject)) {
            return new OperationWarning("Could not change synonym scope in non-synonymable object " + item.getTarget());
        }
        SynonymedObject target = (SynonymedObject)o;
        Synonym s = TermUtil.findSynonym(target, item.getSynonym());
        if (s == null) {
            return new OperationWarning("Couldn't modify non-existant synonym " + item.getSynonym());
        }
        s.setScope(item.getNewScope());
        return null;
    }

    public OperationWarning reverse(ChangeSynScopeHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof SynonymedObject)) {
            return new OperationWarning("Could not change synonym scope in non-synonymable object " + item.getTarget());
        }
        SynonymedObject target = (SynonymedObject)o;
        Synonym s = TermUtil.findSynonym(target, item.getSynonym());
        if (s == null) {
            return new OperationWarning("Couldn't modify non-existant synonym " + item.getSynonym());
        }
        s.setScope(item.getOldScope());
        return null;
    }

    public OperationWarning apply(ChangeSynCategoryHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof SynonymedObject)) {
            return new OperationWarning("Could not change synonym category in non-synonymable object " + item.getTarget());
        }
        SynonymedObject target = (SynonymedObject)o;
        Synonym s = TermUtil.findSynonym(target, item.getSynonym());
        if (s == null) {
            return new OperationWarning("Couldn't modify non-existant synonym " + item.getSynonym());
        }
        SynonymCategory cat = null;
        if (item.getNewCategory() != null && (cat = this.history.getSynonymCategory(item.getNewCategory())) == null) {
            return new OperationWarning("Couldn't find category " + item.getNewCategory());
        }
        s.setSynonymCategory(cat);
        return null;
    }

    public OperationWarning reverse(ChangeSynCategoryHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof SynonymedObject)) {
            return new OperationWarning("Could not change synonym category in non-synonymable object " + item.getTarget());
        }
        SynonymedObject target = (SynonymedObject)o;
        Synonym s = TermUtil.findSynonym(target, item.getSynonym());
        if (s == null) {
            return new OperationWarning("Couldn't modify non-existant synonym " + item.getSynonym());
        }
        SynonymCategory cat = null;
        if (item.getOldCategory() != null && (cat = this.history.getSynonymCategory(item.getOldCategory())) == null) {
            return new OperationWarning("Couldn't find category " + item.getOldCategory());
        }
        s.setSynonymCategory(cat);
        return null;
    }

    public OperationWarning apply(AddConsiderHistoryItem item) {
        LinkedObject o = this.getRealObject(item.getTarget());
        if (o == null) {
            return new OperationWarning("Could not add consider term to unknown target " + item.getTarget());
        }
        if (!(o instanceof ObsoletableObject)) {
            return new OperationWarning("Could not add consider term to non-obsoletable term " + o);
        }
        ObsoletableObject target = (ObsoletableObject)((Object)o);
        LinkedObject consider = this.getRealObject(item.getConsider());
        if (consider == null) {
            return new OperationWarning("Could not add unknown consider term " + item.getConsider() + " to " + target);
        }
        if (!(consider instanceof ObsoletableObject)) {
            return new OperationWarning("Could not add non-obsoletable term " + consider + " as consider term for " + target);
        }
        target.addConsiderReplacement((ObsoletableObject)((Object)consider));
        return null;
    }

    public OperationWarning reverse(AddConsiderHistoryItem item) {
        LinkedObject o = this.getRealObject(item.getTarget());
        if (o == null) {
            return new OperationWarning("Could not reverse addition of consider term to unknown target " + item.getTarget());
        }
        if (!(o instanceof ObsoletableObject)) {
            return new OperationWarning("Could not reverse addition of consider term to non-obsoletable term " + o);
        }
        ObsoletableObject target = (ObsoletableObject)((Object)o);
        LinkedObject consider = this.getRealObject(item.getConsider());
        if (consider == null) {
            return new OperationWarning("Could not reverse addition of unknown consider term " + item.getConsider() + " to " + target);
        }
        if (!(consider instanceof ObsoletableObject)) {
            return new OperationWarning("Could not reverse addition of non-obsoletable term " + consider + " as consider term for " + target);
        }
        target.removeConsiderReplacement((ObsoletableObject)((Object)consider));
        return null;
    }

    public OperationWarning apply(RemoveConsiderHistoryItem item) {
        LinkedObject o = this.getRealObject(item.getTarget());
        if (o == null) {
            return new OperationWarning("Could not rremove consider term from unknown target " + item.getTarget());
        }
        if (!(o instanceof ObsoletableObject)) {
            return new OperationWarning("Could not remove consider term from non-obsoletable term " + o);
        }
        ObsoletableObject target = (ObsoletableObject)((Object)o);
        LinkedObject consider = this.getRealObject(item.getConsider());
        if (consider == null) {
            return new OperationWarning("Could not remove unknown consider term " + item.getConsider() + " from " + target);
        }
        if (!(consider instanceof ObsoletableObject)) {
            return new OperationWarning("Could not remove non-obsoletable term " + consider + " as consider term for " + target);
        }
        target.removeConsiderReplacement((ObsoletableObject)((Object)consider));
        return null;
    }

    public OperationWarning reverse(RemoveConsiderHistoryItem item) {
        LinkedObject o = this.getRealObject(item.getTarget());
        if (o == null) {
            return new OperationWarning("Could not remove consider term from unknown target " + item.getTarget());
        }
        if (!(o instanceof ObsoletableObject)) {
            return new OperationWarning("Could not remove consider term from non-obsoletable term " + o);
        }
        ObsoletableObject target = (ObsoletableObject)((Object)o);
        LinkedObject consider = this.getRealObject(item.getConsider());
        if (consider == null) {
            return new OperationWarning("Could not remove unknown consider term " + item.getConsider() + " from " + target);
        }
        if (!(consider instanceof ObsoletableObject)) {
            return new OperationWarning("Could not remove non-obsoletable term " + consider + " as consider term for " + target);
        }
        target.addConsiderReplacement((ObsoletableObject)((Object)consider));
        return null;
    }

    public OperationWarning apply(AddSynonymHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof SynonymedObject)) {
            return new OperationWarning("Could not add synonym to non-synonymable object " + item.getTarget());
        }
        SynonymedObject target = (SynonymedObject)o;
        Synonym s = this.history.getObjectFactory().createSynonym(item.getSynonym(), 0);
        if (TermUtil.findSynonym(target, s) != null) {
            return new OperationWarning("Could not add synonym " + s + " to " + item.getTarget() + " because that synonym has already been added");
        }
        target.addSynonym(s);
        return null;
    }

    public OperationWarning reverse(AddSynonymHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof SynonymedObject)) {
            return new OperationWarning("Could not remove synonym from non-synonymable object " + item.getTarget());
        }
        SynonymedObject target = (SynonymedObject)o;
        Synonym s = TermUtil.findSynonym(target, item.getSynonym());
        if (s == null) {
            return new OperationWarning("Could not delete non-existant synonym " + s + " of " + target);
        }
        target.removeSynonym(s);
        return null;
    }

    public OperationWarning reverse(DelSynonymHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof SynonymedObject)) {
            return new OperationWarning("Could not add synonym to non-synonymable object " + item.getTarget());
        }
        SynonymedObject target = (SynonymedObject)o;
        target.addSynonym(this.history.getObjectFactory().createSynonym(item.getSynonym(), 0));
        return null;
    }

    public OperationWarning apply(DelSynonymHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof SynonymedObject)) {
            return new OperationWarning("Could not reverse synonym change to non-synonymable object " + item.getTarget());
        }
        SynonymedObject target = (SynonymedObject)o;
        Synonym s = TermUtil.findSynonym(target, item.getSynonym());
        if (s == null) {
            return new OperationWarning("Could not delete non-existant synonym " + s + " of " + target);
        }
        target.removeSynonym(s);
        return null;
    }

    public OperationWarning reverse(HistoryItem item) {
        this.history.setNeedsSave(true);
        if (item instanceof CreateObjectHistoryItem) {
            return this.reverse((CreateObjectHistoryItem)item);
        }
        if (item instanceof TermCopyHistoryItem) {
            return this.reverse((TermCopyHistoryItem)item);
        }
        if (item instanceof DeleteLinkHistoryItem) {
            return this.reverse((DeleteLinkHistoryItem)item);
        }
        if (item instanceof DestroyObjectHistoryItem) {
            return this.reverse((DestroyObjectHistoryItem)item);
        }
        if (item instanceof ObsoleteObjectHistoryItem) {
            return this.reverse((ObsoleteObjectHistoryItem)item);
        }
        if (item instanceof TermMacroHistoryItem) {
            return this.reverse((TermMacroHistoryItem)item);
        }
        if (item instanceof LinkTypeHistoryItem) {
            return this.reverse((LinkTypeHistoryItem)item);
        }
        if (item instanceof NamespaceHistoryItem) {
            return this.reverse((NamespaceHistoryItem)item);
        }
        if (item instanceof NameChangeHistoryItem) {
            return this.reverse((NameChangeHistoryItem)item);
        }
        if (item instanceof DefinitionChangeHistoryItem) {
            return this.reverse((DefinitionChangeHistoryItem)item);
        }
        if (item instanceof AddSynonymHistoryItem) {
            return this.reverse((AddSynonymHistoryItem)item);
        }
        if (item instanceof DelSynonymHistoryItem) {
            return this.reverse((DelSynonymHistoryItem)item);
        }
        if (item instanceof TermCategoryHistoryItem) {
            return this.reverse((TermCategoryHistoryItem)item);
        }
        if (item instanceof SynonymCategoryHistoryItem) {
            return this.reverse((SynonymCategoryHistoryItem)item);
        }
        if (item instanceof ChangeSynCategoryHistoryItem) {
            return this.reverse((ChangeSynCategoryHistoryItem)item);
        }
        if (item instanceof ChangeSynScopeHistoryItem) {
            return this.reverse((ChangeSynScopeHistoryItem)item);
        }
        if (item instanceof TermNamespaceHistoryItem) {
            return this.reverse((TermNamespaceHistoryItem)item);
        }
        if (item instanceof AddDbxrefHistoryItem) {
            return this.reverse((AddDbxrefHistoryItem)item);
        }
        if (item instanceof DelDbxrefHistoryItem) {
            return this.reverse((DelDbxrefHistoryItem)item);
        }
        if (item instanceof CommentChangeHistoryItem) {
            return this.reverse((CommentChangeHistoryItem)item);
        }
        if (item instanceof CategoryChangeHistoryItem) {
            return this.reverse((CategoryChangeHistoryItem)item);
        }
        if (item instanceof SecondaryIDHistoryItem) {
            return this.reverse((SecondaryIDHistoryItem)item);
        }
        if (item instanceof NecessarilyTrueHistoryItem) {
            return this.reverse((NecessarilyTrueHistoryItem)item);
        }
        if (item instanceof InverseNecHistoryItem) {
            return this.reverse((InverseNecHistoryItem)item);
        }
        if (item instanceof CardinalityHistoryItem) {
            return this.reverse((CardinalityHistoryItem)item);
        }
        if (item instanceof CompletesHistoryItem) {
            return this.reverse((CompletesHistoryItem)item);
        }
        if (item instanceof TRNamespaceHistoryItem) {
            return this.reverse((TRNamespaceHistoryItem)item);
        }
        if (item instanceof RangeHistoryItem) {
            return this.reverse((RangeHistoryItem)item);
        }
        if (item instanceof DomainHistoryItem) {
            return this.reverse((DomainHistoryItem)item);
        }
        if (item instanceof AddReplacementHistoryItem) {
            return this.reverse((AddReplacementHistoryItem)item);
        }
        if (item instanceof RemoveReplacementHistoryItem) {
            return this.reverse((RemoveReplacementHistoryItem)item);
        }
        if (item instanceof CyclicHistoryItem) {
            return this.reverse((CyclicHistoryItem)item);
        }
        if (item instanceof SymmetricHistoryItem) {
            return this.reverse((SymmetricHistoryItem)item);
        }
        if (item instanceof TransitiveHistoryItem) {
            return this.reverse((TransitiveHistoryItem)item);
        }
        if (item instanceof CardinalityHistoryItem) {
            return this.reverse((CardinalityHistoryItem)item);
        }
        if (item instanceof MinCardinalityHistoryItem) {
            return this.reverse((MinCardinalityHistoryItem)item);
        }
        if (item instanceof MaxCardinalityHistoryItem) {
            return this.reverse((MaxCardinalityHistoryItem)item);
        }
        if (item instanceof AddConsiderHistoryItem) {
            return this.reverse((AddConsiderHistoryItem)item);
        }
        if (item instanceof RemoveConsiderHistoryItem) {
            return this.reverse((RemoveConsiderHistoryItem)item);
        }
        if (item instanceof AddPropertyValueHistoryItem) {
            return this.reverse((AddPropertyValueHistoryItem)item);
        }
        if (item instanceof DeletePropertyValueHistoryItem) {
            return this.reverse((DeletePropertyValueHistoryItem)item);
        }
        return new OperationWarning("Unknown history item found!");
    }
}

