/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.impl;

import org.geneontology.oboedit.datamodel.Datatype;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.impl.SimpleDatatype;

public class DecimalDatatype
extends SimpleDatatype {
    private static final long serialVersionUID = 8806419242226244891L;

    public String getID() {
        return "xsd:decimal";
    }

    public String getName() {
        return this.getID();
    }

    public String getComment() {
        return "Represents a real number";
    }

    public Namespace getNamespace() {
        return null;
    }

    public boolean isAbstract() {
        return false;
    }

    public Datatype getSupertype() {
        return Datatype.SIMPLE_TYPE;
    }

    public boolean isLegalValue(String string) {
        if (string == null) {
            return false;
        }
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public Object getValue(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new Double(string);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Illegal decimal value " + string);
        }
    }

    public String getString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Integer) {
            return o.toString();
        }
        throw new IllegalArgumentException("DecimalDatatype can only convert values of type java.lang.Double or java.lang.Float");
    }
}

