/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.geneontology.oboedit.datamodel.DanglingObject;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.NestedValue;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.PropertyValue;
import org.geneontology.oboedit.datamodel.Relationship;
import org.geneontology.oboedit.datamodel.Type;

public class DanglingObjectImpl
implements DanglingObject {
    private static final long serialVersionUID = -5373912147333845047L;
    protected Set parents = new HashSet();
    protected Set children = new HashSet();
    protected String id;
    protected String name;
    protected boolean root;

    public DanglingObjectImpl(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.id;
    }

    public boolean isAnonymous() {
        return false;
    }

    public Type getType() {
        return OBOClass.OBO_UNKNOWN;
    }

    public boolean isBuiltIn() {
        return false;
    }

    public Set getParents() {
        return this.parents;
    }

    public Set getChildren() {
        return this.children;
    }

    public boolean isRoot() {
        return this.root;
    }

    public boolean rootHint() {
        return false;
    }

    public void addChild(Relationship tr) {
        this.atomicAddChild(tr);
        if (tr instanceof Link) {
            ((Link)tr).getChild().atomicAddParent(tr);
        }
    }

    public void removeChild(Relationship tr) {
        this.atomicRemoveChild(tr);
        if (tr instanceof Link) {
            ((Link)tr).getChild().atomicRemoveParent(tr);
        }
    }

    public void addParent(Relationship tr) {
        this.atomicAddParent(tr);
        if (tr instanceof Link) {
            ((Link)tr).getParent().atomicAddChild(tr);
        }
    }

    public void removeParent(Relationship tr) {
        this.atomicRemoveParent(tr);
        if (tr instanceof Link) {
            ((Link)tr).getParent().atomicRemoveChild(tr);
        }
    }

    public void atomicAddChild(Relationship tr) {
        this.children.add(tr);
    }

    public void atomicRemoveChild(Relationship tr) {
        this.children.remove(tr);
    }

    public void atomicAddParent(Relationship tr) {
        this.parents.add(tr);
    }

    public void atomicRemoveParent(Relationship tr) {
        this.parents.remove(tr);
    }

    public Namespace getNamespace() {
        return null;
    }

    public NestedValue getTypeExtension() {
        return null;
    }

    public NestedValue getNameExtension() {
        return null;
    }

    public NestedValue getNamespaceExtension() {
        return null;
    }

    public NestedValue getIDExtension() {
        return null;
    }

    public NestedValue getAnonymousExtension() {
        return null;
    }

    public Set getPropertyValues() {
        return Collections.EMPTY_SET;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("Dangling cannot be given names");
    }

    public void setNamespace(Namespace name) {
        throw new UnsupportedOperationException("Dangling cannot be given names");
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public void setIsAnonymous(boolean isAnonymous) {
        throw new UnsupportedOperationException("Dangling objects cannot be anonymous");
    }

    public void setTypeExtension(NestedValue value) {
        throw new UnsupportedOperationException("Dangling objects can never have extension information");
    }

    public void setNameExtension(NestedValue value) {
        throw new UnsupportedOperationException("Dangling objects can never have extension information");
    }

    public void setNamespaceExtension(NestedValue nv) {
        throw new UnsupportedOperationException("Dangling objects can never have extension information");
    }

    public void setAnonymousExtension(NestedValue nv) {
        throw new UnsupportedOperationException("Dangling objects can never have extension information");
    }

    public void setIDExtension(NestedValue nv) {
        throw new UnsupportedOperationException("Dangling objects can never have extension information");
    }

    public void addPropertyValue(PropertyValue pv) {
        throw new UnsupportedOperationException("Dangling objects have no editable property values");
    }

    public void removePropertyValue(PropertyValue pv) {
        throw new UnsupportedOperationException("Dangling objects have no editable property values");
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof IdentifiedObject) {
            return ((IdentifiedObject)o).getID().equals(this.getID());
        }
        return false;
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public String toString() {
        return "dangling->" + this.getID();
    }
}

