/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.history;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.OperationWarning;
import org.geneontology.oboedit.datamodel.Synonym;
import org.geneontology.oboedit.datamodel.SynonymedObject;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.AddDbxrefHistoryItem;
import org.geneontology.oboedit.datamodel.history.AddSynonymHistoryItem;
import org.geneontology.oboedit.datamodel.history.ChangeSynScopeHistoryItem;
import org.geneontology.oboedit.datamodel.history.CommentChangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.DefinitionChangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.DeleteLinkHistoryItem;
import org.geneontology.oboedit.datamodel.history.DestroyObjectHistoryItem;
import org.geneontology.oboedit.datamodel.history.SecondaryIDHistoryItem;
import org.geneontology.oboedit.datamodel.history.SubclassedMacroHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermCopyHistoryItem;
import org.geneontology.oboedit.datamodel.impl.DefaultObjectFactory;
import org.geneontology.oboedit.datamodel.impl.OBORestrictionImpl;
import org.geneontology.util.ObjectUtil;

public class TermMergeHistoryItem
extends SubclassedMacroHistoryItem {
    private static final long serialVersionUID = 153351404511268849L;
    protected String slave;
    protected List graphEdits = new Vector();

    public TermMergeHistoryItem(OBOClass masterNode, OBOClass slaveNode) {
        this(masterNode.getID(), slaveNode.getID());
    }

    public TermMergeHistoryItem() {
        this((String)null, null);
    }

    public TermMergeHistoryItem(String masterNode, String slaveNode) {
        super("merge");
        this.setTarget(masterNode);
        this.type = 1;
        this.slave = slaveNode;
    }

    public List getGraphEditList() {
        return Collections.singletonList(new HistoryItem.GraphOperation(0));
    }

    public int hashCode() {
        return TermMergeHistoryItem.getHash(this.target) ^ TermMergeHistoryItem.getHash(this.slave);
    }

    public boolean equals(Object o) {
        if (!(o instanceof TermMergeHistoryItem)) {
            return false;
        }
        TermMergeHistoryItem item = (TermMergeHistoryItem)o;
        return ObjectUtil.equals((Object)this.target, (Object)item.getTarget()) && ObjectUtil.equals((Object)this.slave, (Object)item.getSlave());
    }

    protected OperationWarning getItems(OBOSession history, Vector out) {
        OBOClass masterNode = history.getTerm(this.target);
        OBOClass slaveNode = history.getTerm(this.slave);
        if (masterNode == null) {
            return new OperationWarning("Could not merge unrecognized node " + this.target);
        }
        if (slaveNode == null) {
            return new OperationWarning("Could not merge unrecognized node " + this.slave);
        }
        Set targetDescendants = TermUtil.getDescendants(masterNode, true);
        Set targetAncestors = TermUtil.getAncestors(masterNode, true);
        Iterator it = slaveNode.getChildren().iterator();
        while (it.hasNext()) {
            Link tr = (Link)it.next();
            LinkedObject slaveChild = tr.getChild();
            OBORestrictionImpl newtr = new OBORestrictionImpl(tr.getParent(), tr.getType(), slaveChild);
            out.add(new DeleteLinkHistoryItem(tr));
            if (targetAncestors.contains(slaveChild) || TermUtil.hasChild(masterNode, tr)) continue;
            out.add(new TermCopyHistoryItem(masterNode, slaveChild, tr.getType()));
        }
        Vector slaveParents = new Vector();
        slaveParents.addAll(slaveNode.getParents());
        for (int i = 0; i < slaveParents.size(); ++i) {
            Link tr = (Link)slaveParents.get(i);
            LinkedObject slaveParent = tr.getParent();
            OBORestrictionImpl newtr = new OBORestrictionImpl((LinkedObject)masterNode, tr.getType(), tr.getParent());
            out.add(new DeleteLinkHistoryItem(tr));
            if (targetDescendants.contains(slaveParent) || TermUtil.hasChild(tr.getParent(), newtr)) continue;
            out.add(new TermCopyHistoryItem(tr.getParent(), masterNode, tr.getType()));
        }
        out.add(new DestroyObjectHistoryItem(slaveNode));
        out.add(new SecondaryIDHistoryItem(masterNode, slaveNode.getID(), false));
        it = slaveNode.getSecondaryIDs().iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            out.add(new SecondaryIDHistoryItem(masterNode, id, false));
        }
        it = slaveNode.getSynonyms().iterator();
        while (it.hasNext()) {
            Synonym s = (Synonym)it.next();
            Synonym masters = TermUtil.findSynonym((SynonymedObject)masterNode, s.getText());
            if (masters == null) {
                out.add(new AddSynonymHistoryItem(masterNode.getID(), s.getText()));
                out.add(new ChangeSynScopeHistoryItem(masterNode.getID(), s.getText(), 0, s.getScope()));
                masters = DefaultObjectFactory.getFactory().createSynonym(s.getText(), 0);
            }
            Iterator it2 = s.getDbxrefs().iterator();
            while (it2.hasNext()) {
                Dbxref ref = (Dbxref)it2.next();
                if (masters.getDbxrefs().contains(ref)) continue;
                out.add(new AddDbxrefHistoryItem(masterNode.getID(), ref, false, masters.getText()));
            }
        }
        it = slaveNode.getDbxrefs().iterator();
        while (it.hasNext()) {
            Dbxref ref = (Dbxref)it.next();
            if (masterNode.getDbxrefs().contains(ref)) continue;
            out.add(new AddDbxrefHistoryItem(masterNode.getID(), ref, false, null));
        }
        Synonym s = TermUtil.findSynonym((SynonymedObject)masterNode, slaveNode.getName());
        if (s == null) {
            out.add(new AddSynonymHistoryItem(masterNode.getID(), slaveNode.getName()));
            out.add(new ChangeSynScopeHistoryItem(masterNode.getID(), slaveNode.getName(), 0, 1));
        }
        String newDef = masterNode.getDefinition().length() == 0 ? slaveNode.getDefinition() : (slaveNode.getDefinition().length() == 0 ? masterNode.getDefinition() : "MERGED DEFINITION:\nTARGET DEFINITION: " + masterNode.getDefinition() + "\n" + "--------------------\n" + "SOURCE DEFINITION: " + slaveNode.getDefinition());
        String newComment = masterNode.getComment().length() == 0 ? slaveNode.getComment() : (slaveNode.getComment().length() == 0 ? masterNode.getComment() : "MERGED COMMENT:\nTARGET COMMENT: " + masterNode.getComment() + "\n" + "--------------------\n" + "SOURCE COMMENT: " + slaveNode.getComment());
        out.add(new DefinitionChangeHistoryItem(masterNode, newDef));
        out.add(new CommentChangeHistoryItem(masterNode, newComment));
        return null;
    }

    public String getShortName() {
        return "merge";
    }

    public String getMaster() {
        return this.target;
    }

    public void setSlave(String slave) {
        this.slave = slave;
    }

    public String getSlave() {
        return this.slave;
    }

    public String toString() {
        return "Merged " + this.slave + " into " + this.target;
    }
}

