/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.history;

import java.util.AbstractList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.DefaultHistoryList;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.OperationWarning;
import org.geneontology.util.ObjectUtil;

public class TermMacroHistoryItem
extends HistoryItem {
    private static final long serialVersionUID = -9191451800260864200L;
    protected Vector historyItems = new Vector();
    protected String description;
    protected Vector rels;
    protected String result;
    protected List list = new MacroItemList();
    protected boolean locked = false;

    public TermMacroHistoryItem() {
        this(null);
    }

    public TermMacroHistoryItem(String description) {
        this.type = 8;
        this.description = description;
        this.rels = new Vector();
    }

    public List getGraphEditList() {
        Vector v = new Vector();
        for (int i = 0; i < this.historyItems.size(); ++i) {
            HistoryItem item = (HistoryItem)this.historyItems.get(i);
            v.addAll(item.getGraphEditList());
        }
        return v;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TermMacroHistoryItem)) {
            return false;
        }
        TermMacroHistoryItem item = (TermMacroHistoryItem)o;
        if (this.getHistoryItemCount() != item.getHistoryItemCount()) {
            return false;
        }
        for (int i = 0; i < this.getHistoryItemCount(); ++i) {
            HistoryItem item2 = this.getHistoryItemAt(i);
            HistoryItem item3 = item.getHistoryItemAt(i);
            if (ObjectUtil.equals((Object)item3, (Object)item2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int out = 0;
        for (int i = 0; i < this.getHistoryItemCount(); ++i) {
            HistoryItem item = this.getHistoryItemAt(i);
            out ^= item.hashCode();
        }
        return out;
    }

    public List getHistoryList() {
        return this.list;
    }

    public String getShortName() {
        return this.description;
    }

    public void setTarget(OBOClass target) {
        this.setTarget(target.getID());
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public void setResult(OBOClass term) {
        this.result = term.getID();
    }

    public String getResult() {
        return this.result;
    }

    public Vector getSources() {
        return this.rels;
    }

    public void setSources(TreePath[] paths) {
        for (int i = 0; i < paths.length; ++i) {
            Link tr = (Link)paths[i].getLastPathComponent();
            this.rels.add(HistoryItem.createStringRelationship(tr));
        }
    }

    public void setSource(Link tr) {
        Vector<Link> rels = new Vector<Link>();
        rels.add(tr);
        this.setSources(rels);
    }

    public void setSources(Vector rels) {
        Vector<HistoryItem.StringRelationship> out = new Vector<HistoryItem.StringRelationship>();
        for (int i = 0; i < rels.size(); ++i) {
            Link tr = (Link)rels.get(i);
            out.add(HistoryItem.createStringRelationship(tr));
        }
        this.rels = out;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getHistoryItemCount() {
        return this.historyItems.size();
    }

    public HistoryItem getHistoryItemAt(int index) {
        return (HistoryItem)this.historyItems.elementAt(index);
    }

    public void setHistoryItems(Vector items) {
        if (this.locked) {
            throw new IllegalStateException("Cannot modify a locked macro history item");
        }
        this.historyItems = items;
    }

    public OperationWarning lock(OBOSession history) {
        boolean failure = false;
        OperationWarning warning = new OperationWarning("Couldn't lock macro history item " + this.toString());
        for (int i = 0; i < this.historyItems.size(); ++i) {
            OperationWarning ow;
            HistoryItem item = (HistoryItem)this.historyItems.get(i);
            if (!(item instanceof TermMacroHistoryItem) || (ow = ((TermMacroHistoryItem)item).lock(history)) == null) continue;
            failure = true;
            warning.addWarning(ow);
        }
        if (failure) {
            return warning;
        }
        this.locked = true;
        return null;
    }

    public Set getEditedNodes() {
        int i;
        this.edited = new HashSet();
        if (this.target != null) {
            this.edited.add(this.target);
        }
        if (this.result != null) {
            this.edited.add(this.result);
        }
        for (i = 0; i < this.rels.size(); ++i) {
            HistoryItem.StringRelationship sr = (HistoryItem.StringRelationship)this.rels.get(i);
            this.edited.add(sr.getChild());
            this.edited.add(sr.getParent());
        }
        for (i = 0; i < this.historyItems.size(); ++i) {
            this.edited.addAll(((HistoryItem)this.historyItems.get(i)).getEditedNodes());
        }
        return this.edited;
    }

    public void setHistoryList(HistoryList list) {
        Iterator it = list.getHistoryItems();
        while (it.hasNext()) {
            HistoryItem item = (HistoryItem)it.next();
            this.addHistoryItem(item);
        }
    }

    public void addHistoryItem(HistoryItem item) {
        if (this.locked) {
            throw new IllegalStateException("Cannot modify a locked macro history item");
        }
        this.historyItems.add(item);
    }

    public void removeHistoryItem(HistoryItem item) {
        if (this.locked) {
            throw new IllegalStateException("Cannot modify a locked macro history item");
        }
        this.historyItems.remove(item);
    }

    public String toString() {
        return this.description != null ? this.description + " (macro)" : "unnamed macro";
    }

    public HistoryList forwardID(String oldID, Collection newIDs) {
        HistoryList out = null;
        Iterator it = this.historyItems.iterator();
        int i = 0;
        while (it.hasNext()) {
            HistoryItem item = (HistoryItem)it.next();
            HistoryList itemList = item.forwardID(oldID, newIDs);
            if (itemList == null) {
                if (out != null) {
                    out.addItem(item);
                }
            } else {
                if (out == null) {
                    out = new DefaultHistoryList();
                    for (int j = 0; j < i; ++j) {
                        out.addItem((HistoryItem)this.historyItems.get(j));
                    }
                }
                Iterator it2 = itemList.getHistoryItems();
                while (it2.hasNext()) {
                    out.addItem((HistoryItem)it2.next());
                }
            }
            ++i;
        }
        return out;
    }

    protected class MacroItemList
    extends AbstractList {
        protected MacroItemList() {
        }

        public int size() {
            return TermMacroHistoryItem.this.getHistoryItemCount();
        }

        public Object get(int index) {
            return TermMacroHistoryItem.this.getHistoryItemAt(index);
        }
    }
}

