/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel;

import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.util.DiskCachedList;

public class DefaultHistoryList
implements HistoryList,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String user;
    protected Date date;
    protected String version;
    protected boolean isActive;
    protected String comment;
    protected String title;
    protected List historyList = new Vector();
    protected List warnings = new Vector();
    protected boolean diskCacheHistory = false;

    public DefaultHistoryList() {
        this.date = new Date();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List getWarnings() {
        return this.warnings;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setItems(Collection c) {
        this.historyList.addAll(c);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Iterator getHistoryItems() {
        return this.historyList.iterator();
    }

    public HistoryItem getItemAt(int index) {
        return (HistoryItem)this.historyList.get(index);
    }

    public int getIndex(HistoryItem item) {
        return this.historyList.indexOf(item);
    }

    public int size() {
        return this.historyList.size();
    }

    public void addItem(HistoryItem item) {
        this.historyList.add(item);
    }

    public void setHistoryList(List historyList) {
        if (this.diskCacheHistory) {
            try {
                historyList = new DiskCachedList();
            }
            catch (IOException ex) {
                historyList = new Vector();
            }
        } else {
            this.historyList = new Vector();
        }
        this.historyList.addAll(historyList);
    }

    public List getHistoryList() {
        return this.historyList;
    }

    public HistoryItem popItem() {
        return (HistoryItem)this.historyList.remove(this.historyList.size() - 1);
    }

    public HistoryItem peekItem() {
        return (HistoryItem)this.historyList.get(this.historyList.size() - 1);
    }

    public int indexOfItem(HistoryItem item) {
        return this.historyList.indexOf(item);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        if (this.isActive()) {
            return "Active history";
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("hh:mm aaa, MMMMM dd, yyyy");
            return "Saved by " + this.user + " at " + format.format(this.date);
        }
        catch (Exception e) {
            return "History";
        }
    }

    public String toString() {
        return this.getTitle();
    }

    public HistoryList forwardID(String oldID, Collection newIDs) {
        HistoryList out = null;
        Iterator it = this.historyList.iterator();
        int i = 0;
        while (it.hasNext()) {
            HistoryItem item = (HistoryItem)it.next();
            HistoryList itemList = item.forwardID(oldID, newIDs);
            if (itemList == null) {
                if (out != null) {
                    out.addItem(item);
                }
            } else {
                if (out == null) {
                    out = new DefaultHistoryList();
                    for (int j = 0; j < i; ++j) {
                        out.addItem((HistoryItem)this.historyList.get(j));
                    }
                }
                Iterator it2 = itemList.getHistoryItems();
                while (it2.hasNext()) {
                    out.addItem((HistoryItem)it2.next());
                }
            }
            ++i;
        }
        return out;
    }
}

