/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.dataadapter;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.geneontology.dataadapter.AdapterConfiguration;
import org.geneontology.dataadapter.CancelledAdapterException;
import org.geneontology.dataadapter.DataAdapterException;
import org.geneontology.dataadapter.DataAdapterUI;
import org.geneontology.dataadapter.FileAdapterConfiguration;
import org.geneontology.dataadapter.FileAdapterUI;
import org.geneontology.dataadapter.IOOperation;
import org.geneontology.io.IOUtil;
import org.geneontology.io.ProgressableInputStream;
import org.geneontology.oboedit.dataadapter.OBOEditAdapter;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.util.ProgressEvent;
import org.geneontology.util.ProgressListener;
import org.geneontology.util.ReusableProgressEvent;

public class SerialAdapter
implements OBOEditAdapter {
    protected String path;
    protected AdapterConfiguration config;
    protected ProgressableInputStream pfis;
    protected boolean cancelled = false;
    protected List listeners = new Vector();

    public void addProgressListener(ProgressListener listener) {
        this.listeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.listeners.remove(listener);
    }

    public void fireProgressEvent(ProgressEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ProgressListener pl = (ProgressListener)this.listeners.get(i);
            pl.progressMade(e);
        }
    }

    public DataAdapterUI getPreferredUI() {
        FileAdapterUI ui = new FileAdapterUI();
        ui.setFont(Controller.getController().getDefaultFont());
        ui.setButtonColor(Preferences.defaultButtonColor(), Color.black);
        return ui;
    }

    public void cancel() {
        try {
            this.cancelled = true;
            if (this.pfis != null) {
                this.pfis.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public AdapterConfiguration getConfiguration() {
        return this.config;
    }

    public Object doOperation(IOOperation op, AdapterConfiguration oldconfig, Object o) throws DataAdapterException {
        this.config = oldconfig;
        this.cancelled = false;
        if (op.equals(IOOperation.READ)) {
            FileAdapterConfiguration config;
            if (oldconfig instanceof FileAdapterConfiguration && (config = (FileAdapterConfiguration)oldconfig).getReadPaths().size() == 1) {
                this.path = (String)config.getReadPaths().iterator().next();
                try {
                    return this.getRoot();
                }
                catch (DataAdapterException ex) {
                    if (this.cancelled) {
                        throw new CancelledAdapterException();
                    }
                    throw ex;
                }
            }
            throw new DataAdapterException("Bad configuration");
        }
        if (op.equals(IOOperation.WRITE)) {
            if (oldconfig instanceof FileAdapterConfiguration) {
                FileAdapterConfiguration config = (FileAdapterConfiguration)oldconfig;
                this.path = config.getWritePath();
                this.write((OBOSession)o);
                return o;
            }
            throw new DataAdapterException("Bad configuration");
        }
        return null;
    }

    public String getID() {
        return "OBOEDIT:Serial";
    }

    public String getName() {
        return "OBO-Edit Serial Adapter";
    }

    public IOOperation[] getSupportedOperations() {
        IOOperation[] supported = new IOOperation[]{IOOperation.WRITE, IOOperation.READ};
        return supported;
    }

    public OBOSession getRoot() throws DataAdapterException {
        try {
            this.pfis = IOUtil.getProgressableStream((String)this.path);
            this.pfis.addProgressListener(new ProgressListener(){

                public void progressMade(ProgressEvent e) {
                    SerialAdapter.this.fireProgressEvent(e);
                }
            });
            ZipInputStream zipstream = new ZipInputStream(new BufferedInputStream((InputStream)this.pfis));
            zipstream.getNextEntry();
            ObjectInputStream stream = new ObjectInputStream(zipstream);
            OBOSession history = (OBOSession)stream.readObject();
            history.setNeedsSave(false);
            history.setLoadRemark(IOUtil.getShortName((String)this.path));
            return history;
        }
        catch (Exception e) {
            throw new DataAdapterException((Throwable)e, "Load error");
        }
    }

    public OBOSession write(OBOSession history) throws DataAdapterException {
        try {
            ZipOutputStream zipstream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.path)));
            ZipEntry entry = new ZipEntry("main");
            zipstream.putNextEntry(entry);
            zipstream.setLevel(5);
            ReusableProgressEvent rpe = new ReusableProgressEvent((Object)this);
            rpe.setFastVal(-1);
            rpe.setDescription("Writing file...");
            this.fireProgressEvent((ProgressEvent)rpe);
            ObjectOutputStream stream = new ObjectOutputStream(zipstream);
            stream.writeObject(history);
            stream.close();
            history.setNeedsSave(false);
            return history;
        }
        catch (Exception e) {
            throw new DataAdapterException((Throwable)e, "Write error");
        }
    }

    public String getTermText(IdentifiedObject term) throws DataAdapterException {
        final StringBuffer buffer = new StringBuffer();
        OutputStream os = new OutputStream(){

            public void write(int b) {
                buffer.append((char)b);
            }
        };
        try {
            ObjectOutputStream stream = new ObjectOutputStream(os);
            stream.writeObject(os);
        }
        catch (IOException ex) {
            // empty catch block
        }
        return buffer.toString();
    }
}

