/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.dataadapter;

import java.net.URL;
import org.geneontology.oboedit.dataadapter.GOFlatFileParseException;
import org.geneontology.oboedit.dataadapter.GOToken;

public class GOFlatFileTokenizer {
    private static final byte SKIP = 1;
    private static final byte BOUNDARY = 2;
    private static final byte TOKEN = 4;
    private static final int INIT_ESC_BUFFER_SIZE = 1000;
    protected char[] escBuffer = new char[1000];
    public static final char escapeChar = '\\';
    String parseme;
    int currentloc;
    int lineNum;
    String filename;
    protected byte[] charstatus = new byte[65536];

    public GOFlatFileTokenizer(URL filename, String parseme, int lineNum) {
        this(filename.toString(), parseme, lineNum);
    }

    public GOFlatFileTokenizer(String filename, String parseme, int lineNum) {
        this.setStrings(filename, parseme, lineNum);
    }

    public GOFlatFileTokenizer() {
    }

    public void setStrings(String filename, String parseme, int lineNum) {
        this.filename = filename;
        this.parseme = parseme;
        this.lineNum = lineNum;
        this.currentloc = 0;
    }

    protected boolean checkStatus(char c, byte status) {
        return (this.charstatus[c] & status) > 0;
    }

    protected boolean skipGarbage() {
        int loc;
        for (loc = this.currentloc; loc < this.parseme.length() && this.checkStatus(this.parseme.charAt(loc), (byte)1); ++loc) {
        }
        boolean skippedSomething = this.currentloc != loc;
        this.currentloc = loc;
        return skippedSomething;
    }

    public GOToken getNextToken() throws GOFlatFileParseException {
        int loc;
        boolean flush = !this.skipGarbage();
        int start = this.currentloc;
        int parsemelength = this.parseme.length();
        boolean boundaryActive = false;
        char boundaryChar = '\u0000';
        if (loc >= parsemelength) {
            return null;
        }
        for (loc = this.currentloc; loc < parsemelength; ++loc) {
            char c = this.parseme.charAt(loc);
            if (c == '\\') {
                if (++loc < parsemelength) continue;
                throw new GOFlatFileParseException("Illegal escape character at end of line", this.filename, this.parseme, this.lineNum, this.parseme.length() - 1);
            }
            if ((this.charstatus[c] & 1) > 0) {
                this.currentloc = loc;
                break;
            }
            if ((this.charstatus[c] & 4) > 0) {
                if (start == loc) {
                    this.currentloc = loc + 1;
                    return new GOToken(c + "", this.filename, this.parseme, this.lineNum, loc + 1, flush);
                }
                this.currentloc = loc;
                break;
            }
            if (boundaryActive && boundaryChar == c) {
                this.currentloc = ++loc;
                break;
            }
            if ((this.charstatus[c] & 2) <= 0) continue;
            boundaryChar = c;
            boundaryActive = true;
        }
        if (loc >= parsemelength) {
            this.currentloc = loc + 1;
        }
        return new GOToken(this.unescape(this.parseme, start, loc), this.filename, this.parseme, this.lineNum, start + 1, flush);
    }

    public String unescape(String in, int start, int end) {
        int length = 0;
        for (int i = start; i < end; ++i) {
            char c = in.charAt(i);
            if (c == '\\') {
                c = in.charAt(++i);
            }
            this.insert(length, c);
            ++length;
        }
        return new String(this.escBuffer, 0, length);
    }

    protected void insert(int loc, char c) {
        if (loc >= this.escBuffer.length) {
            char[] newBuffer = new char[this.escBuffer.length * 2];
            for (int i = 0; i < this.escBuffer.length; ++i) {
                newBuffer[i] = this.escBuffer[i];
            }
            this.escBuffer = newBuffer;
        }
        this.escBuffer[loc] = c;
    }

    public void addTokenChar(char ch) {
        this.charstatus[ch] = (byte)(this.charstatus[ch] | 1);
    }

    public void addBoundaryChar(char ch) {
        this.charstatus[ch] = (byte)(this.charstatus[ch] | 2);
    }

    public void addKeeperTokenChar(char ch) {
        this.charstatus[ch] = (byte)(this.charstatus[ch] | 4);
    }
}

