/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.dataadapter;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.geneontology.io.IOUtil;
import org.geneontology.oboedit.dataadapter.OBOMetaData;
import org.geneontology.oboedit.dataadapter.OBOParseEngine;
import org.geneontology.oboedit.dataadapter.OBOParseException;
import org.geneontology.oboedit.dataadapter.OBOParser;
import org.geneontology.oboedit.datamodel.AnnotatedObject;
import org.geneontology.oboedit.datamodel.CategorizedObject;
import org.geneontology.oboedit.datamodel.CommentedObject;
import org.geneontology.oboedit.datamodel.DanglingObject;
import org.geneontology.oboedit.datamodel.Datatype;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.datamodel.DbxrefedObject;
import org.geneontology.oboedit.datamodel.DefinedObject;
import org.geneontology.oboedit.datamodel.Explanation;
import org.geneontology.oboedit.datamodel.IDProfile;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Instance;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.MultiIDObject;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.NestedValue;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBORestriction;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.ObjectFactory;
import org.geneontology.oboedit.datamodel.ObsoletableObject;
import org.geneontology.oboedit.datamodel.Synonym;
import org.geneontology.oboedit.datamodel.SynonymCategory;
import org.geneontology.oboedit.datamodel.SynonymedObject;
import org.geneontology.oboedit.datamodel.TermCategory;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.Type;
import org.geneontology.oboedit.datamodel.UnknownStanza;
import org.geneontology.oboedit.datamodel.Value;
import org.geneontology.oboedit.datamodel.impl.DatatypeValueImpl;
import org.geneontology.oboedit.datamodel.impl.DefaultIDRule;
import org.geneontology.oboedit.datamodel.impl.DefaultObjectFactory;
import org.geneontology.oboedit.datamodel.impl.NamedIDProfile;
import org.geneontology.oboedit.datamodel.impl.PropertyValueImpl;
import org.geneontology.oboedit.gui.filters.CompoundFilterImpl;
import org.geneontology.oboedit.gui.filters.EqualsComparison;
import org.geneontology.oboedit.gui.filters.NamespaceSearchCriterion;
import org.geneontology.oboedit.gui.filters.ObjectFilterImpl;
import org.geneontology.oboedit.gui.filters.SelfSearchAspect;

public class DefaultOBOParser
implements OBOParser {
    protected OBOParseEngine engine;
    protected Set linkSet;
    protected Set pathSet;
    protected Set propertyValSet;
    protected Set considerSet;
    protected Set useSet;
    protected Map rangeMap;
    protected Map domainMap;
    protected Map namespaceMap;
    protected Map instanceOfHash;
    protected Map idMapping;
    protected String idPrefix = null;
    protected Stack namespaceStack;
    protected Stack pathStack;
    protected Vector unknownStanzaList;
    protected IdentifiedObject currentObject;
    protected UnknownStanza unknownStanza;
    protected String currentStanza;
    protected OBOSession session;
    protected boolean requireSubsumption = false;
    protected boolean allowDanglingParents = true;
    protected ObjectFactory objectFactory = new DefaultObjectFactory();
    protected boolean halted = false;
    protected IDProfile currentProfile;

    public DefaultOBOParser() {
        this.instanceOfHash = new HashMap();
        this.idMapping = new HashMap();
        this.propertyValSet = new HashSet();
        this.unknownStanzaList = new Vector();
        this.linkSet = new HashSet();
        this.pathSet = new HashSet();
        this.namespaceStack = new Stack();
        this.pathStack = new Stack();
        this.namespaceMap = new HashMap();
        this.rangeMap = new HashMap();
        this.domainMap = new HashMap();
        this.considerSet = new HashSet();
        this.useSet = new HashSet();
    }

    public void cancel() {
        this.halted = true;
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(ObjectFactory factory) {
        this.objectFactory = factory;
    }

    protected Namespace getDefaultNamespace() {
        Namespace out = (Namespace)this.namespaceStack.peek();
        return out;
    }

    public void setRequireSubsumption(boolean requireSubsumption) {
        this.requireSubsumption = requireSubsumption;
    }

    public void setAllowDanglingParents(boolean allowDanglingParents) {
        this.allowDanglingParents = allowDanglingParents;
    }

    public OBOSession getSession() {
        return this.session;
    }

    public void readNamespaceIDRule(String ns, String rule) {
        if (this.currentProfile == null) {
            this.currentProfile = new NamedIDProfile("<default id profile>");
        }
        if (ns == null) {
            this.currentProfile.setDefaultRule(rule);
        } else {
            DefaultIDRule idRule = new DefaultIDRule();
            ObjectFilterImpl filter = new ObjectFilterImpl();
            filter.setAspect(new SelfSearchAspect());
            filter.setCriterion(new NamespaceSearchCriterion());
            filter.setComparison(new EqualsComparison());
            filter.setValue(ns);
            CompoundFilterImpl cfilter = new CompoundFilterImpl();
            cfilter.addFilter(filter);
            idRule.setFilter(cfilter);
            idRule.setRule(rule);
            this.currentProfile.addRule(idRule);
        }
    }

    public void readFormatVersion(String version) {
    }

    public String getCurrentPath() {
        return (String)this.pathStack.peek();
    }

    public void readImport(String path) throws IOException, OBOParseException {
        System.err.println("currentPath = " + this.getCurrentPath() + ", path = " + path);
        System.err.println("  engine thinks current path is " + this.engine.getCurrentPath());
        URL originalURL = IOUtil.getURL((String)this.getCurrentPath());
        try {
            System.err.println("originalURL = " + originalURL);
            URL url = new URL(originalURL, path);
            path = url.toString();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        if (!this.pathSet.contains(path)) {
            this.engine.doParse(path);
        }
    }

    public void readFileVersion(String version) {
        OBOMetaData metaData = (OBOMetaData)this.session.getAdapterMetaData();
        metaData.mapFileData(this.getCurrentPath(), version);
    }

    public void readDate(Date date) {
        this.session.getCurrentHistory().setDate(date);
    }

    public void readSavedBy(String savedBy) {
        this.session.getCurrentHistory().setUser(savedBy);
    }

    public void readAutogeneratedBy(String autogeneratedBy) {
    }

    public void readRemark(String remark) {
        remark = remark.trim();
        if (this.session.getCurrentHistory().getComment() == null) {
            this.session.getCurrentHistory().setComment(remark);
        } else {
            StringTokenizer tokenizer = new StringTokenizer(this.session.getCurrentHistory().getComment(), "\n");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!token.equals(remark)) continue;
                return;
            }
            this.session.getCurrentHistory().setComment(this.session.getCurrentHistory().getComment() + "\n" + remark);
        }
    }

    public void readSubsetDef(String name, String desc) {
        TermCategory cat = this.objectFactory.createCategory(name, desc);
        this.session.addCategory(cat);
    }

    public void readSynonymCategory(String id, String name, int scope) {
        SynonymCategory cat = this.objectFactory.createSynonymCategory(id, name, scope);
        this.session.addSynonymCategory(cat);
    }

    protected IdentifiedObject getObject(String id) {
        IdentifiedObject io = this.session.getObject(this.convertID(id));
        return io;
    }

    protected static boolean isBuiltInID(String id) {
        for (int i = 0; i < OBOProperty.BUILTIN_TYPES.length; ++i) {
            if (!OBOProperty.BUILTIN_TYPES[i].getID().equals(id)) continue;
            return true;
        }
        return false;
    }

    protected String convertID(String id) {
        boolean matched = id.equals("has_end_location");
        if (this.idPrefix != null && id.indexOf(58) == -1 && !DefaultOBOParser.isBuiltInID(id)) {
            id = this.idPrefix + ":" + id;
        }
        String newid = (String)this.idMapping.get(id);
        if (matched) {
            System.err.println("    prefixed = " + id + ", newid = " + newid);
        }
        if (newid == null) {
            return id;
        }
        return newid;
    }

    protected IdentifiedObject fetchObject(String id) {
        IdentifiedObject out = this.getObject(id);
        if (out == null) {
            if (this.currentStanza.equalsIgnoreCase("typedef")) {
                out = this.objectFactory.createObject(id, OBOClass.OBO_PROPERTY, false);
            } else if (this.currentStanza.equalsIgnoreCase("term")) {
                out = this.objectFactory.createObject(id, OBOClass.OBO_CLASS, false);
            } else if (this.currentStanza.equalsIgnoreCase("instance")) {
                out = this.objectFactory.createObject(id, OBOClass.OBO_INSTANCE, false);
            }
            this.session.addObject(out);
        }
        return out;
    }

    public void readIDMapping(String originalid, String newid) throws OBOParseException {
        if (this.idMapping.containsKey(originalid) && !this.idMapping.get(originalid).equals(newid)) {
            throw new OBOParseException("Multiple mappings assigned to " + originalid, this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        this.idMapping.put(originalid, newid);
    }

    public void readIDPrefix(String prefix) throws OBOParseException {
        if (this.idPrefix != null && !this.idPrefix.equals(prefix)) {
            throw new OBOParseException("Multiple id-prefixes defined", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum(), 0);
        }
        this.idPrefix = prefix;
        Iterator it = this.session.getObjects().iterator();
        while (it.hasNext()) {
            IdentifiedObject io = (IdentifiedObject)it.next();
            String convertedID = this.convertID(io.getID());
            if (convertedID.equals(io.getID())) continue;
            this.idMapping.put(convertedID, io.getID());
        }
    }

    public void readID(String id, NestedValue nv) {
        id = this.convertID(id);
        this.currentObject = this.fetchObject(id);
        this.currentObject.setIDExtension(nv);
        this.session.addObject(this.currentObject);
    }

    public void readName(String name, NestedValue nv) {
        this.currentObject.setName(name);
        this.currentObject.setNameExtension(nv);
    }

    public void readRange(String range, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof OBOProperty)) {
            throw new OBOParseException("Attempt to set range of non-type " + this.currentObject + ".", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        this.rangeMap.put(this.currentObject, range);
    }

    public void readDomain(String domain, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof OBOProperty)) {
            throw new OBOParseException("Attempt to set domain of non-type " + this.currentObject + ".", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        this.domainMap.put(this.currentObject, domain);
    }

    public void readAltID(String id, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof MultiIDObject)) {
            throw new OBOParseException("Attempted to add secondary id to object " + this.currentObject + " which does not support secondary " + "ids.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        ((MultiIDObject)this.currentObject).addSecondaryID(id);
        if (nv != null) {
            ((MultiIDObject)this.currentObject).addSecondaryIDExtension(id, nv);
        }
    }

    public void readComment(String comment, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof CommentedObject)) {
            throw new OBOParseException("Attempted to set comment of object " + this.currentObject + " which does not support comments.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        ((CommentedObject)this.currentObject).setComment(comment);
        ((CommentedObject)this.currentObject).setCommentExtension(nv);
    }

    public void readInstanceOf(String termID, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof Instance)) {
            throw new OBOParseException("Attempted to set instance_of value for non-instance " + this.currentObject, this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        InstanceStruct is = new InstanceStruct(termID, nv, this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        this.instanceOfHash.put(this.convertID(this.currentObject.getID()), is);
    }

    public void readPropertyValue(String propID, String val, String typeID, boolean quoted, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof Instance)) {
            throw new OBOParseException("Attempted to set instance_of value for non-instance " + this.currentObject, this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        PropertyValStruct pvs = new PropertyValStruct(this.currentObject.getID(), propID, val, typeID, nv, this.getCurrentPath(), quoted, this.engine.getCurrentLine(), this.engine.getLineNum());
        this.propertyValSet.add(pvs);
    }

    protected Synonym getSynonym(String name, OBOParser.XrefPair[] xrefs, int type, String catID, NestedValue nv) throws OBOParseException {
        Synonym s = this.objectFactory.createSynonym(name, type);
        s.setNestedValue(nv);
        if (catID != null) {
            SynonymCategory synCat = this.session.getSynonymCategory(catID);
            if (synCat == null) {
                throw new OBOParseException("Unrecognized category id " + catID + " found", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
            }
            s.setSynonymCategory(synCat);
        }
        for (int i = 0; i < xrefs.length; ++i) {
            Dbxref ref = this.getDbxref(xrefs[i], 1);
            s.addDbxref(ref);
        }
        return s;
    }

    protected Dbxref getDbxref(OBOParser.XrefPair pair, int type) {
        String id;
        String db;
        String dbx = pair.xref;
        int index = dbx.indexOf(58);
        if (index < 0) {
            db = "";
            id = dbx;
        } else {
            db = dbx.substring(0, index);
            id = dbx.substring(index + 1, dbx.length());
        }
        Dbxref ref = this.objectFactory.createDbxref(db, id, pair.desc, type, null);
        ref.setNestedValue(pair.nv);
        return ref;
    }

    public void readDef(String def, OBOParser.XrefPair[] xrefs, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof DefinedObject)) {
            throw new OBOParseException("Attempted to set definition of object " + this.currentObject + " which does not support " + "definitions.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        ((DefinedObject)this.currentObject).setDefinition(def);
        for (int i = 0; i < xrefs.length; ++i) {
            Dbxref ref = this.getDbxref(xrefs[i], 2);
            ((DefinedObject)this.currentObject).addDefDbxref(ref);
        }
        ((DefinedObject)this.currentObject).setDefinitionExtension(nv);
    }

    public void readXrefAnalog(OBOParser.XrefPair xref) throws OBOParseException {
        if (!(this.currentObject instanceof DbxrefedObject)) {
            throw new OBOParseException("Attempted to add dbxref to object " + this.currentObject + " which does not support dbxrefs.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        Dbxref ref = this.getDbxref(xref, 3);
        ((DbxrefedObject)this.currentObject).addDbxref(ref);
    }

    public void readXrefUnk(OBOParser.XrefPair xref) throws OBOParseException {
        if (!(this.currentObject instanceof DbxrefedObject)) {
            throw new OBOParseException("Attempted to add dbxref to object " + this.currentObject + " which does not support dbxrefs.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        Dbxref ref = this.getDbxref(xref, -1);
        ((DbxrefedObject)this.currentObject).addDbxref(ref);
    }

    public void readSubset(String name, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof CategorizedObject)) {
            throw new OBOParseException("Attempted to add category to object " + this.currentObject + " which does not support categories.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        TermCategory cat = this.session.getCategory(name);
        if (cat == null) {
            throw new OBOParseException("Undefined category " + name + ".", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        ((CategorizedObject)this.currentObject).addCategory(cat);
        ((CategorizedObject)this.currentObject).addCategoryExtension(cat, nv);
    }

    public void readSynonym(String name, OBOParser.XrefPair[] xrefs, int scope, String catID, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof SynonymedObject)) {
            throw new OBOParseException("Attempted to add synonym to object " + this.currentObject + " which does not support synonyms.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        ((SynonymedObject)this.currentObject).addSynonym(this.getSynonym(name, xrefs, scope, catID, nv));
    }

    public void readRelationship(String rel_type, String id, boolean necessary, boolean inverseNecessary, boolean completes, boolean implied, Integer minCardinality, Integer maxCardinality, Integer cardinality, String ns, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof LinkedObject)) {
            throw new OBOParseException("Tried to specify relationship for object " + this.currentObject + " which " + "does not support relationships.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        this.linkSet.add(new RelStruct(this.convertID(this.currentObject.getID()), this.convertID(id), this.convertID(rel_type), this.getCurrentPath(), this.engine.getLineNum(), this.engine.getCurrentLine(), necessary, inverseNecessary, completes, implied, minCardinality, maxCardinality, cardinality, ns, nv));
    }

    public void readIsa(String id, String ns, boolean completes, boolean implied, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof LinkedObject)) {
            throw new OBOParseException("Tried to specify isa for object " + this.currentObject + " which " + "does not support relationships.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        this.linkSet.add(new RelStruct(this.convertID(this.currentObject.getID()), this.convertID(id), OBOProperty.IS_A.getID(), this.getCurrentPath(), this.engine.getLineNum(), this.engine.getCurrentLine(), true, false, completes, implied, null, null, null, ns, nv));
    }

    public void readDisjoint(String id, String ns, boolean implied, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof LinkedObject)) {
            throw new OBOParseException("Tried to specify disjoint_from for object " + this.currentObject + " which " + "does not support relationships.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        this.linkSet.add(new RelStruct(this.convertID(this.currentObject.getID()), this.convertID(id), OBOProperty.DISJOINT_FROM.getID(), this.getCurrentPath(), this.engine.getLineNum(), this.engine.getCurrentLine(), true, false, false, implied, null, null, null, ns, nv));
    }

    public void readInverseOf(String id, String ns, boolean implied, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof LinkedObject)) {
            throw new OBOParseException("Tried to specify inverse_of for object " + this.currentObject + " which " + "does not support relationships.", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        this.linkSet.add(new RelStruct(this.convertID(this.currentObject.getID()), this.convertID(id), OBOProperty.INVERSE_OF.getID(), this.getCurrentPath(), this.engine.getLineNum(), this.engine.getCurrentLine(), true, false, false, implied, null, null, null, ns, nv));
    }

    public void readIsCyclic(boolean isCyclic, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof OBOProperty)) {
            throw new OBOParseException("Attempt to set cyclic attribute of non-property " + this.currentObject + ".", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        ((OBOProperty)this.currentObject).setCyclic(isCyclic);
        ((OBOProperty)this.currentObject).setCyclicExtension(nv);
    }

    public void readIsTransitive(boolean isTransitive, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof OBOProperty)) {
            throw new OBOParseException("Attempt to set transitive attribute of non-type " + this.currentObject + ".", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        ((OBOProperty)this.currentObject).setTransitive(isTransitive);
        ((OBOProperty)this.currentObject).setTransitiveExtension(nv);
    }

    public void readIsSymmetric(boolean isSymmetric, NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof OBOProperty)) {
            throw new OBOParseException("Attempt to set symmetric attribute of non-type " + this.currentObject + ".", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        ((OBOProperty)this.currentObject).setSymmetric(isSymmetric);
        ((OBOProperty)this.currentObject).setSymmetricExtension(nv);
    }

    public void readIsAnonymous(NestedValue nv) {
        this.currentObject.setIsAnonymous(true);
        this.currentObject.setAnonymousExtension(nv);
    }

    public void readIsObsolete(NestedValue nv) throws OBOParseException {
        if (!(this.currentObject instanceof ObsoletableObject)) {
            throw new OBOParseException("Attempt to obsolete non-obsoletable object " + this.currentObject + ".", this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum());
        }
        this.session.addObsoleteObject((ObsoletableObject)this.currentObject);
        ((ObsoletableObject)this.currentObject).setObsoleteExtension(nv);
    }

    public void readReplacedBy(String id, NestedValue nv) {
        this.useSet.add(new BasicMapping(this.currentObject.getID(), id, nv, this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum()));
    }

    public void readConsider(String id, NestedValue nv) {
        this.considerSet.add(new BasicMapping(this.currentObject.getID(), id, nv, this.getCurrentPath(), this.engine.getCurrentLine(), this.engine.getLineNum()));
    }

    public void startParse() {
        this.halted = false;
        this.linkSet.clear();
        this.pathSet.clear();
        this.rangeMap.clear();
        this.domainMap.clear();
        this.unknownStanzaList.clear();
        this.namespaceMap.clear();
        this.useSet.clear();
        this.considerSet.clear();
        this.currentProfile = null;
        this.session = this.objectFactory.createSession();
        this.session.setAdapterMetaData(new OBOMetaData());
    }

    public void readDefaultNamespace(String ns) throws OBOParseException {
        Namespace n = this.getDefaultNamespace();
        this.namespaceMap.remove(n.getID());
        Namespace mapped = (Namespace)this.namespaceMap.get(ns);
        if (mapped != null) {
            this.namespaceStack.pop();
            this.namespaceStack.push(mapped);
        } else {
            n.setID(ns);
            this.namespaceMap.put(n.getID(), n);
        }
    }

    public void readNamespace(String ns, NestedValue nv) {
        Namespace n = (Namespace)this.namespaceMap.get(ns);
        if (n == null) {
            Namespace def = this.getDefaultNamespace();
            n = this.objectFactory.createNamespace(ns, def.getPath());
            this.session.addNamespace(n);
        }
        this.currentObject.setNamespace(n);
    }

    public void startFileParse(String uri) {
        this.pathSet.add(uri);
        Namespace ns = (Namespace)this.namespaceMap.get(uri);
        if (ns == null) {
            ns = this.objectFactory.createNamespace(uri, uri);
            this.namespaceMap.put(uri, ns);
            this.session.addNamespace(ns);
        }
        OBOMetaData metaData = (OBOMetaData)this.session.getAdapterMetaData();
        metaData.mapFileData(uri, null);
        this.namespaceStack.push(ns);
        this.pathStack.push(uri);
    }

    public void endFileParse(String uri) {
        if (this.currentObject != null && this.currentObject.getNamespace() == null && this.getDefaultNamespace() != null) {
            this.currentObject.setNamespace(this.getDefaultNamespace());
        }
        this.session.setDefaultNamespace((Namespace)this.namespaceStack.pop());
        this.idMapping.clear();
        this.idPrefix = null;
        this.pathStack.pop();
        this.currentStanza = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void endParse() throws OBOParseException {
        IdentifiedObject object;
        IdentifiedObject subject;
        BasicMapping bm;
        DanglingObject dangling;
        OBOProperty t;
        Iterator<Object> it = this.linkSet.iterator();
        ArrayList<Object> danglingViolations = new ArrayList<Object>();
        while (it.hasNext()) {
            OBORestriction tr;
            IdentifiedObject type;
            IdentifiedObject parent;
            IdentifiedObject child;
            RelStruct rs;
            block69: {
                if (this.halted) {
                    throw new OBOParseException("Operation cancelled by user", null, null, -1);
                }
                rs = (RelStruct)it.next();
                child = this.getObject(rs.getChild());
                parent = this.getObject(rs.getParent());
                type = this.getObject(rs.getType());
                if (parent == null) {
                    if (this.allowDanglingParents) {
                        parent = this.objectFactory.createDanglingObject(rs.getParent());
                        this.session.addObject(parent);
                        System.err.println("added dangling object " + parent);
                        break block69;
                    } else {
                        danglingViolations.add(rs);
                        continue;
                    }
                }
                if (!(parent instanceof LinkedObject)) {
                    throw new OBOParseException("Tried to link to object " + rs.getParent() + " that does not " + "support linking.", rs.getPath(), rs.getLine(), rs.getLineNum());
                }
            }
            if (type == null) {
                throw new OBOParseException("Unrecognized type " + rs.getType(), rs.getPath(), rs.getLine(), rs.getLineNum());
            }
            if (!(type instanceof OBOProperty)) {
                throw new OBOParseException("Tried to use non-type " + rs.getType() + " as relationship " + "type", rs.getPath(), rs.getLine(), rs.getLineNum());
            }
            Namespace ns = null;
            if (rs.getNamespace() != null) {
                ns = (Namespace)this.namespaceMap.get(rs.getNamespace());
                System.err.println("read namespace " + rs.getNamespace() + " for link, fetched namespace " + ns);
                if (ns == null) {
                    ns = this.objectFactory.createNamespace(rs.getNamespace(), null);
                    this.namespaceMap.put(rs.getNamespace(), ns);
                    this.session.addNamespace(ns);
                }
            }
            if ((tr = this.objectFactory.createOBORestriction((LinkedObject)child, (OBOProperty)type, (LinkedObject)parent, rs.isImplied(), Explanation.GIVEN_EXPLANATION)).isImplied()) {
                System.err.println("loaded implied rel " + tr);
            }
            tr.setNecessarilyTrue(rs.isNecessary());
            tr.setInverseNecessarilyTrue(rs.isInverseNecessary());
            tr.setNestedValue(rs.getNestedValue());
            tr.setCompletes(rs.completes());
            tr.setMaxCardinality(rs.getMaxCardinality());
            tr.setMinCardinality(rs.getMinCardinality());
            tr.setCardinality(rs.getCardinality());
            if (ns != null && !ns.equals(child.getNamespace())) {
                tr.setNamespace(ns);
            }
            tr.getParent().addChild(tr);
        }
        it = this.rangeMap.keySet().iterator();
        while (it.hasNext()) {
            if (this.halted) {
                throw new OBOParseException("Operation cancelled by user", null, null, -1);
            }
            t = (OBOProperty)it.next();
            String rangeID = (String)this.rangeMap.get(t);
            IdentifiedObject o = this.getObject(rangeID);
            if (o == null) {
                if (!this.allowDanglingParents) {
                    throw new OBOParseException("Assigned non-existant range id " + rangeID + " to term " + t.getID(), null, null, -1);
                }
                dangling = this.objectFactory.createDanglingObject(rangeID);
                System.err.println("assigned DANGLING " + dangling + " to property " + t.getID());
                t.setRange(dangling);
                System.err.println("      range = " + t.getRange());
                continue;
            }
            if (!(o instanceof Type)) {
                throw new OBOParseException("Assigned non-type to range of term " + t.getID(), null, null, -1);
            }
            t.setRange((Type)o);
        }
        it = this.domainMap.keySet().iterator();
        while (it.hasNext()) {
            if (this.halted) {
                throw new OBOParseException("Operation cancelled by user", null, null, -1);
            }
            t = (OBOProperty)it.next();
            String domainID = (String)this.domainMap.get(t);
            IdentifiedObject domain = this.getObject(domainID);
            if (domain == null) {
                if (!this.allowDanglingParents) {
                    throw new OBOParseException("Assigned non-existant domain id " + domainID + " to term " + t.getID(), null, null, -1);
                }
                dangling = this.objectFactory.createDanglingObject(domainID);
                t.setDomain(dangling);
                continue;
            }
            if (!(domain instanceof OBOClass)) {
                throw new OBOParseException("Cannot use non-term " + domain + " as domain value.", null, null, -1);
            }
            t.setDomain(domain);
        }
        it = this.instanceOfHash.keySet().iterator();
        while (it.hasNext()) {
            if (this.halted) {
                throw new OBOParseException("Operation cancelled by user", null, null, -1);
            }
            String id = (String)it.next();
            InstanceStruct is = (InstanceStruct)this.instanceOfHash.get(id);
            IdentifiedObject instance = this.getObject(id);
            if (instance == null) {
                throw new OBOParseException("Unexpected condition, unrecognized instance " + id + " found", is.getPath(), is.getLine(), is.getLineNum());
            }
            IdentifiedObject instanceOfObj = this.getObject(is.instanceOf);
            if (instanceOfObj == null) {
                throw new OBOParseException("Unrecognized instance_of id " + is.instanceOf + " specified for " + "instance id " + id, is.getPath(), is.getLine(), is.getLineNum());
            }
            if (!(instanceOfObj instanceof OBOClass)) {
                throw new OBOParseException("Cannot use non-term value " + is.instanceOf + ", " + "for instance_of statement.", is.getPath(), is.getLine(), is.getLineNum());
            }
            ((Instance)instance).setType((OBOClass)instanceOfObj);
        }
        it = this.propertyValSet.iterator();
        while (it.hasNext()) {
            if (this.halted) {
                throw new OBOParseException("Operation cancelled by user", null, null, -1);
            }
            PropertyValStruct pvs = (PropertyValStruct)it.next();
            Instance instance = (Instance)this.getObject(pvs.instanceID);
            AnnotatedObject prop_o = (AnnotatedObject)this.session.getObject(pvs.propID);
            if (instance == null) {
                throw new OBOParseException("Unexpected condition encountered. Missing instance.", pvs.getPath(), pvs.getLine(), pvs.getLineNum());
            }
            if (prop_o == null) {
                throw new OBOParseException("Unrecognized property " + pvs.propID, pvs.getPath(), pvs.getLine(), pvs.getLineNum());
            }
            if (!(prop_o instanceof OBOProperty)) {
                throw new OBOParseException("Non-property " + pvs.propID + " specified as" + "property.", pvs.getPath(), pvs.getLine(), pvs.getLineNum());
            }
            OBOProperty prop = (OBOProperty)prop_o;
            IdentifiedObject type_o = this.session.getObject(pvs.typeID);
            if (pvs.quoted) {
                if (pvs.typeID == null) {
                    type_o = Datatype.STRING;
                }
                if (type_o == null) {
                    throw new OBOParseException("Unrecognized datatype " + pvs.typeID, pvs.getPath(), pvs.getLine(), pvs.getLineNum());
                }
                if (!(type_o instanceof Datatype)) {
                    throw new OBOParseException("Non-datatype " + pvs.typeID + " specified " + "as datatype", pvs.getPath(), pvs.getLine(), pvs.getLineNum());
                }
                Datatype type = (Datatype)type_o;
                if (!type.isLegalValue(pvs.val)) {
                    throw new OBOParseException("Illegal value " + pvs.val + "for type " + type, pvs.getPath(), pvs.getLine(), pvs.getLineNum());
                }
                if (prop.getRange() != null) {
                    if (!(prop.getRange() instanceof Datatype)) {
                        throw new OBOParseException("Datatype specified for property with non-datatype range", pvs.getPath(), pvs.getLine(), pvs.getLineNum());
                    }
                    if (!TermUtil.isSubclass(type, (Datatype)prop.getRange())) {
                        throw new OBOParseException("Datatype does not match given property range. type = " + type + ", range = " + prop.getRange(), pvs.getPath(), pvs.getLine(), pvs.getLineNum());
                    }
                }
                instance.addPropertyValue(prop, new DatatypeValueImpl(type, pvs.val));
                continue;
            }
            IdentifiedObject o = this.session.getObject(pvs.val);
            if (o == null) {
                if (this.allowDanglingParents) {
                    o = this.objectFactory.createDanglingObject(pvs.val);
                    this.session.addObject(o);
                    System.err.println("added dangling object " + o);
                } else {
                    danglingViolations.add(pvs);
                    continue;
                }
            }
            if (type_o != null) {
                throw new OBOParseException("Cannot assign a type to a non-datatype property value.", pvs.getPath(), pvs.getLine(), pvs.getLineNum());
            }
            System.err.println("pvs.val = " + pvs.val + ", o = " + o);
            if (!(o instanceof Value)) {
                throw new OBOParseException("Attempted to assign non value to a propertyValue", pvs.getPath(), pvs.getLine(), pvs.getLineNum());
            }
            instance.addPropertyValue(prop, o);
        }
        if (danglingViolations.size() <= 0) {
            it = this.useSet.iterator();
        } else {
            String message = danglingViolations.size() + " unrecognized parent terms:\n";
            int linenum = -1;
            String line = null;
            String path = null;
            String parent = null;
            for (int i = 0; i < 20 && i < danglingViolations.size(); ++i) {
                Object o = danglingViolations.get(i);
                if (o instanceof RelStruct) {
                    RelStruct rs = (RelStruct)o;
                    linenum = rs.getLineNum();
                    line = rs.getLine();
                    path = rs.getPath();
                    parent = rs.getParent();
                } else if (o instanceof PropertyValStruct) {
                    PropertyValStruct pvs = (PropertyValStruct)o;
                    linenum = pvs.getLineNum();
                    line = pvs.getLine();
                    path = pvs.getPath();
                    parent = pvs.val;
                }
                message = message + "     line " + linenum + ": " + parent + " of " + path + "\n";
            }
            throw new OBOParseException(message, path, line, linenum);
        }
        while (it.hasNext()) {
            if (this.halted) {
                throw new OBOParseException("Operation cancelled by user", null, null, -1);
            }
            bm = (BasicMapping)it.next();
            subject = this.session.getObject(bm.getSubject());
            if (subject == null) {
                throw new OBOParseException("Unexpected condition: subject of replaced_by " + bm.getSubject() + " disappeared!", bm.getPath(), bm.getLine(), bm.getLineNum());
            }
            if (!(subject instanceof ObsoletableObject)) {
                throw new OBOParseException("Attempted to assign replaced_by value to non-obsoletable object " + subject, bm.getPath(), bm.getLine(), bm.getLineNum());
            }
            object = this.session.getObject(bm.getObject());
            if (object == null) {
                throw new OBOParseException("Could not resolve id " + bm.getObject() + " in replaced_by " + "statement.", bm.getPath(), bm.getLine(), bm.getLineNum());
            }
            if (!(object instanceof ObsoletableObject)) {
                throw new OBOParseException("replaced_by tag has non-obsoletable value " + object, bm.getPath(), bm.getLine(), bm.getLineNum());
            }
            if (!((ObsoletableObject)subject).isObsolete()) {
                throw new OBOParseException("Attempted to specify replaced_by value for non-obsolete object " + subject + ".", bm.getPath(), bm.getLine(), bm.getLineNum());
            }
            if (((ObsoletableObject)object).isObsolete()) {
                throw new OBOParseException("Attempted to specify obsolete value " + object + " for " + "replaced_by tag.", bm.getPath(), bm.getLine(), bm.getLineNum());
            }
            ((ObsoletableObject)subject).addReplacedBy((ObsoletableObject)object);
            if (bm.getNestedValue() == null) continue;
            ((ObsoletableObject)subject).addReplacedByExtension((ObsoletableObject)object, bm.getNestedValue());
        }
        it = this.considerSet.iterator();
        while (it.hasNext()) {
            if (this.halted) {
                throw new OBOParseException("Operation cancelled by user", null, null, -1);
            }
            bm = (BasicMapping)it.next();
            subject = this.session.getObject(bm.getSubject());
            if (subject == null) {
                throw new OBOParseException("Unexpected condition: subject of consider " + bm.getSubject() + " disappeared!", bm.getPath(), bm.getLine(), bm.getLineNum());
            }
            if (!(subject instanceof ObsoletableObject)) {
                throw new OBOParseException("Attempted to assign consider value to non-obsoletable object " + subject, bm.getPath(), bm.getLine(), bm.getLineNum());
            }
            object = this.session.getObject(bm.getObject());
            if (object == null) {
                throw new OBOParseException("Could not resolve id " + bm.getObject() + " in consider " + "tag.", bm.getPath(), bm.getLine(), bm.getLineNum());
            }
            if (!(object instanceof ObsoletableObject)) {
                throw new OBOParseException("consider tag has non-obsoletable value " + object, bm.getPath(), bm.getLine(), bm.getLineNum());
            }
            if (!((ObsoletableObject)subject).isObsolete()) {
                throw new OBOParseException("Attempted to specify consider value for non-obsolete object " + subject + ".", bm.getPath(), bm.getLine(), bm.getLineNum());
            }
            if (((ObsoletableObject)object).isObsolete()) {
                throw new OBOParseException("Attempted to specify obsolete value " + object + " for " + "consider tag.", bm.getPath(), bm.getLine(), bm.getLineNum());
            }
            ((ObsoletableObject)subject).addConsiderReplacement((ObsoletableObject)object);
            if (bm.getNestedValue() == null) continue;
            ((ObsoletableObject)subject).addConsiderExtension((ObsoletableObject)object, bm.getNestedValue());
        }
        int i = 0;
        while (true) {
            if (i >= this.unknownStanzaList.size()) {
                this.session.setIDProfile(this.currentProfile);
                this.session.markRoots();
                this.linkSet.clear();
                this.namespaceMap.clear();
                this.pathSet.clear();
                return;
            }
            UnknownStanza us = (UnknownStanza)this.unknownStanzaList.get(i);
            this.session.addUnknownStanza(us);
            ++i;
        }
    }

    public void startStanza(String name) {
        if (this.currentObject != null && this.currentObject.getNamespace() == null && this.getDefaultNamespace() != null) {
            this.currentObject.setNamespace(this.getDefaultNamespace());
        }
        this.currentStanza = name;
        if (!(this.currentStanza.equalsIgnoreCase("term") || this.currentStanza.equalsIgnoreCase("typedef") || this.currentStanza.equalsIgnoreCase("instance"))) {
            this.unknownStanza = new UnknownStanza(this.currentStanza, this.getDefaultNamespace());
            this.unknownStanzaList.add(this.unknownStanza);
        } else {
            this.unknownStanza = null;
        }
    }

    public void readBangComment(String comment) {
    }

    public void readTagValue(String tag, String value) throws OBOParseException {
        PropertyValueImpl pv = new PropertyValueImpl(tag, value);
        if (this.currentStanza == null) {
            this.session.addPropertyValue(pv);
        } else if (this.unknownStanza != null) {
            this.unknownStanza.addPropertyValue(pv);
        } else {
            this.currentObject.addPropertyValue(pv);
        }
    }

    public void setParseEngine(OBOParseEngine engine) {
        this.engine = engine;
    }

    protected static class RelStruct
    implements Comparable {
        protected String child;
        protected String parent;
        protected String type;
        protected int linenum;
        protected String path;
        protected String line;
        protected String ns;
        protected NestedValue nv;
        protected boolean necessary = true;
        protected boolean inverseNecessary = false;
        protected boolean completes = false;
        protected boolean implied = false;
        protected Integer minCardinality;
        protected Integer maxCardinality;
        protected Integer cardinality;

        public int compareTo(Object b) {
            if (b instanceof RelStruct) {
                if (this.linenum < ((RelStruct)b).getLineNum()) {
                    return -1;
                }
                if (this.linenum > ((RelStruct)b).getLineNum()) {
                    return 1;
                }
                return 0;
            }
            return 1;
        }

        public RelStruct(String child, String parent, String type, String path, int linenum, String line, boolean necessary, boolean inverseNecessary, boolean completes, boolean implied, Integer minCardinality, Integer maxCardinality, Integer cardinality, String ns, NestedValue nv) {
            this.child = child;
            this.parent = parent;
            this.type = type;
            this.linenum = linenum;
            this.path = path;
            this.line = line;
            this.necessary = necessary;
            this.inverseNecessary = inverseNecessary;
            this.completes = completes;
            this.implied = implied;
            this.cardinality = cardinality;
            this.maxCardinality = maxCardinality;
            this.minCardinality = minCardinality;
            this.nv = nv;
            this.ns = ns;
        }

        public String getPath() {
            return this.path;
        }

        public Integer getMinCardinality() {
            return this.minCardinality;
        }

        public Integer getMaxCardinality() {
            return this.maxCardinality;
        }

        public Integer getCardinality() {
            return this.cardinality;
        }

        public void setNestedValue(NestedValue nv) {
            this.nv = nv;
        }

        public NestedValue getNestedValue() {
            return this.nv;
        }

        public String getNamespace() {
            return this.ns;
        }

        public boolean isNecessary() {
            return this.necessary;
        }

        public boolean isInverseNecessary() {
            return this.inverseNecessary;
        }

        public boolean isImplied() {
            return this.implied;
        }

        public boolean completes() {
            return this.completes;
        }

        public int getLineNum() {
            return this.linenum;
        }

        public String getLine() {
            return this.line;
        }

        public String getChild() {
            return this.child;
        }

        public String getParent() {
            return this.parent;
        }

        public String getType() {
            return this.type;
        }
    }

    protected static class PropertyValStruct {
        protected String instanceID;
        protected String propID;
        protected String val;
        protected String typeID;
        protected NestedValue nv;
        protected String line;
        protected int linenum;
        protected String path;
        protected boolean quoted;

        public PropertyValStruct(String instanceID, String propID, String val, String typeID, NestedValue nv, String path, boolean quoted, String line, int linenum) {
            this.instanceID = instanceID;
            this.propID = propID;
            this.val = val;
            this.typeID = typeID;
            this.nv = nv;
            this.path = path;
            this.quoted = quoted;
            this.line = line;
            this.linenum = linenum;
        }

        public boolean isQuoted() {
            return this.quoted;
        }

        public String getPath() {
            return this.path;
        }

        public String getLine() {
            return this.line;
        }

        public int getLineNum() {
            return this.linenum;
        }
    }

    protected static class InstanceStruct {
        protected String instanceOf;
        protected NestedValue nv;
        protected String path;
        protected String line;
        protected int linenum;

        public InstanceStruct(String instanceOf, NestedValue nv, String path, String line, int linenum) {
            this.instanceOf = instanceOf;
            this.path = path;
            this.line = line;
            this.linenum = linenum;
            this.nv = nv;
        }

        public String getPath() {
            return this.path;
        }

        public String getLine() {
            return this.line;
        }

        public int getLineNum() {
            return this.linenum;
        }
    }

    protected static class BasicMapping {
        protected String subject;
        protected String object;
        protected NestedValue nv;
        protected String path;
        protected String line;
        protected int linenum;

        public BasicMapping(String subject, String object, NestedValue nv, String path, String line, int linenum) {
            this.subject = subject;
            this.object = object;
            this.nv = nv;
            this.line = line;
            this.linenum = linenum;
        }

        public String getPath() {
            return this.path;
        }

        public String getLine() {
            return this.line;
        }

        public int getLineNum() {
            return this.linenum;
        }

        public String getSubject() {
            return this.subject;
        }

        public String getObject() {
            return this.object;
        }

        public NestedValue getNestedValue() {
            return this.nv;
        }
    }
}

