/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.dataadapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.geneontology.oboedit.dataadapter.IDGenerator;
import org.geneontology.oboedit.datamodel.IDProfile;
import org.geneontology.oboedit.datamodel.IDRule;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.MultiIDObject;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.impl.NamedIDProfile;

public class DefaultIDGenerator
implements IDGenerator {
    protected IDProfile profile;
    protected IDProfile defaultProfile = new NamedIDProfile("<default profile>");

    protected static List matchSequence(String s, List sequence, LinkedObject lo) {
        LinkedList<TermUtil.VariableValue> out = new LinkedList<TermUtil.VariableValue>();
        Iterator it = sequence.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof String) {
                if (!s.startsWith((String)o)) {
                    return null;
                }
                s = s.substring(((String)o).length(), s.length());
                continue;
            }
            if (!(o instanceof TermUtil.Variable)) continue;
            TermUtil.Variable v = (TermUtil.Variable)o;
            if (v.getName().equals("sequence")) {
                int length = 0;
                if (v.getParams().size() > 0) {
                    try {
                        length = Integer.parseInt((String)v.getParams().get(0));
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
                if (length > s.length()) {
                    length = s.length();
                }
                for (int i = 0; i < length; ++i) {
                    if (Character.isDigit(s.charAt(i))) continue;
                    return null;
                }
                out.add(new TermUtil.VariableValue((TermUtil.Variable)o, s.substring(0, length)));
                s = s.substring(length, s.length());
                continue;
            }
            if (!v.getName().equals("id")) continue;
            if (lo == null) {
                out.add(new TermUtil.VariableValue((TermUtil.Variable)o, ""));
                continue;
            }
            if (!s.startsWith(lo.getID())) continue;
            s = s.substring(lo.getID().length(), s.length());
            out.add(new TermUtil.VariableValue((TermUtil.Variable)o, lo.getID()));
        }
        return out;
    }

    public DefaultIDGenerator() {
        this.defaultProfile.setDefaultRule("id:$sequence(7)$");
    }

    public void setProfile(IDProfile profile) {
        this.profile = profile;
    }

    public IDProfile getProfile() {
        if (this.profile == null) {
            return this.defaultProfile;
        }
        return this.profile;
    }

    public static String padNum(int val, int length) {
        StringBuffer out = new StringBuffer();
        out.append(val);
        for (int i = 1; i < length; ++i) {
            if ((int)Math.pow(10.0, i) <= val) continue;
            out.insert(0, "0");
        }
        return out.toString();
    }

    public static String resolveVar(TermUtil.Variable v, List valueList, LinkedObject lo) {
        if (v.getName().equals("sequence")) {
            int lowVal = 0;
            int highVal = Integer.MAX_VALUE;
            int padVal = 8;
            if (v.getParams().size() > 0) {
                try {
                    padVal = Integer.parseInt((String)v.getParams().get(0));
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            if (v.getParams().size() > 1) {
                try {
                    lowVal = Integer.parseInt((String)v.getParams().get(1));
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            if (v.getParams().size() > 2) {
                try {
                    highVal = Integer.parseInt((String)v.getParams().get(2));
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            int tentative = lowVal;
            Iterator it = valueList.iterator();
            while (it.hasNext()) {
                Integer io = (Integer)it.next();
                int val = io;
                if (val < tentative) continue;
                if (val == tentative) {
                    ++tentative;
                    continue;
                }
                if (val <= tentative) continue;
                break;
            }
            if (tentative > highVal) {
                return null;
            }
            return DefaultIDGenerator.padNum(tentative, padVal);
        }
        if (v.getName().equals("id")) {
            if (lo == null) {
                return "";
            }
            return lo.getID();
        }
        return null;
    }

    public static Collection getIDs(OBOSession session) {
        HashSet<String> allReserved = new HashSet<String>();
        Iterator it = session.getObjects().iterator();
        while (it.hasNext()) {
            IdentifiedObject io = (IdentifiedObject)it.next();
            allReserved.add(io.getID());
            if (!(io instanceof MultiIDObject)) continue;
            Iterator it2 = ((MultiIDObject)io).getSecondaryIDs().iterator();
            while (it2.hasNext()) {
                String s = (String)it2.next();
                allReserved.add(s);
            }
        }
        return allReserved;
    }

    public String generateID(OBOSession session, String currentRule, LinkedObject lo, Collection reservedIDs, boolean temporary) {
        Collection allReserved = DefaultIDGenerator.getIDs(session);
        if (reservedIDs != null) {
            allReserved.addAll(reservedIDs);
        }
        return this.generateID(currentRule, lo, allReserved, temporary);
    }

    public String generateID(String currentRule, LinkedObject lo, Collection reservedIDs, boolean temporary) {
        Iterator it;
        List list = TermUtil.parseVarString(currentRule);
        if (list == null) {
            return null;
        }
        LinkedList<List> matchList = new LinkedList<List>();
        if (reservedIDs != null) {
            it = reservedIDs.iterator();
            while (it.hasNext()) {
                String id = (String)it.next();
                List seqMatch = DefaultIDGenerator.matchSequence(id, list, lo);
                if (seqMatch == null) continue;
                matchList.add(seqMatch);
            }
        }
        it = list.iterator();
        StringBuffer out = new StringBuffer();
        int varIndex = 0;
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof String) {
                out.append((String)o);
                continue;
            }
            if (!(o instanceof TermUtil.Variable)) continue;
            ArrayList<Integer> valueList = new ArrayList<Integer>();
            Iterator it2 = matchList.iterator();
            while (it2.hasNext()) {
                List varMatches = (List)it2.next();
                TermUtil.VariableValue vv = (TermUtil.VariableValue)varMatches.get(varIndex);
                try {
                    valueList.add(new Integer(vv.getValue()));
                }
                catch (NumberFormatException ex) {}
            }
            Collections.sort(valueList);
            String varVal = DefaultIDGenerator.resolveVar((TermUtil.Variable)o, valueList, lo);
            if (varVal == null) {
                return null;
            }
            out.append(varVal);
            ++varIndex;
        }
        return out.toString();
    }

    public String generateID(OBOSession session, LinkedObject lo, Collection reservedIDs, boolean temporary) {
        String currentRule = null;
        if (!temporary) {
            if (lo != null) {
                Iterator it = this.profile.getRules().iterator();
                while (it.hasNext()) {
                    IDRule pair = (IDRule)it.next();
                    if (!pair.getFilter().satisfies(lo)) continue;
                    currentRule = pair.getRule();
                    break;
                }
            }
            if (currentRule == null) {
                currentRule = this.profile.getDefaultRule();
            }
        } else {
            currentRule = "__temp__$sequence(10)$__";
        }
        return this.generateID(session, currentRule, lo, reservedIDs, temporary);
    }
}

